// my_select_2(input node, tab={}, urlAjaxData, on change function)
// tab is [{id:x,text:'text'}]
function my_select_2(inp, arr,urlAjax=false,onChange=function(e){}) {

  /*the autocomplete function takes two arguments,
  the text field element and an array of possible autocompleted values:*/
  var currentFocus;
  var select = document.createElement("select");
  var inp_name = inp.getAttribute('name');
  var inp_id = inp.getAttribute('id');
  //div.appendChild(b);
  inp.setAttribute('name','');
  select.setAttribute("name", inp_name );
  select.setAttribute("id", inp_id+"-autocomplete-select");
  select.style.display='none';
  var listeE = document.createElement("DIV");
  //listeE.style.width =
  var w = inp.offsetWidth?(inp.offsetWidth+'px'):'100%';
  listeE.setAttribute('style','position:relative;width:'+w);
  //listeE.offsetWidth = inp.offsetWidth;
  listeE.style.position='relative';
  
  inp.parentNode.insertBefore(select, inp.nextSibling);
    // setting listeE as parent node on inp
    var element = inp;
    var parent = element.parentNode;
    var wrapper = listeE;//document.createElement('div');

    // set the wrapper as child (instead of the element)
    parent.replaceChild(wrapper, element);
    // set element as child of wrapper
    wrapper.appendChild(element);

  //inp.parentNode.insertBefore(listeE, inp.nextSibling);

  /*execute a function when someone writes in the text field:*/
  select.addEventListener("change", function(e) {
      var val = this.value;
      onChange(val);
  })

  inp.addEventListener("input", function(e) {
      var a, b, i, val = this.value;
      /*close any already open lists of autocompleted values*/
      closeAllLists();
      if (!val) { return false;}
      currentFocus = -1;
      /*create a DIV element that will contain the items (values):*/
      a = document.createElement("DIV");
      a.setAttribute("id", this.id + "autocomplete-list");
      a.setAttribute("class", "autocomplete-items");
      select.innerHTML = "";
      
      /*append the DIV element as a child of the autocomplete container:*/
      //this.parentNode.appendChild(a);
      listeE.appendChild(a);
      /*for each item in the array...*/
      var xmlhttp = new XMLHttpRequest();
      if(urlAjax){
        xmlhttp.onreadystatechange = function() {
            if (this.readyState == 4 && this.status == 200) {
                var myArr = JSON.parse(this.responseText);
                filtrer(myArr,b,a);
            }
        };
        xmlhttp.open("GET", urlAjax+inp.value, true);
        xmlhttp.send();
      }
      else{
        filtrer(arr,b,a);
       }
      
  });
  
  function filtrer(tableau,b,div){
      var val = inp.value;
      for (i = 0; i < tableau.length; i++) {
          var idd = tableau[i].id?tableau[i].id:tableau[i].t_id;
          var texte = '';
          for(d in tableau[i]){
            if(d!='id' && d!='t_id')texte += (tableau[i][d]===null?'':tableau[i][d])+' ';
          }
          /*check if the item starts with the same letters as the text field value:*/
          if (urlAjax || texte.substr(0, val.length).toUpperCase() == val.toUpperCase()) {
            /*create a DIV element for each matching element:*/
            b = document.createElement("DIV");
            /*make the matching letters bold:*/
            //b.innerHTML = "<strong>" + texte.substr(0, val.length) + "</strong>";
            b.innerHTML += texte.replace(val,"<strong>" +val + "</strong>");
            //substr(val.length);
            /*insert a input field that will hold the current array item's value:*/
            b.innerHTML += "<span style='display:none' di=\"" + idd + "\">" + texte + "</span>";
            /*execute a function when someone clicks on the item value (DIV element):*/
            b.addEventListener("click", function(e) {
                /*insert the value for the autocomplete text field:*/
                var ipt = this.getElementsByTagName("span")[0];
                var v = ipt.innerText;
                var id = ipt.getAttribute('di');
                inp.value = v;
                var option = "<option selected='selected' value='"+id+"'>"+v+"</option>";
                select.innerHTML = option;
                select.dispatchEvent(new Event('change'));
                /*close the list of autocompleted values,
                (or any other open lists of autocompleted values:*/
                closeAllLists();
            });
            
            div.appendChild(b);
          }
      }
  }
  
  /*execute a function presses a key on the keyboard:*/
  
  /*execute a function presses a key on the keyboard:*/
  inp.addEventListener("keydown", function(e) {
    var x = document.getElementById(this.id + "autocomplete-list");
      if (x) x = x.getElementsByTagName("div");
      if (e.keyCode == 40) {
        /*If the arrow DOWN key is pressed,
        increase the currentFocus variable:*/
        currentFocus++;
        /*and and make the current item more visible:*/
        addActive(x);
      } else if (e.keyCode == 38) { //up
        /*If the arrow UP key is pressed,
        decrease the currentFocus variable:*/
        currentFocus--;
        /*and and make the current item more visible:*/
        addActive(x);
      } else if (e.keyCode == 13) {
        /*If the ENTER key is pressed, prevent the form from being submitted,*/
        e.preventDefault();
        if (currentFocus > -1) {
          /*and simulate a click on the "active" item:*/
          if (x) x[currentFocus].click();
        }
      }
  });
  function addActive(x) {
    /*a function to classify an item as "active":*/
    if (!x) return false;
    /*start by removing the "active" class on all items:*/
    removeActive(x);
    if (currentFocus >= x.length) currentFocus = 0;
    if (currentFocus < 0) currentFocus = (x.length - 1);
    /*add class "autocomplete-active":*/
    x[currentFocus].classList.add("autocomplete-active");
  }
  function removeActive(x) {
    /*a function to remove the "active" class from all autocomplete items:*/
    for (var i = 0; i < x.length; i++) {
      x[i].classList.remove("autocomplete-active");
    }
  }
  function closeAllLists(elmnt) {
    /*close all autocomplete lists in the document,
    except the one passed as an argument:*/
    var x = document.getElementsByClassName("autocomplete-items");
    for (var i = 0; i < x.length; i++) {
      if (elmnt != x[i] && elmnt != inp) {
        x[i].parentNode.removeChild(x[i]);
      }
    }
    //select = document.getElementById("select");
     if(select.innerHTML == "" && inp.value!='' && inp !== document.activeElement){
    	inp.classList.add("no-much");//olor='red';
    
    }
    else inp.classList.remove("no-much");
  }
  /*execute a function when someone clicks in the document:*/
  document.addEventListener("click", function (e) {
      closeAllLists(e.target);
  });

}
