<?php 
 use App\Masomwetu\Scholar\MsClasse;
 
use App\Http\Middleware\CheckUserSecteur;
use App\Http\Middleware\IsComptaUser;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
// use Maatwebsite\Excel\Excel;
// symlink('/home/delaqvyy/bulletin.delardc.com/project_src/storage/app/public',  '//home/delaqvyy/bulletin.delardc.com/storage');
// dd(App\Masomwetu\Comptabilite\Compte::with('compteParent.compteParent.compteParent')->find(1));
ini_set('max_execution_time', '700'); //300 seconds = 5 minutes
Route::get('/', function () {
	
    return view('login');		
})->name('ms.login')->middleware('guest');;

include('maishapay.php');

require_once 'dompdf/vendor/autoload.php'; 

Route::post ('/profile/choix/filier','EleveController@choisir_section')->name('profile.choix.filier');
Route::get ('/profile/eleve/','EleveController@index')->name('profile.eleve');
Route::get ('/profile/fiche', 'EleveController@fiche_reseignement')->name('profile.fiche');
Route::get ('/profile/choix/section', 'EleveController@fiche_reseignement')->name('profile.choix.cotes');
Route::get ('/macarte/{id?}', 'MScholarController@imprimer_macarte')->name('scholar.eleves.macarte');
Route::get ('/solder-paiement-retard/{id_eleve?}', 'MPaymentController@payer_les_frais_en_retard')->name('scholar.eleves.macarte');
		
Route::get ('/comptabilite/login/','ComptaController@login')->name('compta.login')->middleware('guest');
Route::post ('/comptabilite/login/','ComptaController@login')->name('compta.login')->middleware('guest');
Route::get ('/comptabilite/','ComptaController@login')->name('compta.login')->middleware('guest');
Route::post('/comptabilite/','ComptaController@login')->name('compta.login')->middleware('guest');
	
Route::get ('/scanne-presence/mobile/{agent_id}','PersonnelPresenceController@scanne_presence');
Route::get ('/scanne-presence/mobile/eleve/{ms_eleve_id}','MDisciplinaryController@marquer_presence_eleve');
Route::post('/mobile/login/','MobileLoginController@login')->name('mobile.login');
Route::get ('/mobile/login/','MobileLoginController@showLoginForm')->name('mobile.login');
Route::get ('/mobile/home/','HomeController@mobile_home')->name('mobile.home');

// scan pour verification
Route::get ('/scan/verification/','ScanController@scan_verification')->name('scan.verification');
Route::post ('/scan/verification/frais','ScanController@eleve_en_ordre_avec_frais')->name('scan.verification.frais');

		
Route::group([ 'middleware' => 'auth'], function(){
	// route du module de comptabilite avancee
	Route::get ('/comptabilite/login_tocken','ComptaController@login_tocken')->name('compta.login.tocken');
	Route::post('/comptabilite/login_tocken','ComptaController@login_tocken')->name('compta.login.tocken');
	Route::post ('/comptabilite/logout/','ComptaController@logout')->name('compta.logout');
	Route::group([ 'middleware' => 'is.compta.tocken.checked'], function(){
		Route::group([ 'middleware' => 'is.compta.user'], function(){
			Route::get ('/comptabilite/index/','ComptaController@index')->name('compta.index');
			Route::get ('/comptabilite/codification/','ComptaController@codification')->name('compta.codification');
			Route::get ('/comptabilite/entree/sorite/','ComptaController@entree_sorties')->name('compta.entre.sortie');
			Route::get ('/comptabilite/rapport/journalier/','ComptaController@rapport_journalier')->name('compta.rapport.journalier');
			Route::get ('/comptabilite/rapport/mensuel/','ComptaController@rapport_mensuel')->name('compta.rapport.mensuel');
			Route::get ('/comptabilite/rapport/global/','ComptaController@rapport_global')->name('compta.rapport.global');
			Route::get ('/comptabilite/prevision/','ComptaController@prevision')->name('compta.prevision');
			Route::post('/comptabilite/prevision/','ComptaController@prevision')->name('compta.prevision');
		});
	});

	// la porte d'entrée principale après authentification
	Route::get('/home', 'HomeController@index')->name('home');
	Route::get('/changer/annee', 'HomeController@changer_annee')->name('changer.annee');
	Route::get('/home/ecole/{ecole_id}', 'HomeController@home_ecole')->name('home.ecole');
	
	// == MASOMWETU URL
	Route::get('/ms/tuteur/phone/{phone?}', 'MasomwetuController@findTuteurByPhone')->name('ms.tuteur.with.phone');
	Route::get('/ms/enfant/matricule/{matricule?}', 'MasomwetuController@findEnfantByMatricule')->name('ms.enfant.with.matricule');
	Route::get('/M-Scholar/{sysUserRole}', 'MasomwetuController@m_scholar')->name('login.M-Scholar');
	Route::get('/M-Salary/{sysUserRole}', 'MasomwetuController@m_salary')->name('login.M-Salary');
	Route::get('/M-Payment/{sysUserRole}', 'MasomwetuController@m_payment')->name('login.M-Payment');
	Route::get('/M-Disciplinary/{sysUserRole}', 'MasomwetuController@m_disciplinary')->name('login.M-Disciplinary');
	Route::get('/M-Cash/{sysUserRole}', 'MasomwetuController@m_cash')->name('login.M-Cash');
	Route::get('/M-Communication/{sysUserRole}', 'MasomwetuController@m_communication')->name('login.M-Communication');
	Route::get('/M-Report/{sysUserRole}', 'MasomwetuController@m_report')->name('login.M-Report');
	Route::get('/M-Personnel/{sysUserRole}', 'MasomwetuController@m_personnel')->name('login.M-Personnel');
	Route::get('/M-Presence/{sysUserRole}', 'MasomwetuController@m_presence')->name('login.M-Presence');
	
	Route::group([ 'middleware' => 'user'], function(){
		
		// == M-SCHOLAR URL
		Route::get('/M-Sholar/accueil', 'MScholarController@accueil')->name('scholar.accueil');
		Route::get ('/M-Sholar/effectifs/', 'MScholarController@effectifs')->name('scholar.effectifs');
		Route::get ('/M-Sholar/eleves/', 'MScholarController@eleves')->name('scholar.eleves');
		Route::get ('/M-Sholar/eleves/status/', 'MScholarController@eleves_status')->name('scholar.eleves.status');
		Route::get ('/M-Sholar/fiche/electronique/', 'MScholarController@fiche_electronique')->name('scholar.fiche.electronique');
		Route::post('/M-Sholar/eleves/', 'MScholarController@eleves')->name('scholar.eleves.classe');
		Route::post('/M-Sholar/import/eleves/', 'MScholarController@import_eleves')->name('scholar.eleves.import');
		Route::get ('/M-Sholar/classe/cartes/{id_classe?}/{bg?}/{css?}', 'MScholarController@imprimer_cartes')->name('scholar.eleves.cartes');
		Route::get ('/M-Sholar/classe/', 'MScholarController@classes')->name('scholar.classes');
		Route::get ('/M-Sholar/cartes/{ms_eleve_id?}', 'MScholarController@cartes')->name('scholar.carte');
		Route::post('/M-Sholar/cartes/', 'MScholarController@cartes')->name('scholar.carte');
		Route::get('/M-Sholar/remerciement/', 'MScholarController@message_de_remerciement')->name('scholar.remerciement');
		Route::get('/M-Sholar/send/sms/', 'MScholarController@simple_send_sms')->name('scholar.send.sms');
		Route::get('/M-Sholar/set/eleve/tuteur', 'MScholarController@setEleveTuteur')->name('scholar.set.eleve.tuteur');
		Route::get('/M-Sholar/dette/eleve/{ms_eleve_id?}', 'MScholarController@dette_eleve')->name('scholar.eleve.dette');
		
		// Route::get('carte/service/{bg?}/{css?}','SysController@carte')->name('carte');

		Route::get ('/M-Sholar/dossier/{ms_eleve_id?}', 'MScholarController@dossier')->name('scholar.dossier');
		Route::get ('/M-Sholar/dossiers', 'MScholarController@dossiers')->name('scholar.dossiers');
		Route::get ('/M-Sholar/fiche', 'MScholarController@fiche_reseignement')->name('scholar.fiche');
		Route::get ('/M-Sholar/derrogation', 'MScholarController@derrogation')->name('scholar.derrogation');
		Route::post ('/M-Sholar/derrogation', 'MScholarController@derrogation')->name('scholar.derrogation');
		Route::get ('/M-Sholar/derrogation/info-eleve', 'MScholarController@derrogation_info')->name('scholar.derrogation.info');
		Route::get ('/M-Sholar/allocationmat', 'MScholarController@allocationmat')->name('scholar.allocationmat');
		Route::post ('/M-Sholar/allocationmat', 'MScholarController@allocationmat')->name('scholar.allocationmat');
		Route::get ('/M-Sholar/inscrire', 'MScholarController@form_inscrire')->name('scholar.inscrire');
		Route::post('/M-Sholar/inscrire', 'MScholarController@inscrire')->name('scholar.inscrire');
		Route::get('/M-Sholar/supprimer/inscription', 'MScholarController@supprimer_inscription')->name('scholar.supprimer.inscription');
		Route::post('/M-Sholar/supprimer/inscription', 'MScholarController@supprimer_inscription')->name('scholar.supprimer.inscription');
		Route::post('/M-Sholar/import/result/test', 'MScholarController@resultat_test_importation')->name('scholar.import.result.test');
		Route::post('/M-Sholar/save/preuve/test', 'MScholarController@resultat_save_preuve_test')->name('scholar.image.result.test');
		Route::post('/M-Sholar/vider/tables', 'MScholarController@vider_les_table')->name('scholar.vider.tables');
		
		// modification des information de l'inscription
		Route::post('/M-Sholar/update/insc/enfant', 'MScholarUpdateController@update_insc_enfant')->name('scholar.update.insc.enfant');
		Route::post('/M-Sholar/update/insc/classe', 'MScholarUpdateController@update_insc_classe')->name('scholar.update.insc.classe');
		Route::post('/M-Sholar/update/insc/classes', 'MScholarUpdateController@changer_classe_eleves')->name('scholar.update.insc.classes');
		Route::post('/M-Sholar/update/insc/tuteur', 'MScholarUpdateController@update_insc_tuteur')->name('scholar.update.insc.tuteur');
		Route::post('/M-Sholar/update/insc/parent', 'MScholarUpdateController@update_insc_parent')->name('scholar.update.insc.parent');
		Route::post('/M-Sholar/update/insc/dossier', 'MScholarUpdateController@update_insc_dossier')->name('scholar.update.insc.dossier');
		Route::post('/M-Sholar/update/insc/image', 'MScholarUpdateController@update_insc_image')->name('scholar.update.insc.image');
		Route::post('/M-Sholar/update/insc/image/brute', 'MScholarUpdateController@update_image_brute')->name('scholar.update.insc.image.brute');
		Route::post('/M-Sholar/update/insc/religion', 'MScholarUpdateController@update_insc_religion')->name('scholar.update.insc.religion');
		// -----------------------------------

		Route::get ('/M-Sholar/classer/eleves', 'MScholarController@lister_promotions')->name('scholar.promotions');
		Route::get ('/M-Sholar/eleves/inscrits/{ajax?}', 'MScholarController@eleves_inscrits')->name('scholar.eleves.inscrits');
		
		Route::get ('/M-Sholar/export/promotions', 'MScholarController@fiche_excel_import_promotion')->name('scholar.export.promotions');
		Route::post('/M-Sholar/import/classes', 'MScholarController@import_classe')->name('scholar.import.classes');
		Route::get('/M-Sholar/select/eleve/ajax', 'MScholarController@select_eleve_ajax')->name('scholar.select.eleve.ajax');
		Route::get('/M-Sholar/select/inscription/ajax', 'MScholarController@select_inscription_ajax')->name('scholar.select.inscription.ajax');
		Route::get('/M-Sholar/select/classe/ajax', 'MScholarController@select_classe_ajax')->name('scholar.select.classe.ajax');
		Route::get('/M-Sholar/select/parents/ajax', 'MScholarController@select_parent_ajax')->name('scholar.select.parents.ajax');
		Route::get('/M-Sholar/select/tuteurs/ajax', 'MScholarController@select_tuteur_ajax')->name('scholar.select.tuteurs.ajax');
		
		Route::get('/load-page/{view?}', 'MyDataTableController1@load_page')->name('load.page');

		Route::get('/M-DataTable/get/select/data/{s?}', 'MyDataTableController1@getSelectData')->name('datatable.get.select.data');

		Route::post('/M-DataTable/save/data/{s?}', 'MyDataTableController1@saveData')->name('datatable.save.data');

		Route::post('/M-Data-Table/get/data/for/edition/{s?}/{id?}', 'MyDataTableController1@getDataForEdition')->name('data.table.get.data.for.edition');
		Route::post('/M-Data-Table/save/data/after/edition/{s?}/{id?}', 'MyDataTableController1@saveDataAfterEdition')->name('data.table.save.data.after.edition');

		Route::get('/M-DataTable/get/data/{s?}', 'MyDataTableController1@getData')->name('datatable.get.data');
		Route::get('/M-Data-Table/get/data/{s?}', 'MyDataTableController1@get_data_table')->name('data.table.get.data');
		Route::get('/M-Data-Table/get/detail/data/{id?}/{s?}', 'MyDataTableController1@get_detail_data')->name('data.table.get.detail.data');
		Route::get('/M-Data-Table/get/data/table/detail/{table?}/{s?}/{id?}', 'MyDataTableController1@get_data_table_detail')->name('data.table.get.detail');
		Route::get('/M-Data-Table/get/data/table/relations/{table?}/{s?}/{champ?}/{id?}', 'MyDataTableController1@get_data_table_relation_custom_detail')->name('data.table.get.relation.detail');

		Route::post('/M-DataTable/del/data/{s?}/{id?}', 'MyDataTableController1@deleteData')->name('datatable.del.data');
		Route::post('/M-Data-Table/del/data/{s?}/{id?}', 'MyDataTableController1@del_data_table')->name('data.table.del.data');

		Route::get('/M-Data-Table/excel/data/{s?}/{nom?}', 'MyDataTableController1@getDataToExcel')->name('data.table.excel.data');

		Route::get('/M-DataTable/scholar/{table?}', 'MScholarController@datatable_scholar')->name('datatable.scholar');
		Route::get('menu/liste/{t?}/datatable', 'MyDataTableController1@menu_liste')->name('menu.liste.datatable');
		Route::get('menu/detail/datatable/{table?}/{s?}/{id?}', 'MyDataTableController1@get_data_table_detail_onnewpage')->name('menu.detail.newpage');
	
		// Route::get('/M-DataTable/get/data/{s?}', 'TestController@getData')->name('datatable.get.data');
		// Route::post('/M-DataTable/del/data/{s?}/{id?}', 'TestController@deleteData')->name('datatable.del.data');
		// Route::get('/M-Data-Table/get/data/{s?}', 'TestController@get_data_table')->name('data.table.get.data');
		// Route::post('/M-Data-Table/del/data/{s?}/{id?}', 'TestController@del_data_table')->name('data.table.del.data');
		// Route::get('/M-Data-Table/excel/data/{s?}/{nom?}', 'TestController@getDataToExcel')->name('data.table.excel.data');
		
		Route::get('/M-Sholar/enregistrment/test/filter', 'TestController@search')->name('enregistrement.test.filter');
		Route::get('/M-Sholar/enregistrment/test/index', 'TestController@index')->name('enregistrement.test.index');
		Route::post('/M-Sholar/enregistrment/test/save', 'TestController@save')->name('enregistrement.test.save');
		Route::post('/M-Sholar/enregistrment/test/supp/{id?}', 'TestController@supprimer')->name('enregistrement.test.supprimer');
		Route::get('/M-Sholar/enregistrment/test/extraire/excel', 'TestController@extraire')->name('enregistrement.test.extraire');
		// == M-DISCIPLINARY URL
		
		// enregistrer le retard ou l'absence d'un ou plusieurs élèves
		Route::get('/m-disciplinary/accueil', 'MDisciplinaryController@accueil')->name('disciplinary.accueil');
		Route::get ('/m-disciplinary/enregistrer', 'MDisciplinaryController@create')->name('disciplinary.create');
		Route::post('/m-disciplinary/enregistrer', 'MDisciplinaryController@store')->name('disciplinary.store');
		Route::get ('/m-disciplinary/dossier/{ms_eleve_id?}', 'MDisciplinaryController@dossier')->name('disciplinary.dossier');
		Route::get ('/m-disciplinary/conduite/{ms_classe_id?}', 'MDisciplinaryController@conduite_eleves')->name('disciplinary.conduite');
		Route::post('/m-disciplinary/retard', 'MDisciplinaryController@save_retard')->name('disciplinary.retard');
		Route::post('/m-disciplinary/absence', 'MDisciplinaryController@save_absence')->name('disciplinary.absence');
		Route::post('/m-disciplinary/convocation', 'MDisciplinaryController@send_convocation')->name('disciplinary.convocation');
		Route::post('/m-disciplinary/commentaire', 'MDisciplinaryController@save_commentaire')->name('disciplinary.commentaire');
		Route::get ('/m-disciplinary/rapport', 'MDisciplinaryController@rapport')->name('disciplinary.rapport');
		Route::post('/m-disciplinary/rapport', 'MDisciplinaryController@rapport')->name('disciplinary.rapport');
		Route::post('/m-disciplinary/marquer/absences', 'MDisciplinaryController@marquer_les_absences')->name('disciplinary.marquer.absences');
		Route::get ('/m-disciplinary/rapport/absence', 'MDisciplinaryController@rapport_absence')->name('disciplinary.rapport.absence');
		
		// == M-CASH URL
		Route::post ('/m-Cash/compta/assoc/user/secteur', 'MCashController@assoc_user_secteur')->name('cash.assoc.user.secteur');
		Route::middleware([CheckUserSecteur::class, IsComptaUser::class])->group(function(){
			// Inscription et Paiement des frais
			Route::get ('/m-Cash/index', 'MCashController@index')->name('cash.index');
			Route::get ('/m-Cash/sortie', 'MCashController@sortie')->name('cash.sortie');
			Route::get ('/m-Cash/datatable','MCashController@datatable')->name('cash.datatable');
			Route::get ('/m-Cash/cartes/{ms_eleve_id?}', 'MCashController@cartes')->name('cash.carte');
			Route::post('/m-Cash/cartes/', 'MCashController@cartes')->name('cash.carte');
			Route::get ('/m-Cash/dossier/{personnel_id?}', 'MCashController@dossier')->name('cash.dossier');
			Route::get ('/m-Cash/salaires', 'MCashController@salaires')->name('cash.salaires');
			Route::post('/m-Cash/fiche/save', 'MCashController@fiche_save')->name('cash.fiche.save');
			Route::post('/m-Cash/fiche/compte/init/final/save', 'MCashController@fiche_compte_init_final_save')->name('cash.fiche.compte.init.final.save');
			Route::get ('/m-Cash/fiche/{id}/detail', 'MCashController@fiche_detail')->name('cash.fiche.detail');
			Route::post('/m-Cash/fiche/add/suivi', 'MCashController@fiche_add_suivi')->name('cash.fiche.add.suivi');
			Route::post('/m-Cash/fiche/add/piece', 'MCashController@fiche_add_piece')->name('cash.fiche.add.piece');
			Route::get ('/m-Cash/rapport', 'MCashController@rapport')->name('cash.rapport');
			Route::get ('/m-Cash/rapport/journalier', 'MCashController@rapport_journalier')->name('cash.rapport.journalier');
			Route::get ('/m-Cash/rapport/journalier/global', 'MCashController@rapport_journalier_global')->name('cash.rapport.journalier.global');
			Route::get ('/m-Cash/livre/compte', 'MCashController@livre_des_compte')->name('cash.livre.compte');
			Route::get ('/m-Cash/afficher/etat/compte/{id?}/{sec?}', 'MCashController@affiche_etat_compte')->name('cash.afficher.etat.compte');
			Route::get ('/m-Cash/compte/indiv', 'MCashController@voir_grand_livre_individuel')->name('cash.compte.individuel');
			Route::get ('/m-Cash/rapport/email/journalier', 'MCashController@envoyer_rapport_journalier')->name('cash.rapport.email.journalier');
			
			Route::post ('/m-Cash/fussionner/les/mouvements', 'MCashController@fussionner_les_mouvements_de_deux_compte')->name('cash.fussionner.les.mouvements');

			Route::get ('/m-Cash/rapport/mensuel', 'MCashController@rapport_mensuel')->name('cash.rapport.mensuel');
			Route::get ('/m-Cash/rapport/mensuel/detail/compte', 'MCashController@rapport_mensuel_detail_compte')->name('cash.rapport.mensuel.detail.compte');
			Route::get ('/m-Cash/rapport/mensuel/detail/compte/suivi', 'MCashController@rapport_mensuel_detail_compte_suivi')->name('cash.rapport.mensuel.detail.compte.suivi');
			
			Route::post('/m-Cash/transfert/fond', 'MCashController@choisir_compte_atransferer')->name('cash.transfert.fond');
			Route::get ('/m-Cash/transfert/fond', 'MCashController@choisir_compte_atransferer')->name('cash.transfert.fond');
			Route::get ('/m-Cash/entrees/sorties', 'MCashController@rapport_mensuel_entree_sortie')->name('cash.entrees.sorties');
			Route::post('/m-Cash/save/rapport', 'MCashController@save_rapport_journalier')->name('cash.rapport.save');
			Route::post('/m-Cash/save/rapport/mensuel', 'MCashController@save_rapport_mensuel')->name('cash.rapport_m.save');
			Route::post('/m-Cash/save/user/compte', 'MCashController@save_user_compte')->name('cash.user.compte');
			Route::post('/m-Cash/save/sect/compte/asuivre', 'MCashController@save_sect_compte_asuivre')->name('cash.sect.compte.asuivre');
		
		});
		
		// == M-REPORT URL
		
		// Inscription et Paiement des frais
		Route::get('/m-Report/accueil', 'MReportController@accueil')->name('report.accueil');
		Route::get ('/m-Report/index', 'MReportController@index')->name('report.index');
		Route::get ('/m-Report/cotes', 'MReportController@import_export')->name('report.cotes');
		Route::get ('/m-Report/mini', 'MReportController@mini')->name('report.mini');
		Route::get ('/m-Report/grand/{id_eleve?}', 'MReportController@grand')->name('report.grand');
		Route::get ('/m-Report/palmarese', 'MReportController@palmarese')->name('report.palmarese');
		Route::get ('/m-Report/promotion/{id}/cours', 'MReportController@cours_promotion')->name('report.cours.promotion');
		Route::get ('/m-Report/cours', 'MReportController@afficher_cours')->name('report.cours');
		Route::get ('/m-Report/cours/{id}/cotes', 'MReportController@cours_cotes')->name('report.cours.cote');
		Route::get ('/m-Report/voir/cours/classe/{id_classe?}', 'MReportController@voir_cours_classse')->name('report.voir.cours.classse');
		Route::get ('/m-Report/aligner/cours', 'MReportController@aligner')->name('report.aligner');
		Route::post('/m-Report/aligner/cours', 'MReportController@aligner')->name('report.aligner');
		Route::post('/m-Report/import/cotes', 'MReportController@import_cotes')->name('report.import.cotes');
		Route::post('/m-Report/import/cours', 'MReportController@import_cours')->name('report.import.cours');
		Route::post('/m-Report/cours/change', 'MReportController@save_or_update_cours')->name('report.cours.change');
		Route::get('/m-Report/get/cours/ids', 'MReportController@get_id_cours')->name('report.get.cours.ids');
		Route::get('/m-Report/get/nombre/cote', 'MReportController@get_nombre_cote')->name('report.get.nombre.cote');
		
		

		// == M-SALARY URL
		
		// Inscription et Paiement des frais
		Route::get ('/m-salary/index', 'MSalaryController@index')->name('salary.index');
		Route::get ('/m-salary/payer', 'MSalaryController@payer')->name('salary.payer');
		Route::get ('/m-salary/operations', 'MSalaryController@operations')->name('salary.operations');
		Route::get ('/m-salary/find-rub-op/', 'MSalaryController@find_rubrique_operation')->name('salary.find_rub_op');
		Route::post('/m-salary/save/operation/', 'MSalaryController@save_operation')->name('salary.save.operation');
		Route::get ('/m-salary/rapport/paie', 'MSalaryController@rapport_paie')->name('salary.rapport.paie');
		Route::get ('/m-salary/salarie/lsit', 'MSalaryController@voir_les_salaries')->name('salary.salarie.liste');
		
		// == M-COMMUNICATION URL
		
		// Inscription et Paiement des frais
		Route::get ('/m-communication/index', 'MCommunicationController@index')->name('communication.index');
		Route::post('/m-communication/envoi/message', 'MCommunicationController@envoi_message')->name('communication.envoi.message');
		Route::get('/m-communication/envoi/resumer/frais/eleve', 'MCommunicationController@envoi_resumer_frais_eleve')->name('communication.envoi.resumer.frais.eleve');
		
		
		// == M-PAYMENT URL
		
		// Inscription et Paiement des frais
		Route::get ('/m-payment/faire/payer', 'MPaymentController@faire_payer')->name('payment.faire.payer');
		Route::post('/m-payment/payer/frais', 'MPaymentController@payer_frais')->name('payment.payer.frais');
		Route::post('/m-payment/supprimer/frais', 'MPaymentController@supprimer_paiement')->name('payment.supprimer.frais');
		Route::post('/m-payment/payer/importatoion', 'MPaymentController@payer_frais_importation')->name('payment.payer.frais.importer');
		Route::get ('/m-payment/payer/via/carte', 'MPaymentController@faire_payer_via_carte')->name('payment.payer.par.carte');
		Route::post('/m-payment/payer/via/carte', 'MPaymentController@payer_par_carte')->name('payment.payer.par.carte');
		Route::get('/m-payment/payer/info/eleve/{id?}/{mp_type_frais_id?}', 'MPaymentController@infos_eleve')->name('payment.payer.info.eleve');
		Route::get ('/m-payment/creer/frais', 'MPaymentController@creer_frais')->name('payment.creer.frais');
		Route::post('/m-payment/creer/frais', 'MPaymentController@creer_frais')->name('payment.creer.frais');
		Route::post('/m-payment/creer/frais-exceptionnel', 'MPaymentController@creer_frais_exceptionnel')->name('payment.creer.frais.exceptionnel');
		Route::get('/m-payment/accueil', 'MPaymentController@accueil')->name('payment.accueil');
		
		// affiche tous les frais au chargé de paiement
		Route::get('/m-payment/frais','MPaymentController@tous_les_frais')->name('payment.frais');
		Route::get('/m-payment/datatable','MPaymentController@datatable')->name('payment.datatable');
		
		// les rapports de paiement des frais
		Route::get ('/m-payment/rapport/aujourdhui', 'MPaymentController@rapport_aujourdhui')->name('payment.rapport.aujourdhui');
		Route::get ('/m-payment/rapport/periodique', 'MPaymentController@rapport_periodique')->name('payment.rapport.periodique');
		Route::post('/m-payment/rapport/periodique', 'MPaymentController@rapport_periodique')->name('payment.rapport.periodique');
		Route::post('/m-payment/rapport/mensuel', 'MPaymentController@rapport_mensuel')->name('payment.rapport.mensuel');
		Route::get ('/m-payment/rapport/mensuel', 'MPaymentController@rapport_mensuel')->name('payment.rapport.mensuel');
		Route::get ('/m-payment/rapport/tableau', 'MPaymentController@rapport_tableau_bord')->name('payment.rapport.tableau.bord');
		
		Route::get ('/m-payment/rapport/entree', 'MPaymentController@rapport_des_entree_classe')->name('payment.rapport.entrees');
		Route::get ('/m-payment/rapport/entree/chart', 'MPaymentController@rapport_des_entree_chart')->name('payment.rapport.chart');
		Route::get ('/m-payment/bilan/frais', 'MPaymentController@billan_du_frais')->name('payment.bilan.frais');
		Route::get ('/m-payment/registre/paie', 'MPaymentController@registre_de_paiement_par_classe')->name('payment.registre.paie');
		
		
		
		// routes en rapport avec les élèves inscrits
		Route::get('/m-payment/eleves/{promotion}', 'MPaymentController@eleves_in_promotion')->name('payment.promotion.eleves');
		// Route::get('/m-payment/classer/eleves', 'MPaymentController@lister_promotions')->name('payment.promotions');
		Route::get('/m-payment/classer/eleves/{promotion}', 'MPaymentController@classer_eleves_promotion')->name('payment.classer.eleves');
		
		
		// les reçu de paiement et d'inscription
		Route::get('/m-payment/recu/inscription/{eleve?}', 'MPaymentController@recu_inscription')->name('payment.recu.inscription');
		Route::get('/m-payment/recu/paiement/{paiement?}','MPaymentController@recu_paiement')->name('payment.recu.paiement');
		
		// dossier de paiement de l'élèves
		Route::get('/m-payment/dossier/eleve/{eleve?}','MPaymentController@dossier_eleve')->name('payment.dossier.eleve');
		
		// eleves en ordre ou pas par rapport au paiement d'un frais
		// Route::get('/m-payment/en-ordre/tou/{id_frais}','MPaymentController@eleves_en_ordre_tou')->name('payment.en_ordre.tou');
		// Route::get('/m-payment/en-ordre/non/{id_frais}','MPaymentController@eleves_en_ordre_non')->name('payment.en_ordre.non');
		// Route::get('/m-payment/en-ordre/oui/{id_frais}','MPaymentController@eleves_en_ordre_oui')->name('payment.en_ordre.oui');
		Route::get ('/m-payment/en-ordre','MPaymentController@eleves_en_ordre')->name('payment.en_ordre');
		Route::post('/m-payment/en-ordre','MPaymentController@eleves_en_ordre')->name('payment.en_ordre');
		
		// M-Personnel
		Route::get ('/personnel/liste-dossiers/', 'PersonnelDossierController@index')->name('personnel.liste.dossier');
		Route::get ('/personnel/liste-niveau-etud/', 'PersonnelDossierController@niveau_etude_personnels')->name('personnel.niveau.etude');
		Route::get ('/personnel/dossier/{id?}', 'PersonnelDossierController@personnel_dossier')->name('personnel.dossier');
		Route::get ('/personnel/new-personnel', 'PersonnelDossierController@personnel_new')->name('personnel.new.personnel');
		Route::get ('/personnel/new-etude', 'PersonnelDossierController@personnel_etude')->name('personnel.new.etude');
		Route::get ('/personnel/edit-personnel/{id?}', 'PersonnelDossierController@personnel_edit')->name('personnel.edit.personnel');
		Route::get ('/personnel/presence-agent/', 'PersonnelDossierController@personnel_presence')->name('personnel.presence.agent');
		Route::get ('/personnel/new-agent', 'PersonnelDossierController@agent_new')->name('personnel.new.agent');
		Route::get ('/personnel/accueil', 'PersonnelDossierController@accueil')->name('personnel.accueil');
		Route::get ('/personnel/', 'PersonnelDossierController@accueil')->name('personnel.accueil');
		Route::post('/personnel/store/dossier/', 'PersonnelDossierController@storeDossier')->name('personnel.dossier.store');
		
		// M-Presence
		Route::get ('/personnel-presence/accueil/', 'PersonnelPresenceController@index')->name('personnel_presence.accueil');
		Route::get ('/personnel-presence/justification/', 'PersonnelPresenceController@justification')->name('personnel_presence.justification');
		Route::post('/personnel-presence/justification/', 'PersonnelPresenceController@justification')->name('personnel_presence.justification');
		Route::post('/personnel-presence/pointer','PersonnelPresenceController@save_presence')->name('personnel_presence.pointer');
		// Route::post('/personnel-presence/justification','PersonnelPresenceController@save_presence')->name('personnel_presence.pointer');
		Route::get ('/personnel-presence/rapport','PersonnelPresenceController@rapport')->name('personnel_presence.rapport');
		Route::get ('/personnel-presence/rapport/journalier/','PersonnelPresenceController@rapport_journalier')->name('personnel_presence.rapport.journalier');
		Route::get ('/personnel-presence/rapport/mensuel/','PersonnelPresenceController@rapport_mensuel')->name('personnel_presence.rapport.mensuel');
		Route::get ('/personnel-presence/rapport/agent/','PersonnelPresenceController@rapport_individuel')->name('personnel_presence.rapport.individuel');
		Route::get ('/personnel-presence/agent/deja/arrives/','PersonnelPresenceController@agent_deja_arriver')->name('personnel_presence.agent.deja.arriver');
		Route::get ('/personnel-presence/refresh/agent/deja/arrives','PersonnelPresenceController@refresh_agent_deja_arriver')->name('personnel_presence.refresh.agent.deja.arriver');
		


	});
	
		
	Route::resource('smsconfigs', 'Masomwetu\Sys\SmsConfigsController');
	Route::resource('enfants', 'Masomwetu\Scholar\EnfantsController');
	Route::resource('statusenfants', 'Masomwetu\Scholar\StatusEnfantsController');
	Route::resource('tuteurs', 'Masomwetu\Scholar\TuteursController');
	Route::resource('sections', 'Masomwetu\School\SectionsController');
	Route::resource('mspromotions', 'Masomwetu\Scholar\MsPromotionsController');
	Route::resource('ecoles', 'Masomwetu\School\EcolesController');
	Route::resource('msclasses', 'Masomwetu\Scholar\MsClassesController');
	Route::resource('mseleves', 'Masomwetu\Scholar\MsElevesController');
	Route::resource('msanneescolaires', 'Masomwetu\Scholar\MsAnneeScolairesController');
	Route::resource('msinscriptions', 'Masomwetu\Scholar\MsInscriptionsController');
	Route::resource('mptypefraiss', 'Masomwetu\Payment\MpTypeFraissController');
	Route::resource('mpfraiss', 'Masomwetu\Payment\MpFraissController');
	Route::resource('mpfraisclasses', 'Masomwetu\Payment\MpFraisClassesController');
	Route::resource('mpfraispaiements', 'Masomwetu\Payment\MpFraisPaiementsController');
	Route::resource('sysroles', 'Masomwetu\Sys\SysRolesController');
	Route::resource('sysaccesslevels', 'Masomwetu\Sys\SysAccessLevelsController');
	Route::resource('syszones', 'Masomwetu\Sys\SysZonesController');
	Route::resource('users', 'Masomwetu\Sys\UsersController');
	Route::resource('sysuserroles', 'Masomwetu\Sys\SysUserRolesController');
	Route::resource('mdcommentaires', 'Masomwetu\Disciplinary\MdCommentairesController');
	Route::resource('periodes', 'Masomwetu\Disciplinary\PeriodesController');
	Route::resource('motifcommentaires', 'Masomwetu\Disciplinary\MotifCommentairesController');
	Route::resource('mdretards', 'Masomwetu\Disciplinary\MdRetardsController');
	Route::resource('mdabsences', 'Masomwetu\Disciplinary\MdAbsencesController');
	Route::resource('mdabsjours', 'Masomwetu\Disciplinary\MdAbsJoursController');
	Route::resource('mdeleverenvoyers', 'Masomwetu\Disciplinary\MdEleveRenvoyersController');
	Route::resource('mdmentions', 'Masomwetu\Disciplinary\MdMentionsController');
	Route::resource('cashsuivis', 'Masomwetu\Cash\CashSuivisController');
	Route::resource('mcmoiss', 'Masomwetu\Cash\McMoissController');
	Route::resource('cashfichesorties', 'Masomwetu\Cash\CashFicheSortiesController');
	Route::resource('cashcategories', 'Masomwetu\Cash\CashCategoriesController');
	Route::resource('personnels', 'Masomwetu\School\PersonnelsController');
	Route::resource('mcfonctions', 'Masomwetu\School\McFonctionsController');
	Route::resource('mcsmss', 'Masomwetu\Communication\McSmssController');
	Route::resource('mcsmstypes', 'Masomwetu\Communication\McSmsTypesController');
	Route::resource('mrcourspromotions', 'Masomwetu\Report\MrCoursPromotionsController');
	Route::resource('mrgroupecourss', 'Masomwetu\Report\MrGroupeCourssController');
	Route::resource('mrcourss', 'Masomwetu\Report\MrCourssController');
	Route::resource('mrcotes', 'Masomwetu\Report\MrCotesController');
	Route::resource('mrcotemodifiees', 'Masomwetu\Report\MrCoteModifieesController');
	Route::resource('parametres', 'Masomwetu\Sys\ParametresController');
	Route::resource('scheures', 'Masomwetu\Schedule\ScHeuresController');
	Route::resource('schoraires', 'Masomwetu\Schedule\ScHorairesController');
	Route::resource('scperiodehoraires', 'Masomwetu\Schedule\ScPeriodeHorairesController');
	Route::resource('enseignants', 'Masomwetu\School\EnseignantsController');
	Route::resource('sarubriquepaies', 'Masomwetu\Salary\SaRubriquePaiesController');
	Route::resource('sacategoriebulletins', 'Masomwetu\Salary\SaCategorieBulletinsController');
	Route::resource('sarubriquecategoriebulletins', 'Masomwetu\Salary\SaRubriqueCategorieBulletinsController');
	Route::resource('sapaiementsalaires', 'Masomwetu\Salary\SaPaiementSalairesController');
	Route::resource('sasalaries', 'Masomwetu\Salary\SaSalariesController');
	Route::resource('sarubriquepayesurbulletins', 'Masomwetu\Salary\SaRubriquePayeSurBulletinsController');
	Route::resource('saoperationsalaires', 'Masomwetu\Salary\SaOperationSalairesController');
	Route::resource('agents', 'Masomwetu\School\AgentsController');
	Route::resource('dossierpersonnels', 'Masomwetu\School\DossierPersonnelsController');
	Route::resource('sifamiliales', 'Masomwetu\School\SiFamilialesController');
	Route::resource('imgdocuments', 'Masomwetu\School\ImgDocumentsController');
	Route::resource('niveauetudepersonnels', 'Masomwetu\School\NiveauEtudePersonnelsController');
	Route::resource('pointages', 'Masomwetu\Presence\PointagesController');
	Route::resource('justifabsences', 'Masomwetu\Presence\JustifAbsencesController');
	Route::resource('jourouvrables', 'Masomwetu\Presence\JourOuvrablesController');
	Route::resource('previsionarriveesorties', 'Masomwetu\Presence\PrevisionArriveeSortiesController');
	Route::resource('mdpresences', 'Masomwetu\Disciplinary\MdPresencesController');
	Route::resource('materiels', 'Masomwetu\Allocation\MaterielsController');
	Route::resource('empruntmateriels', 'Masomwetu\Allocation\MaterielsController');

	
	// Route::post('import/promotion', 'ExcelImportController@promotion')->name('import.promotion');
	Route::post('import/export', 'ExcelImportController@import_export')->name('import.export');
	Route::get('export/grille/cote/{id_cours}', 'ExcelImportController@export_grille_cote')->name('export.grille.cote');
	Route::get('export/grille/cours/{id_pro}', 'ExcelImportController@export_grille_cours')->name('export.grille.cours');
	Route::get('export/grille/vide/eleves/{id_classe}', 'ExcelImportController@export_grille_vide_eleves')->name('export.grille.vide.eleves');
	Route::get('export/grille/synth/{id_classe}/{aveCote?}/{travail?}', 'ExcelImportController@export_grille_synth')->name('export.grille.synth');
	Route::get('export/grille/import/eleve/{id?}', 'ExcelImportController@fiche_excel_import_eleve')->name('export.grille.import.eleve');
	Route::get('export/grille/import/tous-les-eleves', 'ExcelImportController@exporter_tous_eleves')->name('export.tous.les.eleves');
	
	
	Route::resource('parentenfants', 'Masomwetu\Scholar\ParentEnfantsController');
	Route::resource('dossierenfants', 'Masomwetu\School\DossierEnfantsController');
	Route::resource('imgdossierenfants', 'Masomwetu\School\ImgDossierEnfantsController');
	// Route::post('/golden/update/field/','GoldenUpdateFieldController@update_field')->name('golden.update.field');
	// Route::get('/golden/return/options/{class?}','GoldenReturnOptionsController@options')->name('golden.return.options');
	Route::resource('comptes', 'Masomwetu\Comptabilite\ComptesController');
	Route::resource('categoriecomptes', 'Masomwetu\Comptabilite\CategorieComptesController');
	Route::resource('mouvementcomptes', 'Masomwetu\Comptabilite\MouvementComptesController');
	Route::resource('tauxchanges', 'Masomwetu\Comptabilite\TauxChangesController');
	Route::resource('rapportjournaliers', 'Masomwetu\Comptabilite\RapportJournaliersController');
	Route::resource('rapportmensuels', 'Masomwetu\Comptabilite\RapportMensuelsController');
	Route::resource('rapportannuels', 'Masomwetu\Comptabilite\RapportAnnuelsController');
	Route::post('/golden/update/field/','GoldenUpdateFieldController@update_field')->name('golden.update.field');
	Route::get('/golden/return/options/{class?}/{where?}/{value?}','GoldenReturnOptionsController@options')->name('golden.return.options');
});


// les routes des options
	Route::get('return/options/{classe?}/{where?}/{value?}', 'UpdateFieldController@return_options')->name('return.options');

Route::get('return/select/data/{cle?}','TestController@selectData')->name('get.select.data');

// AS001
Route::get ('/eleve/sms/masomwetu/{matricule}/{telephone}', 'MScholarController@sms_masomwetu')->name('scholar.sms.masomwetu');

Route::get ('/eleve/{matricule}', 'MScholarController@dossier_matricule')->name('scholar.dossier.matricule');
Route::get ('/eleve/dossier/{eleve?}', 'MScholarController@dossier_eleve_carte')->name('scholar.dossier.eleve.carte');
// Route::post('/eleve/change/image', 'MScholarController@change_image')->name('scholar.change.image');
Route::post('/eleve/change/image', 'MScholarController@ajax_change_image')->name('scholar.change.image');
Route::get ('/auth/eleve', 'MScholarController@eleve_auth')->name('scholar.eleve.auth');
	
// Route::get ('/upload/image', 'ImageController@index');
// Route::post ('/upload/image', 'ImageController@uploadImage')->name('upload.image');

Auth::routes();

Route::get('/import',function(){
	return Excel::download(new App\Exports\UsersExport,'users.xlsx');
	// Excel::download/Excel::store($yourExport)
});

Route::get('/export/eleves/{id}',function($id){
	$nom = "TOUS LES ELEVES";
	if($id != 0){
		$cl = MsClasse::find($id);
		if($cl)
			$nom = $cl->classe;
		else return "<h1>CLASSE NON IDENTIFIEE</h1> ";
	}
	
	$nom = mb_ereg_replace("([^\w\s\d\-_~,;\[\]\(\).])", '', $nom);
	// Remove any runs of periods (thanks falstro!)
	$nom = mb_ereg_replace("([\.]{2,})", '', $nom);
	return (new \App\Exports\EleveExport)->forClasse($id)->forType('frais')->download('Frais Eleve de '.$nom.'.xlsx');
	// return Excel::download(new App\Exports\UsersExport,'users.xlsx');
	// Excel::download/Excel::store($yourExport)
})->name('scholar.export.eleve');

Route::get('/qrcode/{id?}', function ($id=0) {
     return QrCode::format('png')->size(300)->generate($id,"qrcodes/$id.png");
	 
});
 
Route::get('/sms/{text}', function (Request $request,$txt) {
	return ms_sms("243971695208",$txt);	
});
 