<?php

use Illuminate\Http\Request;

use App\Http\Controllers\SmsController;
use App\Http\Controllers\CarteController;

use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Route;
use \App\Models\User;
use \App\Masomwetu\Scholar\MsEleve;


use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Log;

use Illuminate\Support\Facades\Schema;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});
*/
Route::get('/get-sms-to-send', [SmsController::class, 'getPendingSms']);
Route::post('/confirm-sms-sent', [SmsController::class, 'markAsSent']);
Route::post('/sms-request', [SmsController::class, 'requestDatas']);

Route::get('/get-sms-to-transfer', [SmsController::class, 'getTransfertPendingSms']);
Route::post('/confirm-sms-transfered', [SmsController::class, 'deleteTransferedSms']);
Route::get('/get-urls-to-send-sms', [SmsController::class, 'getUrlsToSendSms']);


Route::middleware(['user'])->group(function(){
    // Protège par session 'logged_in' comme dans ta page
    // Route::get('/gst-carte/', 'CarteController@index');
    Route::get('/gst-carte', [CarteController::class,'index']);
    Route::post('/gst-carte', [CarteController::class, 'index']);
    Route::get('/gst-carte/eleves', [CarteController::class,'eleves']);
    Route::post('/gst-carte/updateCarte', [CarteController::class,'updateCarte']);
    Route::get('/gst-carte/montantParDate', [CarteController::class,'montantParDate']);
    Route::get('/gst-carte/stats', [CarteController::class, 'stats']);
    
    // Select2 AJAX
    Route::get('/gst-carte/eleves-select2', [CarteController::class, 'elevesSelect2']);
    
    // DataTable AJAX
    Route::get('/gst-carte/eleves-table', [CarteController::class, 'elevesTable']);

});


// -------------------------
// LOGIN
// -------------------------




/* =======================
   LOGIN UI – HTML initial
======================= */
Route::get('/mobile/login-ui', function () {
    
    $url = url("/api/login");
    $src_init = asset('storage/ecole/logo_ecole/');
    $html = <<<HTML
<!DOCTYPE html>
<html lang="fr">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Masomwetu - Connexion</title>

<style>
body {
    margin: 0;
    font-family: system-ui, -apple-system, sans-serif;
    background: linear-gradient(135deg, #1565C0, #42A5F5);
    min-height: 100vh;
    display: flex;
    align-items: center;
    justify-content: center;
}

.card {
    background: white;
    border-radius: 14px;
    padding: 24px;
    width: 100%;
    max-width: 420px;
    box-shadow: 0 8px 25px rgba(0,0,0,.15);margin:10px;
}

.logo {
    text-align: center;
    font-size: 28px;
    font-weight: bold;
    color: #1565C0;
    margin-bottom: 6px;
}

.subtitle {
    text-align: center;
    font-size: 14px;
    color: #666;
    margin-bottom: 18px;
}

.welcome {
    background: #E3F2FD;
    padding: 14px;
    border-radius: 10px;
    font-size: 14px;
    color: #0D47A1;
    margin-bottom: 20px;
}

label {
    font-size: 13px;
    color: #555;
    display: block;
    margin-bottom: 4px;
}

input {
    width: 100%;
    padding: 12px;
    margin-bottom: 14px;
    border-radius: 8px;
    border: 1px solid #ccc;
    font-size: 15px;width: -webkit-fill-available;
}

input:focus {
    outline: none;
    border-color: #1565C0;
}

button {
    width: 100%;
    padding: 14px;
    font-size: 16px;
    background: #1565C0;
    color: white;
    border: none;
    border-radius: 8px;
    cursor: pointer;
}

button:hover {
    background: #0D47A1;
}

#error {
    margin-top: 12px;
    color: #D32F2F;
    font-size: 14px;
    text-align: center;
}

.footer {
    margin-top: 18px;
    font-size: 12px;
    text-align: center;
    color: #999;
}
.app-logo {
    display: flex;
    justify-content: center;
    margin-bottom: 12px;
}

.app-logo img {
    width: 100px;
    height: 100px;
    border-radius: 50%;
    object-fit: cover;
    box-shadow: 0 4px 12px rgba(0,0,0,.25);
}

</style>
</head>

<body>

<div class="card">
    <div class="app-logo">
        <img id="school-logo"
            src="https://ecoles.delardc.com/img/email/pt-logo-1.jpeg"
            alt="Masomwetu Logo"
        >
    </div>

    <div class="logo" id="school-name">Masomwetu</div>
    <div class="subtitle">Application de contrôle scolaire</div>

    <div class="welcome">
        <strong>Bienvenue 👋</strong><br>
        Cette application vous permet de vérifier rapidement les paiements
        des élèves (frais scolaires et bus) grâce au scan des cartes QR Code.
    </div>

    <label for="u">Nom d'utilisateur</label>
    <input id="u" placeholder="Ex: admin, comptable...">

    <label for="p">Mot de passe</label>
    <input id="p" type="password" placeholder="Votre mot de passe">

    <button onclick="login()">🔐 Se connecter</button>

    <div id="error"></div>

    <div class="footer">
        © Masomwetu · Plateforme scolaire
    </div>

</div>

<script>
function login() {
    document.getElementById('error').innerText = "";

    fetch('$url', {
        method: 'POST',
        headers: {'Content-Type':'application/json'},
        body: JSON.stringify({
            username: u.value,
            password: p.value
        })
    })
    .then(async r => {
        const text = await r.text();
        try {
            const j = JSON.parse(text);
            if (j.success) {
                AndroidLogin.onSuccess(j.token, j.html);
            } else {
                document.getElementById('error').innerText =
                    j.message || 'Identifiants incorrects';
            }
        } catch (err) {
            document.getElementById('error').innerText =
                'Réponse serveur invalide';
        }
    })
    .catch(err => {
        document.getElementById('error').innerText =
            'Erreur réseau : ' + err.message;
    });
}

document.addEventListener("DOMContentLoaded", function () {
    const saved = localStorage.getItem('masomwetu_school');

    if (!saved) return;

    try {
        const school = JSON.parse(saved);

        if (school.name) {
            document.getElementById('school-name').innerText = school.name;
        }

        if (school.logo) {
            document.getElementById('school-logo').src = '$src_init/'+school.logo;
        }
    } catch (e) {
        console.warn('School storage invalid');
    }
});
</script>


</body>
</html>

HTML;
Log::info('CHECK-PAIEMENT', [
        'body' => $html
    ]);
    return response($html, 200)->header('Content-Type', 'text/html');
    
});

/* =======================
   LOGIN POST
======================= */
Route::post('/login', function(Request $request) {
    
    Log::info('CHECK-PAIEMENT', [
        'headers' => $request->headers->all(),
        'body' => $request->all()
    ]);

    $request->validate([
        'username' => 'required|string',
        'password' => 'required|string',
    ]);
    
    // Connexion principale
    $connection = 'mysql';
    $user = DB::connection($connection)
        ->table('bulletin_users')
        ->where('email', $request->username)
        ->orWhere('name', $request->username)
        ->first();

    if (!$user || !Hash::check($request->password, $user->password)) {
        // Connexion secondaire si échec
        $connection = 'mysql2';
        $user = DB::connection($connection)
            ->table('bulletin_users')
            ->where('email', $request->username)
            ->orWhere('name', $request->username)
            ->first();

        if (!$user || !Hash::check($request->password, $user->password)) {
            // Login échoué : renvoyer le HTML de login avec message
            // $html = view('mobile.login-html', ['error' => 'Login échoué'])->render();
            return response()->json([
                'success' => false,
                'html' => "LA CONNEXION A ECHOUE $request->username $request->password",
                'message' => 'Login échoué'
            ], 401);
        }
    }

    DB::setDefaultConnection($connection);

    // Token simple
    $token = hash('sha256', Str::random(60));
    DB::connection($connection)->table('api_tokens')->insert([
        'user_id' => $user->id,
        'token' => $token,
        'created_at' => now()
    ]);

    $ecole = DB::connection($connection)
        ->table('bulletin_ecoles')
        ->where('id', $user->ecole_id)
        ->first();
    $logo = $ecole->logo_ecole ;
            
    // Récupérer la liste des frais pour l'école
    $fraiss = DB::connection($connection)
        ->table('mp_frais_classes as mfc')
        ->join('mp_frais as f', 'f.id', '=', 'mfc.mp_frais_id')
        ->join('bulletin_ms_classes as c', 'c.id', '=', 'mfc.ms_classe_id')
        ->where('c.ecole_id', $user->ecole_id)
        ->select('f.id', 'f.frais')
        ->distinct()
        ->get();
        $annees = DB::select("SELECT id,annee FROM bulletin_ms_annee_scolaires WHERE etat = 1" );
    $frais = DB::select("
        SELECT DISTINCT mf.*
        FROM mp_frais mf
        INNER JOIN mp_frais_classes mfc 
            ON mfc.mp_frais_id = mf.id
        INNER JOIN bulletin_ms_classes c 
            ON c.id = mfc.ms_classe_id
        WHERE  c.ecole_id = ?  AND mfc.ms_annee_scolaire_id = ?
    ", [$user->ecole_id, $annees[0]->id]);

    Log::info('CHECK-ECOLE', [
        'body' => $frais,
        'bod' => $fraiss,
    ]);
    // Générer options HTML
    $options = '';
    foreach($frais as $f) {
        $options .= '<option value="'.$f->id.'">'.htmlspecialchars($f->frais).'</option>';
    }
    $options .= "<option value='-1'>NE PAS CONSIDERER</option>";
    
    
    if (Schema::hasTable('bus_mois')) {
        $busMois = DB::table('bus_mois')
            ->where('ecole_id', $user->ecole_id)
            ->orderBy('annee')
            ->orderBy('id')
            ->get();
    } else {
        $busMois = collect(); // collection vide
    }

    
    $optionsBusMois = "<option value=''>-- Choisir le mois de bus --</option>";

    foreach ($busMois as $bm) {
        $optionsBusMois .= "
            <option value='{$bm->id}'>
                {$bm->mois} {$bm->annee}
            </option>
        ";
    }
    $optionsBusMois .= "<option value='-1'>NE PAS CONSIDERER</option>";


    
    $ecole_nom_ecole=$ecole->nom_ecole;

    // HTML de scan
    $html = '
<!DOCTYPE html>
<html>
<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<style>
body {
    font-family: system-ui, sans-serif;
    background: #f5f7fa;
    padding: 16px;
    padding-top: 0px;
}

/* ===== Titre école ===== */
.school-title {
    text-align: center;
    font-size: 22px;
    font-weight: bold;
    color: #1B5E20;
    margin-bottom: 20px;
}

/* ===== Carte principale ===== */
.card {
    background: white;
    padding: 16px;
    padding-top: 3px;
    box-shadow: 0 4px 12px rgba(0,0,0,.08);

    max-width: 480px;
    margin: auto;
    border-radius: 12px;
}

/* ===== Ligne inputs ===== */
.row {
    display: flex;
    gap: 10px;
    margin-bottom: 14px;
}

.field {
    flex: 1;
}

label {
    font-size: 14px;
    color: #555;
    margin-bottom: 4px;
    display: block;
}

select, input {
    width: 100%;
    padding: 10px;
    font-size: 15px;
    border-radius: 8px;
    border: 1px solid #ccc;
}

/* ===== Boutons ===== */
button {
    width: 100%;
    padding: 12px;
    font-size: 16px;
    border-radius: 8px;
    border: none;
    cursor: pointer;
}

.btn-scan {
    background-color: #1976D2;
    color: white;
    margin-bottom: 12px;
}

.btn-scan:hover {
    background-color: #1565C0;
}

.btn-logout {
    background-color: #D32F2F;
    color: white;
    margin-top: 14px;
}

.btn-logout:hover {
    background-color: #C62828;
}

/* ===== Résultat scan ===== */
#scan-result {
    margin-top: 12px;
    padding: 12px;
    border-radius: 8px;
    background: #E8F5E9;
    color: #1B5E20;
    font-size: 15px;
}
</style>

<style>


.status {
    text-align: center;
    font-size: 24px;
    font-weight: bold;
    color: white;
    padding: 12px;
    border-radius: 8px;
}

.section {
    margin-top: 15px;
}

.label {
    color: #777;
    font-size: 13px;
}

.value {
    font-size: 16px;
    font-weight: bold;
}

.money {
    font-size: 18px;
}

.footer {
    margin-top: 20px;
    text-align: center;
    font-size: 12px;
    color: #999;
}

.bus-status {
    margin-top: 12px;
    padding: 12px;
    border-radius: 6px;
    font-weight: bold;
    text-align: center;
}

.bus-status.success {
    background: #d4edda;
    color: #155724;
}

.bus-status.warning {
    background: #fff3cd;
    color: #856404;
}

.bus-status.danger {
    background: #f8d7da;
    color: #721c24;
}

</style>
<style>
.loader {
    display: flex;
    justify-content: center;
    align-items: center;
    padding: 24px;
}

.spinner {
    width: 36px;
    height: 36px;
    border: 4px solid #ddd;
    border-top: 4px solid #1976D2;
    border-radius: 50%;
    animation: spin 0.9s linear infinite;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}
</style>
<style>
/* Conteneur principal */
.status-container {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    padding: 20px;
}

/* Cercle vert */
.status-ok-circle {
    width: 120px;
    height: 120px;
    border-radius: 50%;
    background-color: #2e7d32;
    display: flex;
    align-items: center;
    justify-content: center;
    box-shadow: 0 4px 10px rgba(0, 0, 0, 0.3);
}

/* Icône check */
.status-ok-icon {
    font-size: 70px;
    color: #ffffff;
    line-height: 1;
}

/* Texte EN ORDRE */
.status-ok-text {
    margin-top: 12px;
    color: #2e7d32;
    font-size: 24px;
    font-weight: bold;
}
.status-ok-circle.status-no-circle { background:#d32f2f; }
.status-ok-text.status-no-text { color:#d32f2f; }
.school-header {
    display: flex;
    align-items: center;
    gap: 16px;            /* espace entre logo et texte */
    margin-bottom: 24px;
    padding: 12px;  
    background: #70707038;
    margin-left: -25px;
    margin-right: -25px;
    margin-top: -10px;
}

.school-logo {
    width: 64px;
    height: 64px;
    border-radius: 50%;
    object-fit: cover;
    box-shadow: 0 4px 12px rgba(0,0,0,.25);
    background: #fff;
    flex-shrink: 0;       /* logo ne se réduit pas si le nom est long */
}

.school-title-wrapper {
    display: flex;
    flex-direction: column;
    justify-content: center;
    overflow: hidden;     /* pour éviter que le texte dépasse */
}

.school-title {
    font-size: 22px;
    font-weight: 700;
    color: #1B5E20;
    white-space: nowrap;   /* texte sur une seule ligne */
    overflow: hidden;
    text-overflow: ellipsis; /* tronque le texte trop long avec ... */
}

.school-year {
    font-size: 16px;
    color: #555;
    margin-top: -12px;
}


</style>

</head>
<body>';
$html .= '
<!-- ===== NOM ECOLE ===== -->
<div class="school-header">
    <img 
        src="'.asset('storage/ecole/logo_ecole/'.$logo) .'" 
        alt="Logo école" 
        class="school-logo"
    >
    <div class="school-title-wrapper">
        <div class="school-title">
             '.htmlspecialchars($ecole_nom_ecole).'
        </div>
        <div class="school-year">
            '. $annees[0]->annee .'
        </div>
    </div>
</div>

';


    $html .= <<<HTML
<!-- ===== CONTENU ===== -->
<div class="">

    <!-- Inputs côte-à-côte -->
    <div class="row">
        <div class="field">
            <label for="frais">Type de frais</label>
            <select id="frais">
                 $options 
            </select>
        </div>

        <div class="field">
            <label for="bus_mois">Mois de bus</label>
            <select id="bus_mois">
                 $optionsBusMois 
            </select>
        </div>
    </div>

    <!-- Bouton scan -->
    <button class="btn-scan" onclick="scan()">📷 Scanner QR Code</button>

    <!-- Résultat -->
    <div id="scan-result"></div>
    <!-- button onclick="speak('Test de lecture vocale réussie')">
    🔊 Tester la voix
    </button -->
    <!-- Déconnexion -->
    <button class="btn-logout" onclick="logout()">🚪 Déconnexion</button>

</div>
<script>
(function () {
    const school = {
        name: "$ecole_nom_ecole",
        logo: "$logo"
    };

    localStorage.setItem('masomwetu_school', JSON.stringify(school));
})();

function updateScanResult(html) {
    document.getElementById('scan-result').innerHTML = html;
    
}

function speak(text) {
    if (window.AndroidScan && text) {
        AndroidScan.speak(text);
    }
}


function scan() {
    showScanLoader(); // 🔥 LOADER IMMÉDIAT
    var fraisId = document.getElementById('frais').value;
    var mois = document.getElementById('bus_mois').value;
    if(window.AndroidScan) AndroidScan.scan(fraisId, mois);
}
function logout() {
    if(window.AndroidScan) AndroidScan.logout();
}

function showScanLoader() {
    const div = document.getElementById('scan-result');
    div.innerHTML = `
        <div class="loader">
            <div class="spinner"></div>
        </div>
    `;
}

</script>

</body>
</html>
HTML;

    return response()->json([
        'success' => true,
        'token' => $token,
        'html' => $html
    ]);
});

/* =======================
   CHECK PAIEMENT
======================= */
Route::post('/check-paiement', function (Request $request) {
    
    Log::info('CHECK-PAIEMENT', [
        'headers' => $request->headers->all(),
        'body' => $request->all()
    ]);

    $request->validate([
        'qr_code' => 'required|integer',
        'mp_frais_id' => 'required|integer',
        'bus_moi_id' => 'nullable|integer'
    ]);

    // =========================
    // 1. TOKEN
    // =========================
    $token = $request->bearerToken();

    if (!$token) {
        return response()->json([
            'success' => false,
            'message' => 'Token manquant'
        ], 401);
    }

    $token = str_replace('Bearer ', '', $request->header('Authorization'));

    // 1️⃣ Chercher dans mysql
    $apiToken = DB::connection('mysql')
        ->table('api_tokens')
        ->where('token', $token)
        ->first();
    
    $connection = 'mysql';
    
    // 2️⃣ Sinon chercher dans mysql2
    if (!$apiToken) {
        $apiToken = DB::connection('mysql2')
            ->table('api_tokens')
            ->where('token', $token)
            ->first();
    
        if ($apiToken) {
            $connection = 'mysql2';
            DB::setDefaultConnection('mysql2');
        }
    }
    
    // 3️⃣ Toujours pas trouvé → KO
    if (!$apiToken) {
        /*return response()->json([
            'success' => false,
            'message' => 'Token invalide'
        ], 401);*/
        return response("
        <h2 style='color:red'>ERREUR</h2>
        <pre>" . json_encode($request->all(), JSON_PRETTY_PRINT) . "</pre>
        ", 401)->header('Content-Type', 'text/html');

    }


    // =========================
    // 2. UTILISATEUR
    // =========================
    $user = DB::table('bulletin_users')
        ->where('id', $apiToken->user_id)
        ->first();

    $frais = DB::table('mp_frais')
        ->where('id', $request->mp_frais_id)
        ->first();
        
    if (!$user) {
        return response()->json([
            'success' => false,
            'message' => 'Utilisateur introuvable'
        ], 404);
    }

    // =========================
    // 3. ÉLÈVE (classe + année)
    // =========================
    $ms_eleve_id = $request->qr_code;
    $eleve = DB::table('bulletin_ms_eleves as el')
        ->join('enfants as e', 'e.id', '=', 'el.enfant_id')
        ->join('bulletin_ms_classes as c', 'c.id', '=', 'el.ms_classe_id')
        ->join('bulletin_ms_annee_scolaires as a', 'a.id', '=', 'el.ms_annee_scolaire_id')
        ->where('el.id',$ms_eleve_id)
        ->select(
            'el.id',
            'el.ms_annee_scolaire_id',
            'el.ms_classe_id',
            'a.annee',
            'e.nom',
            'e.postnom',
            'e.prenom',
            'e.genre',
            'el.img',
            'c.classe'
        )
        ->first();

    if (!$eleve) {
        return response()->json([
            'success' => false,
            'message' => 'Élève introuvable'
        ], 404);
    }

    // =========================
    // 4. FRAIS CLASSE CORRECT
    // ========================= 
    $fraisClasse = DB::table('mp_frais_classes as fc')
        ->join('bulletin_ms_classes as c', 'c.id', '=', 'fc.ms_classe_id')
        ->where('ms_classe_id', $eleve->ms_classe_id)
        ->where('mp_frais_id', $request->mp_frais_id)
        ->where('ms_annee_scolaire_id', $eleve->ms_annee_scolaire_id)
        ->where('c.ecole_id', $user->ecole_id)
        ->select(
            'fc.id',
            'fc.montant'
        )
        ->first();
    
    $enOrdre = null;
    $fraisEnOrdre = null;
    if (!$fraisClasse) {
        return response()->json([
            'success' => false,
            'message' => 'Aucun frais configuré pour cet élève'
        ], 403);
    }
    else{
        // =========================
        // 5. TOTAL PAYÉ
        // =========================
        $totalPaye = DB::table('mp_frais_paiements')
            ->where('ms_eleve_id', $ms_eleve_id)
            ->where('mp_frais_classe_id', $fraisClasse->id)
            ->sum('montant_payer');
    
        // =========================
        // 6. STATUT
        // =========================
        $enOrdre = $totalPaye >= $fraisClasse->montant;
        $fraisEnOrdre = ($enOrdre) ? 'EN ORDRE' : 'NON EN ORDRE';
        $fraisHtml = "<!-- Frais -->
        <div class='section'>
            <div class='label'>Frais :
                <span class='value money'>
                    {$frais->frais}
                </span>
                <span>{$fraisEnOrdre}</span>
            </div>
        </div>
    
        <!-- Montants -->
        <div class='row'>
            <!--div class='section'>
                <div class='label'>Montant dû: 
                    <span class='value money'>
                        {$fraisClasse->montant} Fc
                    </span>
                </div>
            </div>
    
            <div class='section'>
                <div class='label'>Montant payé:
                <span class='value money'>
                    {$totalPaye} Fc
                </span>
                </div>
            </div-->
        </div>";
    }
    /*Log::info('DEBUG FRAIS CLASSE', [
        'connection' => DB::getDefaultConnection(),
        'fraisClasse_id' => $fraisClasse->id,
        'ms_eleve_id' => $ms_eleve_id,
        'montant_attendu' => $fraisClasse->montant,
        'str' => " $user->ecole_id, $eleve->ms_annee_scolaire_id, $request->mp_frais_id, $eleve->ms_classe_id ",
    ]);*/


    
    // =========================
    // 7. VÉRIFICATION TRANSPORT
    // =========================
    $busHtml = "";
    $busStatut = null;
    
    if ($request->filled('bus_moi_id') && $request->bus_moi_id!=-1) {
    
        // 7.1 Abonnement bus
        $busAbonnement = DB::table('bus_abonnements as ba')
            ->join('bus_mois as bm', 'bm.id', '=', 'ba.bus_moi_id')
            ->join('bus_tarrifs_arrets as bta', 'bta.id', '=', 'ba.bus_tarrifs_arret_id')
            ->join('bus_arrets as bar', 'bar.id', '=', 'bta.bus_arret_id')
            ->where('ba.ms_eleve_id', $ms_eleve_id)
            ->where('ba.bus_moi_id', $request->bus_moi_id)
            ->where('ba.ms_annee_scolaire_id', $eleve->ms_annee_scolaire_id)
            ->where('ba.ecole_id', $user->ecole_id)
            ->whereNull('ba.canceled_at')
            ->select(
                'ba.id as abonnement_id',
                'bm.mois',
                'bm.annee',
                'bar.nom_arret',
                'bar.quartier',
                'bta.montant_abonnement'
            )
            ->first();
    
        // ❌ NON ABONNÉ
        if (!$busAbonnement) {
    
            $busStatut = 'NON ABONNÉ';
            $busHtml = "
            <div class='bus-status danger'>
                🚫 Transport : Non abonné
            </div>";
    
        } else {
    
            // 7.2 Paiement bus
            $totalBusPaye = DB::table('bus_paiements')
                ->where('bus_abonnement_id', $busAbonnement->abonnement_id)
                ->where('ms_annee_scolaire_id', $eleve->ms_annee_scolaire_id)
                ->where('ecole_id', $user->ecole_id)
                ->sum('montant');
    
            // ❌ NON EN ORDRE
            if ($totalBusPaye < $busAbonnement->montant_abonnement) {
    
                $busStatut = 'NON EN ORDRE';
                $busHtml = "
                <div class='bus-status warning'>
                    ⚠️ Transport : Non en ordre
                </div>";
    
            } else {
    
                // ✅ EN ORDRE
                $busStatut = 'EN ORDRE';
                $busHtml = "
                <div class='bus-status success'>
                    🚌 Transport en ordre<br>
                    <strong>Arrêt :</strong> {$busAbonnement->nom_arret}<br>
                    <strong>Mois :</strong> {$busAbonnement->mois} {$busAbonnement->annee}
                </div>";
            }
        }
    }

    
    $s = $enOrdre;
    if($busStatut!==null)
        $s = ($enOrdre and $busStatut == 'EN ORDRE');
    
    $statutSpeack = $s ? 'EN ORDRE' : "Attention. Élève non en ordre de paiement. ".($enOrdre ?'':'Minerval non payé ').($busStatut == 'EN ORDRE'?'':($busStatut === null?'':'Transport non payé'));
    
    
    $statutEnOrdre = '
    <div class="status-container">
        <div class="status-ok-circle">
            <span class="status-ok-icon">✔</span>
        </div>
    
        <h2 class="status-ok-text">EN ORDRE</h2>
    </div>
    ';
    $statutNonEnOrdre = '
    <div class="status-container">
        <div class="status-ok-circle status-no-circle">
            <span class="status-ok-icon">✖</span>
        </div>
        <h2 class="status-no-text status-ok-text">PAS EN ORDRE</h2>
    </div>
    ';
    $statut = $s ? $statutEnOrdre : $statutNonEnOrdre;
    
    $color  = $s  ? '#2ecc71' : '#e74c3c';

    $html = "
    <script>
        speak('{$statutSpeack}');
    </script>
    
    <style>
    .status {
        background: {$color};
    }
    .value {
        color: {$color};
    }
    </style>
    
    <img src='".($eleve->img?asset('storage/mseleve/img/'.$eleve->img):asset('img/users25.png'))."' style='width: 50%;margin-left:24%;border-radius:50%' alt='Image' id='img-enfant'>
    <div class='scan-card'>

        <!-- Élève -->
        <div class='section'>
            <div class='label'>Élève</div>
            <div class='value'>
                {$eleve->nom} {$eleve->postnom} {$eleve->prenom} ({$eleve->genre})
            </div>
        </div>
    
        <!-- Classe & Année -->
        <div class='row'>
            <div class='section'>
                <div class='label'>Classe: <span class='value'>{$eleve->classe}</span></div>
                
            </div>
    
            <div class='section'>
                <div class='label'>Année scolaire: <span class='value'>{$eleve->annee}</spna></div>
                
            </div>
        </div>
    
        <hr class='divider'>
        {$fraisHtml}
    </div>

    {$busHtml}
    {$statut}
    
    
    <div class='footer'>
        Masomwetu • Vérification des paiements
    </div>



";

    // return response($html, 200)->header('Content-Type', 'text/html');
    
    return response()->json([
        'success' => true,
        'html_fragment' => $html
    ]);
    
});

Route::get('/ping', function () {
    return response()->json([
        'success' => true,
        'app' => 'Masomwetu',
        'time' => now()
    ]);
});