@extends('template')


@section('content')

<style>
	div.form-group{
		display:none;
		
	}
</style>

<div class="row">
	<div class="col-md-12">

		<div class="col-md-5 col-sm-5 col-xs-12 no-padding">
		<div class="box box-solid">
            <!-- /.box-header -->
            <div class="box-body">
              <div class="box-group" id="accordion">
                <!-- we are adding the .panel class so bootstrap.js collapse plugin detects it -->
                <div class="panel box box-primary" style="margin-bottom:20px;box-shadow: 2px 2px 2px rgba(0,0,0,0.5);">
                  <div class="box-header with-border bg-aqua">
                    <h4 class="box-title">
                      <a data-toggle="collapse"  style="color:#fff"  data-parent="#accordion" href="#collapseOne" aria-expanded="false" class="collapsed">
                        Justifier l'absence d'un agent
                      </a>
                    </h4>
                  </div>
                  <div id="collapseOne" class="panel-collapse collapse in" aria-expanded="true" style="height: auto;">
                    <div class="box-body">
						<form enctype="multipart/form-data" class="form-horizontal" action="{{route('pointages.store')}}" method="POST">
							{{csrf_field()}}
							<div class="col-sm-offset-3 col-sm-9" style="display:none">
								<div class="checkbox">
									<label style="color: #7d4982;font-weight: bold;font-style: italic;">
										<input value="ok" checked type="checkbox" name="keep_the_form">Rester sur le formulaire.
									</label>
								</div>
								<div class="checkbox">
									<label style="color: #7d4982;font-weight: bold;font-style: italic;">
										<input value="ok" type="checkbox" name="keep_form_data">Conserver les donnees du formulaire.
									</label>
								</div>
							</div>
							@include('Masomwetu.Presence.pointages._form',['submitButtonText'=>'Valider Justification'])
						</form>
                    </div>
                  </div>
                </div>
                <div class="panel box box-danger" style="box-shadow: 2px 2px 2px rgba(0,0,0,0.5);">
                  <div class="box-header with-border bg-red">
                    <h4 class="box-title">
                      <a data-toggle="collapse" style="color:#fff" data-parent="#accordion" href="#collapseTwo" class="collapsed" aria-expanded="false">
                        Prevenir l'indisponibilite d'un agent
                      </a>
                    </h4>
                  </div>
                  <div id="collapseTwo" class="panel-collapse collapse" aria-expanded="false" style="height: 0px;">
                    <div class="box-body">	
						<form enctype="multipart/form-data" id="conger" class="form-horizontal" action="{{route('personnel_presence.justification')}}" method="POST">
							{{csrf_field()}}
							<div class="col-sm-offset-3 col-sm-9" style="display:none">
								<div class="checkbox">
									<label style="color: #7d4982;font-weight: bold;font-style: italic;">
										<input value="ok" checked type="checkbox" name="keep_the_form">Rester sur le formulaire.
									</label>
								</div>
								<div class="checkbox">
									<label style="color: #7d4982;font-weight: bold;font-style: italic;">
										<input value="ok" type="checkbox" name="keep_form_data">Conserver les donnees du formulaire.
									</label>
								</div>
							</div>
							@include('Masomwetu.Presence.previsionarriveesorties._form',['submitButtonText'=>'Enregistrer Prevision'])
						</form>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <!-- /.box-body -->
          </div>
		
		</div>
		
		<div class="col-md-7 col-sm-7 col-xs-12">
				@php display_flash(); @endphp
			<div class="box box-primary">
				<div class="box-header with-border">
				  <h3 class="box-title"> Absences justifiees au cours du mois</h3>
				</div>
				<div class="box-body">
					<table id="datatable-pointages" class="table table-striped table-bordered">
						<thead>
							<tr>								
								<th>Date</th>
								<th>Agent</th>
								<th>Justification</th>
								<th>Observation</th>
							</tr>
						</thead>
						<tbody>
						@foreach($pointages as $key => $pointage)
							<tr>									
								<td class='editable-td' k='{{$pointage->id}}' f='jour' c='Pointage'>{{ $pointage->jour }}</td>
								<td>{{ ($pointage->personnel->noms??'') }}</td>
								<td>{{ ($pointage->justifAbsence->justification??'') }}</td>
								<td class='editable-td' k='{{$pointage->id}}' f='observation' c='Pointage'>{{ $pointage->observation }}</td>
							</tr>
						@endforeach
						</tbody>
					</table>
				</div>
				
			</div>
			
			<div class="box box-primary">
				<div class="box-header with-border">
				  <h3 class="box-title"> Prevention des indisponibilites des agents</h3>
				</div>
				<div class="box-body">
					<table id="datatable-previsionarriveesorties" class="table table-striped table-bordered">
						<thead>
								<tr>		
									<th>Jour</th>							
									<th>Agent</th>
									<th>Justification</th>
									<th>Fin validité</th>
								</tr>
						</thead>
						<tbody>
						@foreach($previsionarriveesorties as $key => $previsionarriveesortie)
							<tr title="{{ $previsionarriveesortie->observation }}">
									
									<td class='editable-td' k='{{$previsionarriveesortie->id}}' f='jour_semaine' c='PrevisionArriveeSortie'>{{ $SEMAINE[$previsionarriveesortie->jour_semaine] }}</td>
									<td>{{ ($previsionarriveesortie->personnel->noms??'') }}</td>
									<td>{{ ($previsionarriveesortie->justifAbsence->justification??'') }}</td>
									<td class='editable-td' k='{{$previsionarriveesortie->id}}' f='date_fin_validite' c='PrevisionArriveeSortie'>
									du {{ $previsionarriveesortie->date_debut_validite??date('Y-m-d') }} au {{ $previsionarriveesortie->date_fin_validite }}</td>
							</tr>
						@endforeach
						</tbody>
					</table>
				</div>
				
			</div>
		</div>
		
	</div>
</div>
		
@endsection  


@section('script')
<script>
$(function(){
	$('#input-jour-id').parent().parent().show()
	$('#input-personnel_id-id').parent().parent().show()
	$('#input-justif_absence_id-id').parent().parent().show()
	$('#input-observation-id').parent().parent().show()
	
	$('#input-date_fin_validite-id').parent().parent().show()
	$('#input-date_debut_validite-id').parent().parent().show()
	$('#conger #input-justif_absence_id-id').parent().parent().show()
	$('#conger #input-observation-id').parent().parent().show()
	$('#conger #input-personnel_id-id').parent().parent().show()
	$('#input-jour_semaine-id').parent().parent().show()
	
	$('#input-heure_arrivee-id').val('00:00:00')
	$('#input-heure_sortie-id').val('00:00:00')
	
	$('#input-jour_semaine-id').parent().html("<select name='jour_semaine[]' multiple id='input-jour_semaine-id' class='form-control' ><option value='1'>Lundi</option><option value='2'>Mardi</option><option value='3'>Mercredi</option><option value='4'>Jeudi</option><option value='5'>Vendredi</option><option value='6'>Samedi</option><option value='0'>Dimanche</option></select>")
})
</script>
@endsection
