@extends('personnel_dossier.index')

@section('liste')
<link href="{{asset('cropper_fichiers/croppie.css')}}" rel="stylesheet">
<style>
.mailbox-attachments li {
    overflow: hidden;
    height: 200px;
}
@media (max-width:500px){
  .cr-boundary {
    width: 100% !important;
  }
}

#entet-doc, ul#liste_dossier{
	display:none;
}

@media print{
	#agent-image{
		width:38%;
		display:inline-block;
		vertical-align:top;
	}
	#agent-infos{
		width:60%;
		display:inline-block;
		vertical-align:top;
	}
	
	#agent-etudes{
		width:48%;
		display:inline-block;
		vertical-align:top;
	}
	#agent-fonctions{
		width:48%;
		display:inline-block;
		vertical-align:top;
	}
	.btn-sup{
		display:none;
	}
	img#entet-doc, ul#liste_dossier{
		display:inline-block;
		width:100%;
	}
}
	#div-form-dossier{
		display:none;
	}
</style>
	<section class="content">
		<img src="{{asset('img/entete.png')}}" style="width:100%;" id="entet-doc" />
		<div class="col-md-4" id="agent-image">
			@include('personnel_dossier._image_agent')
        </div>
				
		
		<div class="col-md-8" id="agent-infos">
		<div class="box">
            <div class="box-header with-border bg-green">
              <h3 class="box-title">INFORMATIONS SUR LE DOSSIER</h3>
            </div>
            
            <div class="box-body  editable-table" stylee="padding-top: 0;">
			@if($personnel)
              <table class="table table-bordered table-condensed" style="box-shadow: 0 1px 1px rgba(0,0,0,0.1);">
                <tbody><tr>
					<th style="width:150px">Noms</th>
					<td><label class='td-detail editable-td' k='{{$personnel->id}}' f='noms' i='0'>{{ $personnel->noms }}</label> Prénom: 
					<label class='td-detail editable-td' k='{{$personnel->id}}' f='prenom' i='0'>{{ $personnel->prenom??'-' }}</label></td></tr>
					<tr><th>Genre</th>
					<td class='td-detail editable-td' k='{{$personnel->id}}' f='genre' i='0'>{{ $personnel->genre }}</td></tr>
					<tr><th>Date Naissance</th>
					<td class='td-detail editable-td' k='{{$personnel->id}}' f='date_naissance' i='0'>{{ $personnel->date_naissance }}</td></tr>
				</tbody>
			  </table>
			  <p style="background:#3c8dbc;height: 5px;margin-top: 10px;"> &nbsp; </p>
			  <table class="table table-bordered table-condensed" style="box-shadow: 0 1px 1px rgba(0,0,0,0.1);">
			  <tbody>
					<tr><th style="width:150px">Adresse</th>
					<td class='td-detail editable-td' k='{{$personnel->id}}' f='adresse' i='0'>{{ $personnel->adresse }}</td></tr>
					<tr><th>Téléphone</th>
					<td class='td-detail editable-td' k='{{$personnel->id}}' f='telephone' i='0'>{{ $personnel->telephone }}</td></tr>
					<tr><th>Adresse e-mail</th>
					<td class='td-detail editable-td' k='{{$personnel->id}}' f='adresse_mail' i='0'>{{ $personnel->adresse_mail }}</td></tr>
				</tbody>
			  </table>
			  <p style="background:#3c8dbc;height: 5px;margin-top: 10px;">&nbsp; </p>
			  <table class="table table-bordered table-condensed" style="box-shadow: 0 1px 1px rgba(0,0,0,0.1);">
			  <tbody>
					<tr>
						<th style="width:150px">Etat-Civil</th>
						<th>Sit.-Familiale</th>
						<th>Nationalité</th>
					</tr>
					<tr>
						<td class='td-detail editable-td' k='{{$personnel->id}}' f='etat_civil' i='0'>{{ $personnel->etat_civil }}</td>
						<td class='td-detail'><span style="font-size: 20px;" class="label label-warning editable-td" k='{{$personnel->id}}' f='sifa' i='0'>{{ $personnel->sifa }}</span></td>
						<td class='td-detail editable-td' k='{{$personnel->id}}' f='nationalite' i='0'>{{ $personnel->nationalite }}</td>
					</tr>					
              </tbody>
			  </table>
			  @endif
            </div>
            <!-- /.box-body 
            <div class="box-footer clearfix">
			
            </div>-->
          </div>
          <!-- /.box -->

        </div>
		@if($personnel)
		<div class="col-md-12">
		@php
			$default_hr_arrivee_prevue = \App\Config::getParamVal('HEURE-ARRIVEE-AGENT')??'08:30:00';// "08:00:00";
			$default_hr_sortie_prevue = \App\Config::getParamVal('HEURE-SORTIE-AGENT')??'16:30:00';// "08:00:00";
			$tab_charge=["arrivees"=>[0=>["",""]],"sorties"=>[0=>["",""]]];
			
			for($jour_semaine = 1;$jour_semaine < 7; $jour_semaine++){
    		    $charge_hr = \DB::table("pointage_heures_arrivee_sorties")->where('personnel_id',$personnel->id)->where('jour_semaine',$jour_semaine)->first();
    			if(!$charge_hr){
        			$data = ['personnel_id'=>$personnel->id 
        			,'heure_sortie'=>$default_hr_sortie_prevue 
        			,'heure_arrivee'=>$default_hr_arrivee_prevue 
        			,'jour_semaine'=>$jour_semaine]; 
        			
        			$id = \DB::table("pointage_heures_arrivee_sorties")->insertGetId($data);
        			
    			    $tab_charge["arrivees"][$jour_semaine] = [$id,$default_hr_arrivee_prevue];
    			    $tab_charge["sorties"][$jour_semaine] = [$id,$default_hr_sortie_prevue]; 
    			}
    			else { 
    			    $id = $charge_hr->id;
    			    $tab_charge["arrivees"][$jour_semaine] = [$id,$charge_hr->heure_arrivee];
    			    $tab_charge["sorties"][$jour_semaine] = [$id,$charge_hr->heure_sortie];
    			}
			}
			$semaines = ["Dim","Lun","Mar","Mer","Jeu","Ven","Sam"];
			echo "<h3 style='margin:0;padding:3px;font-weight:bolder;color:#fff;background:#3c8dbc'>PREVISIONS DES ENTREES & SORTIES HEBDOMADAIRES</h3>
			<table class='table table-condensed table-striped editable-table table-bordered' style='background: white;border: solid 2px;'>";
			echo "<tr><th>JOURS</th>"; foreach($semaines as $i=>$jr){ echo "<th>$jr</th>"; } echo "</tr>";
			echo "<tr><th>ARRIVEES</th>"; foreach($semaines as $i=>$jr){ echo "<td class='editable-td' k='".$tab_charge["arrivees"][$i][0]."' f='heure_arrivee' i='80'>".$tab_charge["arrivees"][$i][1]."</td>"; } echo "</tr>";
			echo "<tr><th>SORTIES</th>"; foreach($semaines as $i=>$jr){ echo "<td class='editable-td' k='".$tab_charge["sorties"][$i][0]."' f='heure_sortie' i='80'>".$tab_charge["sorties"][$i][1]."</td>"; } echo "</tr>";
			echo "</table>";
		@endphp
		</div>
		<div class="col-md-12">
			<div class="col-md-6" id="agent-fonctions"  style="padding-right: 0;padding-left:5px;">
			  <div class="box">
				<div class="box-header bg-green">
				  <h3 class="box-title">FONCTIONS</h3>
				</div>
				<!-- /.box-header -->
				<div class="box-body padding">
				  <table class="table table-bordered table-condensed editable-table" style="box-shadow: 0 1px 1px rgba(0,0,0,0.1);">
					<tbody>
					<tr style="background: #8f919475;">
						<th>Nom-Fonction</th>
						<th>Date Début</th>
						<th>Anciennete</th>
						<th class="no-print"></th>
					</tr>
					@foreach($personnel->agents as $ag)
						<tr>
							<td class='editable-td' k='{{$ag->id}}' f='mc_fonction_id' i='1' t='select' s='Fonction' >{{$ag->mcFonction->fonction}}</td>
							<td class='editable-td' k='{{$ag->id}}' f='date_engagement' i='1' t='date' >{{$ag->date_engagement}}</td>
							<td>{{ date('Y') - date('Y',strtotime($ag->date_engagement)) }} Ans</td>
							<td class="no-print">
							<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('agents.destroy',$ag)}}" method="POST">
								{{csrf_field()}}
								{{method_field('DELETE')}} 
								<input name="redirectTo" value="{{route('personnel.dossier')}}/{{$personnel->id}}" type="hidden" />
								<button id="supprimer-personnel" class="btn btn-xs bg-red" type="submit"><i class="fa fa-close"></i></button>
							</form>
							</td>
						</tr>
					@endforeach
				  </tbody></table>
				</div>
				<!-- /.box-body -->
			  </div>
			  <!-- /.box -->
			</div>
			<div class="col-md-6" id="agent-etudes" style="padding-left: 0;padding-right:5px;">
			  <div class="box">
				<div class="box-header bg-green">
				  <h3 class="box-title">ETUDES FAITES</h3>
				</div>
				<!-- /.box-header -->
				<div class="box-body padding">
				  <table class="table table-bordered table-condensed  editable-table" style="box-shadow: 0 1px 1px rgba(0,0,0,0.1);">
					<tbody>
					<tr style="background: #8f919475;">
						<th>ANNEE</th>
						<th>FACULTE</th>
						<th>QUAL.</th>
						<th class="no-print">OBSERVATIONS</th>
						<th class="no-print"></th>
					</tr>
					@foreach($personnel->niveauEtudePersonnels as $nv)
						<tr>
							<td class='editable-td' k='{{$nv->id}}' f='annee' i='2'>{{$nv->annee}}</td>
							<td class='editable-td' k='{{$nv->id}}' f='diplome_brevet_licence' c='2'>{{$nv->diplome_brevet_licence}}</td>
							<td class='editable-td' k='{{$nv->id}}' f='qualification' i='2'>{{$nv->qualification}}</td>
							<td class='editable-td no-print' k='{{$nv->id}}' f='observation' i='2'>{{$nv->observation}}</td>
							<td class="no-print">
							<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('niveauetudepersonnels.destroy',$nv)}}" method="POST">
								{{csrf_field()}}
								{{method_field('DELETE')}} 
								<input name="redirectTo" value="{{route('personnel.dossier')}}/{{$personnel->id}}" type="hidden" />
								<button id="supprimer-personnel" class="btn btn-xs bg-red" type="submit"><i class="fa fa-close"></i></button>
							</form>
							</td>
						</tr>
					@endforeach
				  </tbody></table>
				</div>
				<!-- /.box-body -->
			  </div>
			  <!-- /.box -->
			</div>
        </div>
		@endif
		<div class="col-md-12">
		
          <div class="box">
            <div class="box-header bg-green">
              <h3 class="box-title">DOSSIERS ({{$personnel->dossierPersonnels->count()}})</h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body ">
				<div class="col-md-6 col-md-offset-3 no-print" id="div-form-dossier" >
				<form enctype="multipart/form-data" class="form-horizontal" action="{{route('personnel.dossier.store')}}" method="POST">
					{{csrf_field()}}
					<div class="form-group">
						<label for="input-description-id" class="col-sm-3 control-label">Documents</label>

						<div class="col-sm-3">
							<input name="scan[]" id="input-scan-id" multiple type="file" style="display:nonee">					
						</div>
					</div>
					
					<div class="col-sm-offset-3 col-sm-9">
						<div class="checkbox">
							<label style="color: #7d4982;font-weight: bold;font-style: italic;">
								<input value="ok" checked type="checkbox" name="keep_the_form">Rester sur le formulaire.
							</label>
						</div>
						<div class="checkbox">
							<label style="color: #7d4982;font-weight: bold;font-style: italic;">
								<input value="ok" checked type="checkbox" name="keep_form_data">Conserver les donnees du formulaire.
							</label>
						</div>
					</div>
					<input value="{{route('personnel.dossier').'/'.$personnel->id}}" type="hidden" name="redirectTo"/>
					
					@include('Masomwetu.School.dossierpersonnels._form',['submitButtonText'=>'Enregistrer'])
					<div class="form-group">
						<label for="input-description-id" class="col-sm-3 control-label"></label>

						<div class="col-sm-3">
							<button onclick="afficher_form_dossier(false)" type="reset" class="btn btn-default"><i class="fa fa-bin"></i> Annuler</button>						
						</div>
					</div>
					
				</form>
				</div>
				<div class="col-md-12" id="div-liste-dossier">
				<ul class="mailbox-attachments clearfix no-print">
					<li onclick="afficher_form_dossier(true)">		
						<a href="#x" class="mailbox-attachment-name" style="background: #f4f4f4;display: block;text-align: center;">
							Dossier sans titre
						</a>
					  <span class="mailbox-attachment-icon" style="cursor:pointer;" ><i class="glyphicon glyphicon-folder-open"></i></span>

					  <div class="mailbox-attachment-info">
						<label class="btn btn-default btn-xs"  href="#" class="mailbox-attachment-name"><i class="fa fa-paperclip"></i> Nouveau Dossier</label>
							
					  </div>
					</li>
				@php $liste_dossier=''; @endphp
                @foreach($personnel->dossierPersonnels as $d)
				@php 
					$count_img = $d->imgDocuments->count(); 
					$liste_dossier .= '<li><a href="#"><i class="glyphicon glyphicon-folder-open"></i> '.$d->titre_document.'</a></li>';
				@endphp
					<li>	
						
						<form style="margin: 0;display:none;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('dossierpersonnels.destroy',$d)}}" method="POST">
							{{csrf_field()}}
							{{method_field('DELETE')}} 
							<input name="redirectTo" style="display:none" value="{{route('personnel.dossier')}}/{{$personnel->id}}" >
							<button id="supprimer-dossier-personnel-{{$d->id}}" class="btn btn-xs bg-red" type="submit"></button>
						</form>
						<a href="#x" class="mailbox-attachment-name" style="background: #f4f4f4;display: block;text-align: center;padding: 2px;">
							{{$d->titre_document}} <label class="bg-red btn pull-right btn-xs" for="supprimer-dossier-personnel-{{$d->id}}"><i class="fa fa-close"></i></label>
							
						</a>			
						@if(!$count_img)
						  <label for="input-scan-id-{{$d->id}}" class="mailbox-attachment-icon" style="cursor:pointer;font-size: 62px;" >
							<a><i class="glyphicon glyphicon-file"></i></a>
						  </label>
						  @php $text = "Nouveau document"; @endphp
						@else
						  @php 
							$text = "Ajouter document";
							$imgs = '';
							foreach($d->imgDocuments as $ig)
								$imgs.=';'.$ig->scan.'!'.$ig->id;
						  @endphp
						  <span class="mailbox-attachment-icon has-img" data-toggle="modal" data-target="#modal-default"
							attr-img="{{$imgs}}" title="{{$d->titre_document}}" >
							<img title="{{$d->description}}" src="{{ asset('storage/imgdocument/scan/'.$d->imgDocuments[0]->scan)}}" style="height: 133px;" alt="Attachment">
						  </span>
						@endif
						
						
						@if($d->imgDocuments->count()==1)
						  <form style="margin: 0;display:none;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{ URL::to('imgdocuments') }}/{{$d->imgDocuments[0]->id}}" method="POST">
							{{csrf_field()}} {{method_field("DELETE")}}
							<input name="redirectTo" style="display:none" value="{{route('personnel.dossier')}}/{{$personnel->id}}" >
							<button id="supprimer-doc-img-pers-{{$d->id}}" class="btn btn-xs bg-red" type="submit"></button>
						  </form>
						@endif

						<div class="mailbox-attachment-info">						
							<form enctype="multipart/form-data" action="{{route('imgdocuments.store')}}" method="POST">
								{{csrf_field()}}
								<input type="hidden" value="{{$d->id}}" name="dossier_personnel_id" />
								<input  name="scan" class="input-scan-id" id="input-scan-id-{{$d->id}}" type="file" style="display:none">	  
								<input value="ok" checked type="checkbox" name="keep_the_form" style="display:none">
								<input value="Enregistrer" type="submit" style="display:none">
							</form>
							<label class="btn btn-default btn-xs"  for="input-scan-id-{{$d->id}}" class="mailbox-attachment-size">
							  <i class="fa fa-paperclip"></i> {{$text}} 
							  [
								  @if($count_img==1)
								  <label class="bg-red btnn btn-xs" style="margin: 0;" for="supprimer-doc-img-pers-{{$d->id}}"><i class="fa fa-close"></i></label>
								  @else 
								  {{$count_img}} docs.
								  @endif
							  ]
							</label>
						</div>
					</li>	
				@endforeach
              </ul>
			  
			  
			  <ul class="nav nav-pills nav-stacked" id="liste_dossier" >
			  {!! $liste_dossier !!}
			  </ul>
			
				</div>
			</div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->
        </div>
		
		
	</section>
	<div id="uploadimageModal" class="modal" role="dialog">
		<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal">&times;</button>
				<h4 class="modal-title">Cadrez l'Image</h4>
			</div>
			<div class="modal-body" style="padding: 0;">
				<div id="image_demo" style="width:auto"></div>
			
			</div>
			<div class="modal-footer" style="padding-top: 0;">
				<button class="btn btn-success crop_image">Valider</button>
				<button id="crop_image-reset" type="button" class="btn btn-default" data-dismiss="modal">Annuler</button>
			</div>
		</div>
		</div>
	</div>
	@include('personnel_dossier._dossier_modal')
@endsection

@section('script')

<script type="text/javascript" src="https://html2canvas.hertzen.com/dist/html2canvas.min.js"></script>
<script src="{{asset('cropper_fichiers/croppie.js')}}"></script>
	<script>
    var IMAGE1 = '';
    var IMAGE2 = '';
	  $(function(){
	        $("#lolcat").mousedown(function() {
                $(this).data("dragging", true);
            });
            
            $("#lolcat").mouseup(function() {
                $(this).data("dragging", false);
            });
            
            $("#lolcat").mousemove(function(e) {
                if (!$(this).data("dragging"))
                    return;
                $(this).css("left", e.clientX - $(this).width()/2);
                $(this).css("top", e.clientY - $(this).height()/2);
            });

		  $('button.btn.btn-xs.bg-red').attr('title',"cliquer pour supprimer la ligne")
		  
		  $('div .checkbox').hide();
		  $('#input-personnel_id-id').parent().parent().hide();
		  
		  $('.input-scan-id').change(function(){
			  if($(this).val()){
				  if(confirm('Voulez-vous sauvegarder ce document..?')){
					  $(this).parent().submit();
				  }
				  else $(this).val('');
			  }
		  })
		  $('.mailbox-attachment-icon.has-img').click(function(){
				var title = $(this).attr('title')
				var imgs = $(this).attr('attr-img').split(';');
				var src = "{{asset('storage/imgdocument/scan')}}";
				var div = '', ul='';
				var j = 0, active='';
				for(i in imgs){
					var t = imgs[i].split('!')
					var img = t[0]
					if(img){
						var action = "{{ URL::to('imgdocuments') }}/"+t[1]
						var redirectTo = "{{route('personnel.dossier')}}/{{$personnel->id}}"
						var label = '<label for="supprimer-doc-img-personnel-'+t[1]+'"><i class="fa fa-close"></i><label>'
						var form = '<form style="margin: 0;display:none;" onsubmit="return confirm(\'Voulez-vous supprimer ?\')" action="'+action+'" method="POST">'+
							'{{csrf_field()}} {{method_field("DELETE")}} '+
							'<input name="redirectTo" style="display:none" value="'+redirectTo+'" >'+
							'<button id="supprimer-doc-img-personnel-'+t[1]+'" class="btn btn-xs bg-red" type="submit"></button>'+
						'</form>';
						
						active = div?'':'active';
						ul+='<li data-target="#carousel-example-generic" data-slide-to="'+(j++)+'" class="'+active+'"></li>';
						div+='<div class="item '+active+'"><img src="'+src+'/'+img+'" style="width: 100%;"> <div class="carousel-caption"> '+title+' '+form+' '+label+' </div> </div>';
					}
				}
				console.log(ul)
				$('.carousel-inner').html(div);				
				$('.carousel-indicators').html(ul);				
				
		  })
		  
		  
    	var TOUR = 0;
    	$image_crop = $('#image_demo').croppie({
    		enableExif: true,
    		viewport: {
        		width:200,
        		height:200,
        		// type:'square' //circle
        		type:'square' //
    		},
    		boundary:{
        		//width:500,
        		height:300
    		}
    	});
      
    	// sauvegarde temporaire de l'image apres cropping
    	$('.crop_image').click(function(event){
    		$image_crop.croppie('result', {
    		    type: 'canvas',
    		    // size: 'viewport',
    		    // size: 'original',
    		    size: {width: 500, height: 500, type: 'square'},
    		    format:'jpeg',
    		    quality:1
    		}).then(function(response){
    			$('#val_img_enfant').val(response);
    			$("#img-enfant").attr('src',response);	
    		    enregistre_image();	
    		})
    		// console.log() 
    		$('#uploadimageModal').modal('hide');
    		    
    	});
    	
      	// chargement du croppeur a l'upload de l'image
      	$('label [for="img_enfant"]').on('click', function(){
    		$('#img_enfant').val('');
    		$("#img-enfant").attr('src','{{asset('img/users25.png')}}');
    	});
    	// chargement du croppeur a l'upload de l'image
    	$('#img_enfant').on('change', function(){
    		TOUR = $(this).attr('id');
    		var reader = new FileReader();
    		reader.onload = function (event) {
    		$image_crop.croppie('bind', {
    			url: event.target.result
    		}).then(function(){
    			console.log('jQuery bind complete');
    		});
    		}
    		reader.readAsDataURL(this.files[0]);
    		$('#uploadimageModal').modal('show');
    	});
    	$('#btn-enregistre-image').click(function(event){
    		enregistre_image();
    	});
    	$('.overlay.form-overlay').click(function(event){
    	    if(confirm("Voulez-vous ignorer le traitement au serveur ?"))$(this).hide();
    	});
    	function save_img(dataImg){
    	    $.ajax({
    			url:"{{route('personnel.update.image')}}",
    			type: "POST",
    			data:{"_token":"{{csrf_token()}}","image1": dataImg,"personnel_id": {{$personnel->id}},"personnel": 'ok'},
    			success:function(data)
    			{
    			    $(".overlay.form-overlay").hide();
        			$('#uploadimageModal').modal('hide');
        			$('#uploaded_image').html(data);
    			}
    		});
    	}
    	
    	function save_screenshort(screenshotTarget){
            html2canvas(screenshotTarget,{
                allowTaint: true,logging:true,
                useCORS: true
              }).then(canvas => {
            	// to image as png use below line
                // const base64image = canvas.toDataURL("image/png");
            	// show the image in window use below line
                // window.location.href = base64image;
            	
            	// screenshot appended to the body as canvas
                document.body.appendChild(canvas);  
                dataURL = canvas.toDataURL();  
                
                // to print the screenshot in console use below line
                    // window.open(dataURL);
                 console.log(dataURL,canvas);
                
                // following line is optional and it is to save the screenshot
                // on the server side. It initiates an ajax call
                // pushScreenshotToServer(dataURL); 
                /*$.ajax({
        			url:"{{route('personnel.update.image')}}",
        			type: "POST",
        			data:{"_token":"{{csrf_token()}}","image1": dataURL,"personnel_id": {{$personnel->id}},"personnel": 'ok'},
        			success:function(data)
        			{
        			    $(".overlay.form-overlay").hide();
            			$('#uploadimageModal').modal('hide');
            			$('#uploaded_image').html(data);
        			}
        		});*/
            }); 
    	} 
    	function enregistre_image(){
    		if(!confirm("ENREGISTRER ?"))return false;
    	    $(".overlay.form-overlay").show(); 
    	    save_img($('#val_img_enfant').val())
    	    /*
    	    const screenshotTarget = document.getElementsByClassName("cr-viewport")[0];//document.body ;
    	    save_screenshort(screenshotTarget);*/
    	}

	  })
	  function afficher_form_dossier(true_or_false){
		  if(true_or_false){
			  $('#div-form-dossier').slideDown(500);
			  $('#div-liste-dossier').slideUp(500);
		  }
		  else {
			  $('#div-liste-dossier').slideDown(500);
			  $('#div-form-dossier').slideUp(500);
		  }
			  
	  }
	</script>
@endsection