@extends('os.index')
@section('title')
@endsection
@section('page')

	<!-- FORMULAIRE DES ORPERATION --> 
	<div class="row">
		<br/>
			@php display_flash(5000,"position: absolute;top: -40px;z-index: 20;right: 0;padding: 5px 20px;width: 500px;"); @endphp
			<div class="col-md-6">					
				<div class="panel panel-success{{$cptCompteBudgetisers?' panel-toggled':''}}">
					<div class="panel-heading">
						<h3 class="panel-title"><strong>ENREGISTRER UNE PREVISION BUDGETAIRE</strong> </h3>					
						<ul class="panel-controls">
							<li><a href="#" class="panel-collapse"><span class="fa fa-angle-{{$cptCompteBudgetisers?'up':'down'}}"></span></a></li>
						</ul>                                   
					</div>
					<div class="panel-body">
						<form enctype="multipart/form-data" class="form-horizontal" action="{{route('compta.prevision')}}" method="POST">
							{{csrf_field()}}							
							<div class="form-group">
								<label for="input-compte_id-id" class="col-sm-3 control-label">Prévison *</label>

								<div class="col-sm-6">
									<select required name="cpt_previsions_budgetaire_id" id="input-compte_id-id"  class="form-control">
										<option value="">Choisir</option>
										@foreach($cptPrevisionsBudgetaires as $e)
										<option value="{{$e->id}}">PREVISION de {{($e->annee)}}</option>
										@endforeach
									</select>
								</div>
							</div>
							<div class="form-group" style="display:{{$user->cptComptables->count()==1?'none':'block'}}">
								<label  class="control-label col-md-3 col-xs-12">Secteur *</label>
								<div class="col-md-6 col-xs-12">
									<select name="cpt_secteur_id" required  class="form-control select2 select" data-live-search="true">
										<option value="">Ce mouvement est fait dans quel secteur ?</option>
										@foreach($user->cptComptables as $e)
										<option value="{{$e->cpt_secteur_id}}"> {{$e->cptSecteur->nom}}</option>
										@endforeach
									</select>
								</div>
							</div>	
							<div class="form-group">
								<label for="input-compte_id-id" class="col-sm-3 control-label">Compte *</label>

								<div class="col-sm-6">
									<select required name="compte_id" id="input-compte_id-id"  class="form-control select " data-live-search="true">
										<option value="">Choisir</option>
										@foreach($comptes as $e)
										<option value="{{$e->id}}"> {{$e->categorieCompte->entree?"ENTREE":"SORTIE"}} {{($e->code??'')}} {{($e->libelle??'')}}</option>
										@endforeach
									</select>
								</div>
							</div>
							<div class="form-group">
								<label for="input-montant_limit-id" class="col-sm-3 control-label">Montant limite *</label>

								<div class="col-sm-6">
									<input required name="montant_limit" class="form-control"  id="input-montant_limit-id" type="text" placeholder=" Montant limite"> 						
								</div>
							</div>
							<div class="form-group">
								<label for="input-montant_limit-id" class="col-sm-3 control-label"></label>

								<div class="col-sm-6">
									<button  value="ok"  style="color: black;border-color: #95b75d;" type="submit" name="btn_budgetiser" class="btn btn-success form-control">ENREGISTRER <span class="fa fa-floppy-o fa-right"></span></button>
								</div>
							</div>								
						</form>					
					</div>
				</div>
			</div>
			<div class="col-md-6">					
				<div class="panel panel-success{{$cptCompteBudgetisers?' panel-toggled':''}}">
					<div class="panel-heading">
						<h3 class="panel-title"><strong>CREER UNE ANNEE DE PREVISION</strong> </h3>					
						<ul class="panel-controls">
							<li><a href="#" class="panel-collapse"><span class="fa fa-angle-{{$cptCompteBudgetisers?'up':'down'}}"></span></a></li>
						</ul>                                   
					</div>
					<div class="panel-body">
						<form enctype="multipart/form-data" class="form-horizontal" action="{{route('compta.prevision')}}" method="POST">
							{{csrf_field()}}							
							<div class="form-group">
								<label for="input-annee-id" class="col-sm-3 control-label">ANNEE *</label>

								<div class="col-sm-6">
									<input required name="annee" class="form-control"  id="input-annee-id" type="text" placeholder="ANNEE"> 						
								</div>
							</div>
							<div class="form-group">
								<label for="input-date_fin-id" class="col-sm-3 control-label">Dates *</label>

								<div class="col-sm-3">
									<input required style="line-height: normal;" name="date_debut" class="form-control"  id="input-date_debut-id" type="date" placeholder="Date début"> 						
								</div>
								<div class="col-sm-3">
									<input required style="line-height: normal;" name="date_fin" class="form-control"  id="input-date_fin-id" type="date" placeholder="Date fin"> 						
								</div>
							</div>
							<div class="form-group">
								<label for="input-observation-id" class="col-sm-3 control-label">Observation</label>

								<div class="col-sm-6">
									<textarea style="height:30px" name="observation" class="form-control"  id="input-observation-id" type="text" placeholder="Observation"></textarea> 						
								</div>
							</div>
							<div class="form-group">
								<div class="col-sm-6 col-sm-offset-3">
									<button style="color: black;border-color: #95b75d;" value="ok" type="submit" name="btn_prevoir" class="btn btn-success form-control">ENREGISTRER <span class="fa fa-floppy-o fa-right"></span></button>
								</div>
							</div>								
						</form>			
					</div>
				</div>
			</div>
			<ul>
				@foreach($errors->all() as $e)
					<li>{{ $e }}</li>
				@endforeach
			</ul>
	</div>
	
	<div class="row">
		<div class="col-md-12">
			<div class="panel panel-success">
				<div class="panel-heading">
					<form>			
						<div class="form-group">
							<div class="col-sm-12">
								<h3 class="panel-title" style="margin-right:10px">Choisissez une année et visualiser les prévisions budgétaires prévues </h3>
								<select style="width:150px;display:inline" name="cpt_previsions_budgetaire_id" id="input-compte_id-id"  class="form-control">
									<option value="">Choisir</option>
									@foreach($cptPrevisionsBudgetaires as $e)
									<option value="{{$e->id}}">PREVISIONS de {{($e->annee)}}</option>
									@endforeach
								</select>
								<button style="position: relative;top: -2px;" type="submit" class="btn btn-success">Voir les prevision</button>	
							</div>
						</div>
					</form>	                           
				</div>
			</div>
				
			@if($cptCompteBudgetisers)
			<div class="panel panel-default">
				<div class="panel-heading ui-draggable-handle">
					<h3 class="panel-title" stylee="width:100%">PREVISION BUDGETAIRE AU COURS DE <b>L'ANNEE {{$annee}}</b> <span style=""> du <b>{{date('d-M, Y',strtotime($date_debut))}}</b> au <b>{{date('d-M, Y',strtotime($date_fin))}}</b></span></h3>
				
					<ul class="panel-controls">
							<li><a href="#" class="panel-fullscreen"><span class="fa fa-expand"></span></a></li>
						<li><a href="#" class="panel-collapse"><span class="fa fa-angle-down"></span></a></li>
					</ul>                                   
				</div>
				
				<div class="panel-body panel-body-table" style="padding: 10px;"> 
					<table id="datatable-comptes" class="datatable table table-striped table-bordered editable-table">
						<thead>
								<tr>
									<th>N</th>
								<!--th>Imp.</th-->
								<th>Code</th>
								<th>Libellé</th>
								<th>Catégorie</th>
								<th>Mnt. Act.</th>
								<th>Mnt. Prév.</th>
								<th>MARGE</th>
								<th>ANNEE</th>
								<th>(%)</th><th> & Cpte. Principal</th>
								</tr>
						</thead>
						<tbody>
						@php 
							$jsChart = [];
						@endphp
						@foreach($cptCompteBudgetisers as $entree => $grps)
							@php 
								$jsChart[$entree] = $grps->map(function($v,$k){
									return ['label'=>$v['libelle'],'value'=>$v['marge']];
								})->toJson();							
							@endphp
						@foreach($grps as $key => $bdg)
							@php 
								// $compte = $bdg->compte;
							@endphp
							<tr>
								<td>{{$loop->index+1}}</td>
								<td class='editable-tdd' >{{ $bdg['code'] }}</td>
								<td class='editable-tdd' >{{ $bdg['libelle'] }}</td>
								<td class='editable-tdd' >{{ $bdg['categorie'] }}</td>
								<td class='editable-tdd' >{{ chiffre($bdg['limit']) }}</td>
								<td class='editable-tdd' >{{ chiffre($bdg['som']) }}</td>
								<td class='editable-tdd' >{{ chiffre($bdg['marge']) }}</td>
								<td class='editable-tdd' >{{ $bdg['annee']}}</td>
								<td class='editable-tdd' >{{ $bdg['pourcentage'] }}</td>
								<td class='editable-tdd' >{{ $bdg['pcode'].' '.$bdg['plibelle'] }}</td>
							
							</tr>
						@endforeach
						@endforeach
						</tbody>
					</table>
							@php 
								// dd($jsChart );
							@endphp
				</div>
			</div>
			
			
				<!-- START DISCRETE CHART -->
				<div class="panel panel-default">
					<div class="panel-heading">
						<h3 class="panel-title">MARGE PREVISIONNELLE SUR LES ENTREES</h3>
						<ul class="panel-controls">
							<li><a href="#" class="panel-fullscreen"><span class="fa fa-expand"></span></a></li>
						</ul>
					</div>
					<div class="panel-body">
						<div id="chart-entree-4" style="height: 500px;"><svg></svg></div>
					</div>
				</div>
				<div class="panel panel-default">
					<div class="panel-heading">
						<h3 class="panel-title">MARGE PREVISIONNELLE SUR LES SORTIES</h3>
						<ul class="panel-controls">
							<li><a href="#" class="panel-fullscreen"><span class="fa fa-expand"></span></a></li>
						</ul>
					</div>
					<div class="panel-body">
						<div id="chart-sortie-4" style="height: 500px;"><svg></svg></div>
					</div>
				</div>
			@endif
		</div> 
	</div>   
	<script>
		document.getElementById('input-compte_id-id').setAttribute('class','select form-control');
		// document.getElementById('input-imputation-id').parentElement.parentElement.style.display = 'none';
	</script>
	
	
@endsection

@section('script')

        <script type="text/javascript" src="{{asset('compta/js/plugins/datatables/jquery.dataTables.min.js')}}"></script>

		@if(isset($jsChart))
        <script type="text/javascript" src="{{asset('compta/js/plugins/nvd3/lib/d3.v3.js')}}"></script>        
        <script type="text/javascript" src="{{asset('compta/js/plugins/nvd3/nv.d3.min.js')}}"></script>
        <script type="text/javascript" srcc="{{asset('compta/js/demo_charts_nvd3.js')}}">
		var myColors = ["#33414E","#8DCA35","#00BFDD","#FF702A","#DA3610",
                        "#80CDC2","#A6D969","#D9EF8B","#FFFF99","#F7EC37","#F46D43",
                        "#E08215","#D73026","#A12235","#8C510A","#14514B","#4D9220",
                        "#542688", "#4575B4", "#74ACD1", "#B8E1DE", "#FEE0B6","#FDB863",                                                
                        "#C51B7D","#DE77AE","#EDD3F2"];
        d3.scale.myColors = function() {
            return d3.scale.ordinal().range(myColors);
        };
		var startChart4 = function(selector,datas) {
			//	console.log(selector,datas);
			nv.addGraph(dessin(selector,datas));
		};
		function dessin(selector,datas) {
			console.log(selector,datas);
			var chart = nv.models.discreteBarChart()
			.x(function(d) { return d.label; })//Specify the data accessors.
			.y(function(d) { return d.value; })
			.staggerLabels(true)//Too many bars and not enough room? Try staggering labels.
			.tooltips(false)//Don't show tooltips
			.showValues(true)//...instead, show the bar value right on top of each bar.
			.transitionDuration(350)
			.color(d3.scale.myColors().range());

			d3.select(selector).datum(datas).call(chart);
			nv.utils.windowResize(chart.update);
			return chart;
		}
		var data_sortie = [{ key : "Marge", values:{!!$jsChart[0]??'[]'!!} }];
		var data_entree = [{ key : "Marge", values:{!!$jsChart[1]??'[]'!!} }];
		startChart4('#chart-entree-4 svg',data_entree);
		startChart4('#chart-sortie-4 svg',data_sortie);
	</script>
		@endif
@endsection
				