<!DOCTYPE html>
<html lang="en">
    <head>        
        <!-- META SECTION -->
        <title>Salama Finance</title>            
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        
        <link rel="icon" href="favicon.ico" type="image/x-icon" />
        <!-- END META SECTION -->
        
        <!-- CSS INCLUDE -->        
        <link rel="stylesheet" type="text/css" id="theme" href="{{asset('compta/css/theme-default.css')}}"/>
        <!-- EOF CSS INCLUDE -->  
		<style>
		.ts-button{display:none}
		@media print {
			 .no-print,
			 .main-sidebar,
			 .left-side,
			 .main-header,
			 .content-header,
			.page-sidebar, .x-navigation
			{
			  display:none !important
			 		
			}
			.page-content{margin:0 !important;}
		}
		
		</style>
    </head>
    <body>
        <!-- START PAGE CONTAINER -->
        <div class="page-container">
            
            <!-- START PAGE SIDEBAR -->
            <div class="page-sidebar">
                <!-- START X-NAVIGATION -->
                <ul class="x-navigation">
                    <li class="xn-logo">
                        <a href="">Oeuvre Salama</a>
                        <a href="#" class="x-navigation-control"></a>
                    </li>
                    <!--li class="xn-profile">
                        <a href="#" class="profile-mini">
                            <img src="{{asset('compta/assets/images/users/avatar.jpg')}}" alt="John Doe"/>
                        </a>
                        <div class="profile">
                            <div class="profile-image">
                                <img src="{{asset('compta/assets/images/users/avatar.jpg')}}" alt="John Doe"/>
                            </div>
                            <div class="profile-data">
                                <div class="profile-data-name">John Doe</div>
                                <div class="profile-data-title">Web Developer/Designer</div>
                            </div>
                            <div class="profile-controls">
                                <a href="pages-profile.html" class="profile-control-left"><span class="fa fa-info"></span></a>
                                <a href="pages-messages.html" class="profile-control-right"><span class="fa fa-envelope"></span></a>
                            </div>
                        </div-->                                                                        
                    </li>
					
                    <li class="xn-title">Navigation</li>
                    <li class="{{ url()->current()==route('compta.index')?'active':'' }}">
                        <a href="{{route('compta.index')}}"><span class="fa fa-random"></span> <span class="xn-text">Entrees & Sorties</span></a>                        
                    </li>                    
                    
					@php 
					$rc = route('compta.entre.sortie');
					$rj = route("compta.rapport.journalier");
					$rm = route("compta.rapport.mensuel");
					$rg = route("compta.rapport.global");
					$ac = in_array(url()->current(),array($rj,$rm,$rg,$rc));
					@endphp
                    <li class="xn-openable {{$ac?'active':''}}" >
                        <a href="index.html"><span class="fa fa-bar-chart-o"></span> <span class="xn-text">Rapport</span></a>                        
                        <ul>
							<li class="{{ url()->current()==$rc?'active':'' }}"><a href="{{$rc}}"><span class="fa fa-desktop"></span> <span class="xn-text">Comptabilité</span></a></li>     
							<li class="{{ url()->current()==$rj?'active':'' }}"><a href="{{$rj}}?compta=ok"><span class="fa fa-square-o"></span> Journalier</a></li>                            
                            <li class="{{ url()->current()==$rm?'active':'' }}"><a href="{{$rm}}?compta=ok"><span class="fa fa-list-ul"></span> Mensuel</a></li>
                            <li class="{{ url()->current()==$rg?'active':'' }}"><a href="{{$rg}}?compta=ok"><span class="fa fa-th"></span> Global</a></li>    
                        </ul>
                    </li>  					
                    <li class="{{ url()->current()==route('compta.prevision')?'active':'' }}">                    
                        <a href="{{route('compta.prevision')}}"><span class="fa fa-pencil"></span> <span class="xn-text">Prevision Budjetaire</span></a>                        
                    </li>                    
                    <li class="{{ url()->current()==route('compta.codification')?'active':'' }}">                    
                        <a href="{{route('compta.codification')}}"><span class="fa fa-cogs"></span> <span class="xn-text">Codification</span></a>                        
                    </li>                    
                    <li>   
						<a href="#x" onclick="document.getElementById('form-logout').submit()" for='btn-logout'><span class="fa fa-sign-out"></span>
						<span class="xn-text">Se Deconnecter</span></a> 
						<form action="{{route('compta.logout')}}" id='form-logout' method="post">
							@csrf
							<button  style='display:none' type="submit"  class="btn btn-default btn-flat">Déconnecter</button>
						</form>                       
                    </li>                    
                    
                </ul>
                <!-- END X-NAVIGATION -->
            </div>
            <!-- END PAGE SIDEBAR -->
            
			               
            
            <!-- PAGE CONTENT -->
            <div class="page-content">
                
                <!-- START X-NAVIGATION VERTICAL -->
                <ul class="x-navigation x-navigation-horizontal x-navigation-panel">
                    <!-- TOGGLE NAVIGATION -->
                    <li class="xn-icon-button">
                        <a href="#" class="x-navigation-minimize"><span class="fa fa-dedent"></span></a>
                    </li>
                    <!-- END TOGGLE NAVIGATION -->
                    <!-- SEARCH --
                    <li class="xn-search">
                        <form role="form">
                            <input type="text" name="search" placeholder="Search..."/>
                        </form>
                    </li>   
                    <!-- END SEARCH -->
                    <!-- SIGN OUT -->
                    <li class="xn-icon-button pull-right">
                        <a href="#" class="mb-control" data-box="#mb-signout"><span class="fa fa-sign-out"></span></a>                        
                    </li> 
                    <!-- END SIGN OUT -->
                    <!-- MESSAGES --
                    <li class="xn-icon-button pull-right">
                        <a href="#"><span class="fa fa-comments"></span></a>
                        <div class="informer informer-danger">4</div>
                        <div class="panel panel-primary animated zoomIn xn-drop-left xn-panel-dragging">
                            <div class="panel-heading">
                                <h3 class="panel-title"><span class="fa fa-comments"></span> Messages</h3>                                
                                <div class="pull-right">
                                    <span class="label label-danger">4 new</span>
                                </div>
                            </div>
                            <div class="panel-body list-group list-group-contacts scroll" style="height: 200px;">
                                <a href="#" class="list-group-item">
                                    <div class="list-group-status status-online"></div>
                                    <img src="{{asset('compta/assets/images/users/user2.jpg')}}" class="pull-left" alt="John Doe"/>
                                    <span class="contacts-title">John Doe</span>
                                    <p>Praesent placerat tellus id augue condimentum</p>
                                </a>
                                <a href="#" class="list-group-item">
                                    <div class="list-group-status status-away"></div>
                                    <img src="{{asset('compta/assets/images/users/user.jpg')}}" class="pull-left" alt="Dmitry Ivaniuk"/>
                                    <span class="contacts-title">Dmitry Ivaniuk</span>
                                    <p>Donec risus sapien, sagittis et magna quis</p>
                                </a>
                                <a href="#" class="list-group-item">
                                    <div class="list-group-status status-away"></div>
                                    <img src="{{asset('compta/assets/images/users/user3.jpg')}}" class="pull-left" alt="Nadia Ali"/>
                                    <span class="contacts-title">Nadia Ali</span>
                                    <p>Mauris vel eros ut nunc rhoncus cursus sed</p>
                                </a>
                                <a href="#" class="list-group-item">
                                    <div class="list-group-status status-offline"></div>
                                    <img src="{{asset('compta/assets/images/users/user6.jpg')}}" class="pull-left" alt="Darth Vader"/>
                                    <span class="contacts-title">Darth Vader</span>
                                    <p>I want my money back!</p>
                                </a>
                            </div>     
                            <div class="panel-footer text-center">
                                <a href="pages-messages.html">Show all messages</a>
                            </div>                            
                        </div>                        
                    </li>
                    <!-- END MESSAGES -->
                    <!-- TASKS --
                    <li class="xn-icon-button pull-right">
                        <a href="#"><span class="fa fa-tasks"></span></a>
                        <div class="informer informer-warning">3</div>
                        <div class="panel panel-primary animated zoomIn xn-drop-left xn-panel-dragging">
                            <div class="panel-heading">
                                <h3 class="panel-title"><span class="fa fa-tasks"></span> Tasks</h3>                                
                                <div class="pull-right">
                                    <span class="label label-warning">3 active</span>
                                </div>
                            </div>
                            <div class="panel-body list-group scroll" style="height: 200px;">                                
                                <a class="list-group-item" href="#">
                                    <strong>Phasellus augue arcu, elementum</strong>
                                    <div class="progress progress-small progress-striped active">
                                        <div class="progress-bar progress-bar-danger" role="progressbar" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100" style="width: 50%;">50%</div>
                                    </div>
                                    <small class="text-muted">John Doe, 25 Sep 2014 / 50%</small>
                                </a>
                                <a class="list-group-item" href="#">
                                    <strong>Aenean ac cursus</strong>
                                    <div class="progress progress-small progress-striped active">
                                        <div class="progress-bar progress-bar-warning" role="progressbar" aria-valuenow="80" aria-valuemin="0" aria-valuemax="100" style="width: 80%;">80%</div>
                                    </div>
                                    <small class="text-muted">Dmitry Ivaniuk, 24 Sep 2014 / 80%</small>
                                </a>
                                <a class="list-group-item" href="#">
                                    <strong>Lorem ipsum dolor</strong>
                                    <div class="progress progress-small progress-striped active">
                                        <div class="progress-bar progress-bar-success" role="progressbar" aria-valuenow="95" aria-valuemin="0" aria-valuemax="100" style="width: 95%;">95%</div>
                                    </div>
                                    <small class="text-muted">John Doe, 23 Sep 2014 / 95%</small>
                                </a>
                                <a class="list-group-item" href="#">
                                    <strong>Cras suscipit ac quam at tincidunt.</strong>
                                    <div class="progress progress-small">
                                        <div class="progress-bar" role="progressbar" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100" style="width: 100%;">100%</div>
                                    </div>
                                    <small class="text-muted">John Doe, 21 Sep 2014 /</small><small class="text-success"> Done</small>
                                </a>                                
                            </div>     
                            <div class="panel-footer text-center">
                                <a href="pages-tasks.html">Show all tasks</a>
                            </div>                            
                        </div>                        
                    </li>
                    <!-- END TASKS -->
                </ul>
                <!-- END X-NAVIGATION VERTICAL -->                     

                <!-- START BREADCRUMB --
                <ul class="breadcrumb">
                    <li><a href="#">Home</a></li>                    
                    <li class="active">Dashboard</li>
                </ul>
                <!-- END BREADCRUMB -->                       
                
				 <!-- PAGE TITLE -->
                
				@yield('title')
                <!-- END PAGE TITLE --> 
				
                <!-- PAGE CONTENT WRAPPER -->
                <div class="page-content-wrap">
                    @yield('page')
                    
                    
                </div>
                <!-- END PAGE CONTENT WRAPPER -->                                
            </div>            
            <!-- END PAGE CONTENT -->
        </div>
        <!-- END PAGE CONTAINER -->

        <!-- MESSAGE BOX-->
        <div class="message-box animated fadeIn" data-sound="alert" id="mb-signout">
            <div class="mb-container">
                <div class="mb-middle">
                    <div class="mb-title"><span class="fa fa-sign-out"></span> Log <strong>Out</strong> ?</div>
                    <div class="mb-content">
                        <p>Are you sure you want to log out?</p>                    
                        <p>Press No if youwant to continue work. Press Yes to logout current user.</p>
                    </div>
                    <div class="mb-footer">
                        <div class="pull-right">
                            <a href="pages-login.html" class="btn btn-success btn-lg">Yes</a>
                            <button class="btn btn-default btn-lg mb-control-close">No</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- END MESSAGE BOX-->

        <!-- START PRELOADS -->
        <audio id="audio-alert" src="{{asset('compta/audio/alert.mp3')}}" preload="auto"></audio>
        <audio id="audio-fail" src="{{asset('compta/audio/fail.mp3')}}" preload="auto"></audio>
        <!-- END PRELOADS -->                  
        
    <!-- START SCRIPTS -->
        <!-- START PLUGINS -->
        <script type="text/javascript" src="{{asset('compta/js/plugins/jquery/jquery.min.js')}}"></script>
        <script type="text/javascript" src="{{asset('compta/js/plugins/jquery/jquery-ui.min.js')}}"></script>
        <script type="text/javascript" src="{{asset('compta/js/plugins/bootstrap/bootstrap.min.js')}}"></script>        
        <!-- END PLUGINS -->

        <script type="text/javascript" src="{{asset('compta/js/plugins/bootstrap/bootstrap-datepicker.js')}}"></script>
        <!-- START THIS PAGE PLUGINS-->        
        <script type='text/javascript'  src="{{asset('compta/js/plugins/icheck/icheck.min.js')}}"></script>        
        <script type="text/javascript" src="{{asset('compta/js/plugins/mcustomscrollbar/jquery.mCustomScrollbar.min.js')}}"></script>
        <script type="text/javascript" src="{{asset('compta/js/plugins/scrolltotop/scrolltopcontrol.js')}}"></script>
        
        <script type="text/javascript" src="{{asset('compta/js/plugins/morris/raphael-min.js')}}"></script>
        <script type="text/javascript" src="{{asset('compta/js/plugins/morris/morris.min.js')}}"></script>       
        <script type="text/javascript" src="{{asset('compta/js/plugins/rickshaw/d3.v3.js')}}"></script>
        <script type="text/javascript" src="{{asset('compta/js/plugins/rickshaw/rickshaw.min.js')}}"></script>
        <script type='text/javascript' src="{{asset('compta/js/plugins/jvectormap/jquery-jvectormap-1.2.2.min.js')}}"></script>
        <script type='text/javascript' src="{{asset('compta/js/plugins/jvectormap/jquery-jvectormap-world-mill-en.js')}}"></script>                
        <script type='text/javascript' src="{{asset('compta/js/plugins/bootstrap/bootstrap-datepicker.js')}}"></script>  
		
        <script type="text/javascript" src="{{asset('compta/js/plugins/bootstrap/bootstrap-select.js')}}"></script>              
        <script type="text/javascript" src="{{asset('compta/js/plugins/owl/owl.carousel.min.js')}}"></script>                 
        
        <script type="text/javascript" src="{{asset('compta/js/plugins/moment.min.js')}}"></script>
        <script type="text/javascript" src="{{asset('compta/js/plugins/daterangepicker/daterangepicker.js')}}"></script>
        <!-- END THIS PAGE PLUGINS-->        
       
	@yield('script')
	
        <!-- START TEMPLATE -->
        <script type="text/javascript" src="{{asset('compta/js/settings.js')}}"></script>
        
        <script type="text/javascript" src="{{asset('compta/js/plugins.js')}}"></script>        
        <script type="text/javascript" src="{{asset('compta/js/actions.js')}}"></script>
        
        <script type="text/javascript" src="{{asset('compta/js/demo_dashboard.js')}}"></script>
        <!-- END TEMPLATE -->
    <!-- END SCRIPTS -->  
    </body>
</html>






