@extends('os.index')

@section('page')
	<style>
	table tbody tr.bg-aqua {
		background-color: #00c0ef !important;
		color:#fff
	}
	table tbody tr.bg-red {
		background-color: #dd4b39 !important;
		color:#fff
	}
	.table.bg-green {
		background-color: #00a65a !important;
		color:#fff
	}
	
.info-box {
    display: block;
    min-height: 90px;
    background: #ecf0f5;
    width: 100%;
    box-shadow: 2px 2px 2px rgba(0,0,0,0.5);
    border-radius: 2px;
    margin-bottom: 15px;
}
.table-striped > tbody > tr:nth-of-type(2n+1) {
    background-color: #ffeaea;
}
.table-striped > tbody > tr:nth-of-type(2n+0) {
    background-color: #d8f0f7;
}
th{text-align:center}
th.devise{text-align:right}
.montant{font-weight:bold;text-align:right;}

#content-list, .content {
    padding: 0;
}
.detail-mouvement{display:none}

.detail-mouvement table{	
	border: solid 1px black !important;
	background: #dbddda3d;
	border-top: solid 3px black !important;
}
	</style>
	<div class="col-sm-3 " style="padding-left: 0;">
		<form enctype="multipart/form-data" class="form-horizontal" action="{{route('cash.user.compte')}}" method="POST">
		{{csrf_field()}}
					
			<div class="panel panel-danger">
				<div class="panel-heading ui-draggable-handle">
					<h3 class="panel-title">ATTRIBUTION DES COMPTES</h3>
				</div>
				<div class="panel-body">
					
					<div class="form-group">
							
							<label style="margin-left: 15px;" for="input-user_id-id" class=" control-label">Choisir Utilisateur</label>

							<div class="col-sm-12">
								<select name="user_id[]" width="100%" id="input-user_id-id" required multiple class="form-control select"  data-live-search="true">
									@foreach($users as $e)
									<option value="{{$e->id}}">{{($e->name??'')}}</option>
									@endforeach
								</select>
							</div>
						</div>
						<div class="form-group">
							<label style="margin-left: 15px;" for="input-compte_id-id" class=" control-label">Choisir Compte</label>
							
							<div class="col-sm-12">
						<input type="checkbox" title="Selectionner tous les comptes" id="tout-selectionner">
								<select name="compte_id[]" required id="input-compte_id-id" multiple class="form-control select"  data-live-search="true">
									@foreach($comptes as $e)
									<option value="{{$e->id}}">{{($e->compte?"Sous compte ":"").($e->code??'').' '.($e->libelle??'').($e->compte?(" Princ :".$e->compte->libelle):"") }}</option>
									@endforeach
								</select>
							</div>
						</div>
						
						<div class="form-group">
							
							<div class="col-sm-9">
								
							</div>
						</div>

				</div>     
				<div class="panel-footer">
					<button type="submit" class="btn btn-success pull-right">ASSOCIER</button>
				</div>                            
			</div>	
		</form>
	</div>	
	
	<div class="col-sm-9 " style="padding-left: 0;">
		<div class="panel panel-danger">
			<div class="panel-heading ui-draggable-handle">
				<h3 class="panel-title" style="padding-right: 10px;">ENTREES & SORITES DES COMPTES DU GROUPE </h3>
				<select name="" id="liste-mes-compte" class="select"  data-live-search="true">
				@php 
				// $grp = $mes_comptes->groupBy(function($v,$k){ return $v->compte->code??'' ;});
				@endphp
					<option value="">Choisir un compte</option>
					@foreach($mes_comptes as $cpt)
						<option value="{{$cpt->compte->id}}">{{$cpt->compte->libelle}} </option>
					@endforeach
					
				</select>
				<label for="detail-mouvement"><input id="detail-mouvement" type="checkbox" class="iicheckbox"/> Voir les détails</label>
			</div>
			<div class="panel-body">
				<!--p style="text-align:left;margin-top:20px"> 
					<i>Choisissez un compte et visualiser les mouvements des entrees et des sorties</i>
				</p-->
				<div class="box-body" id="detail-livre-compte"></div>
			</div>     
			<div class="panel-footer">
			</div>                            
		</div>	
		
	</div>
	
		
	
@endsection

@section('script')
	
	<script> 
	$(function(){
		$("#voir-form").click(function(){
			//$('.select').select({placeholder: "rechercher un element dans la liste", allowClear: true});
		})
		$('.select').select({placeholder: "rechercher un element dans la liste", allowClear: true});
		$('.select').val("").change();
		
		$('.select.select-container.select-container--default').css({'width':'100%'});

		$("#tout-selectionner").click(function(){
			if($("#tout-selectionner").is(':checked') ){
				console.log("chado");
				$(".select#input-compte_id-id > option").prop("selected","selected");// Select All Options
				$(".select#input-compte_id-id").trigger("change");// Trigger change to select 2
			}else{
				console.log("chado");
				$(".select#input-compte_id-id > option").removeAttr("selected");
				$(".select#input-compte_id-id").trigger("change");// Trigger change to select 2
				$('.select#input-compte_id-id').val("").change();
			}
		});
		
		$("#detail-mouvement").click(function(){
			if($("#detail-mouvement").is(':checked') ){
				$(".detail-mouvement").show(500);
			}else{
				$(".detail-mouvement").hide(500);
			}
		});

		$("#liste-mes-compte").change(function(){
			if($(this).val())voir_livre_compte($(this).val())
			
		});
		
		function voir_livre_compte(code){
			var url = "{{route('cash.compte.individuel')}}?code="+code;
			$.get(url,function(html){
				// if($("#div-detail-"+id).is('div'))
				$("#detail-livre-compte").append(html);
			})
		}

		$("#detail-livre-compte").on('click','.remove-detail',function(){
			$(this).parent().parent().parent().parent().slideUp("slow");
		})
		
		$("#detail-livre-compte").on('click','.voir-tr-detail-mois',function(){
			if($(this).attr('show')=='ok'){
				$(this).parent().parent().parent().children('.tr-detail-mois').show("slow");
				$(this).attr('show','no');
				$(this).text('CACHER LES DETAILS');
			}
			else {				
				$(this).parent().parent().parent().children('.tr-detail-mois').hide("slow");
				$(this).attr('show','ok');
				$(this).text('VOIR LES DETAILS');
			}
		})
	})
	</script> 
@endsection		
				