@extends("template")

@section('autre-menu-list')
	@include('mes_vues.Scholar._autre_menu')
@endsection

@section('style')
	<style>
	.select2-container--default .select2-selection--single {
		min-height: 34px;
	}
	</style>
@endsection
@section('content')
<div class="col-md-12 col-md-offset-0">

	<form enctype="multipart/form-data"  class="form-horizontal no-print"  method="get" action="{{route('scholar.eleves.status')}}" >
		<div class=" col-sm-12" style="margin-bottom: 20px;">
		
			<div class="col-sm-3" style="padding-left: 0px;">
				<select name="status" id="input-ms_classe_id-id" class="form-control select2" style="width: 100%">
					<option value="all">Choisir un status</option>
					@foreach($enfantStatus as $e)
						<option value="{{$e->id}}">{{$e->status}}</option>
					@endforeach
				</select>
				
			</div>
			<div class="col-sm-2" style="">
				<button type="submit" class="btn btn-info ">Voir Elèves</button>
			</div>
		</div>
	</form>
	
	<div class="col-sm-12" >
		<div class="box no-border" style="padding: 0 10px;">
			<div class="box-header no-print">
				<h3 class="box-title">Liste des élèves de la categorie :
					<b>{{$status?($status->status):''}}</b>
					Année Scolaire <b>{{ \App\Config::getAnnee()}}</b>
				</h3>
				<div class="box-tools">                
				@include('partials.btn_group_export',['jsSelector'=>"#table_liste_eleve",'app'=>'Scholar'])						
				</div>
			</div>
			<div class="box-header my_title" style="text-align: center;display:none">
				<h3 class="box-title" style="width:100%;text-align:left">
				
					<img style="" src="{{ \App\Config::getLogo()?asset('storage/ecole/logo_ecole/'.\App\Config::getLogo())
									:asset('img/logo.png') }}" alt="logo"/>
				
					<span>ECOLE </span>: <b>{{\App\Config::getEcole()}}</b><br/>
					<span>Status </span>: <b>{{$status->status??''}}</b> <br/>
					<span>ANNEE SCOLAIRE </span>: <b>{{\App\Config::getAnnee()}}</b>
					
					<div style="position: relative;"> <div style="position: absolute;width:100%;border:solid 24px #3c8dbc6b;height:0px !important;">&nbsp;</div> <p> LISTE DES ELEVES </p></div>	
				</h3>
				
			</div>
			<!-- /.box-header -->
			<div class="box-body no-padding" id="table_liste_eleve">
				<table id="datatable-mseleves" class="table editable-table table-striped table-bordered table-condensed">
					
					<thead>
							<tr>
								
								<th>Num</th>
								<th>Matricule</th>
								<th>Nom</th>
								<th>Postom</th>
								<th>Preom</th>
								<th>Genre</th>
							</tr>
					</thead>
					<tbody>
						@foreach($msEleves as $key => $mseleve)
							<tr>								
								<td>{{$loop->index+1}}</td>
								<td>{{$mseleve->enfant->matricule}}</td>
								<td>{{ $mseleve->enfant->nom}}</td>
								<td>{{ $mseleve->enfant->postnom}}</td>
								<td>{{ $mseleve->enfant->prenom}}</td>
								<td>{{ $mseleve->enfant->genre }}</td>
							</tr>
						@endforeach
					</tbody>
				</table>
			</div>
			<div class="overlay hide form-overlay">
				<i class="fa fa-refresh fa-spin"></i>
			</div>
		</div>
	</div>
	
	
	</div>
@endsection
		
@section('script')
	@include("partials.export_js_files")
	
	<script>
	var TAB = [],INDICE=0;
		var ID = 0;
	$(function () {
		//Initialize Select2 Elements

		
	})
	</script>
@endsection



