@extends('mes_vues._dossier_eleve')
@section('titre')
	Dossier Scolaire
@endsection	

@section('action_dossier'){{route('scholar.dossier')}}@endsection	

@section('dossier')

		@php $genre = $msEleve->enfant->genre; @endphp

		@if(isset($eleve))
		<style>
			
			.main-header,.main-footer {
				display: none;
			}

		</style>
		@endif
		<script>
			function bulletin_eleve(url){
				window.open(url,'Bulletin Scolaire'
				,'width=1600px','height=900px'
				,'innerHeight=800px','innerWidth=1200px'
				);
			}
		</script>
		<div class="box" style="min-height: 400px;position:relative">
			<div class="box-body">
			
				<div class="col-lg-12 col-xs-12" style="padding: 0;">
				  <!-- small box -->
				  <div class="small-box bg-aqua">
					<div class="inner">
					  <h3 style="font-size: 18px;">
										{{$msEleve->enfant->matricule.' '.$msEleve->enfant->nom.' '.$msEleve->enfant->postnom.' '.$msEleve->enfant->prenom}}
									</h3>

					  <p>Dossier Scholar de l'élève</p>
					</div>
					<div class="icon">
										<!--fa  fa-check-circle-->
					  <i class="fa fa-fw fa-calendar-check-o" style="font-size: 70px;position: relative;top: -20px;"></i>
					</div>
					<a href="#" class="small-box-footer">Merci M-Scholar<i class="fa fa-thumbs-o-up"></i></a>
				  </div>
				</div>
				
				<table id="datatable-msinscriptions" class="table table-striped table-bordered editable-table">
					<thead>
							<tr>
								
								<th>N°</th>
								<th>Classe</th>
								<th>Inscrit{{ $genre=='M'?'':'e' }} le</th>
								<th>Status</th>
								<th>Etat</th>
								<th>Année-Sco.</th>
							</tr>
					</thead>
					<tbody>
					
					@foreach($msEleves as $key => $msEleve)
							<tr>
								<td rowspan="2">{{ $loop->index+1 }}</td>
								<td>{{ $msEleve->msClasse->classe }} {{ $msEleve->msClasse->msPromotion->section->nom_sec }}</td>
								<td>{{ $msEleve->inscrit_le }}</td>
								<td class='editable-td' k='{{$msEleve->id}}' f='status_enfant_id' i='8' t='select' s='StatusEnfant'>{{ $msEleve->statusEnfant->status??'' }}</td>
								<td class='editable-td' k='{{$msEleve->id}}' f='etat' i='8' t='text'>{{ $msEleve->etat }}</td>
								<td>{{ $msEleve->msClasse->msPromotion->msAnneeScolaire->annee }}</td>
							</tr>
							<tr>
								<td colspan="3"><b>Tuteur/Tutrice:</b> {{ $msEleve->msinscription->tuteur->nom_tuteur??''}} {{$msEleve->msinscription->tuteur->telephone ??''}}</td>
								<td>
								<a onclick="bulletin_eleve('{{route('report.grand',['id_eleve'=>$msEleve->id])}}')" href="#" class="btn btn-block btn-success btn-xs btn-flat">Bulletin</a>
								</td>
							</tr>
					@endforeach
					</tbody>
				</table>
				
					
			</div>
			<div class="box-footer clearfix" style="position: absolute;bottom: 0px;width: 100%;">
				<p style='text-align:center'>MASOMWETU votre partenaire scolaire <i>Merci M-Scholar</i><br/>
				<a href="{{route('scholar.eleve.auth')}}">Changer de compte </a>
				</p>
			</div>
		</div>
	
@endsection	

