@extends('template')

@section('style')
	<link href="{{asset('css/select2.min.css')}}" rel="stylesheet">
	
@endsection
@section('content')


<div class="row">
	<div class="col-xs-12 col-xs-offset-0" style="margin-right:3%;margin-left:3%;width: 94%;">
		<form action="" method="get">
				<select name="id" id="input-ms_classe_id-id"  class="select2">
					<option value="">Choisir</option>
					@foreach($msclasses as $e)
					<option value="{{$e->id}}">{{($e->classe??'').' '.($e->msPromotion->promotion??'').' '.($e->msPromotion->section->nom_sec??'')}}</option>
					@endforeach
				</select>
				<input type="submit" value="Charger">
			
		</form>
		<hr style="border: solid 1px #000001;margin: 10px 0 20px 0;">
        
		
		@if(($classes) and count($classes))
			<div class="box">
				<div class="box-header">
					<h3 style="margin: 0;">REGISTRE DES PAIEMENTS DE : {{($classe->classe??'').' '.($classe->msPromotion->promotion??'')
					.' '.($classe->msPromotion->section->nom_sec??'')}}</h3>
				
				</div>
				<!-- /.box-header -->
				@php 
				$totaux = []; 
				$msEleves = $classe->msEleves->sortBy(function($e){
					return $e->enfant->nom.' '.$e->enfant->postnom.' '.$e->enfant->prenom ;
				});
				@endphp
				<div class="box-body table-responsive">            
					<table id="table-rapport-paiement" class="table table-striped table-bordered table-hover table-condensed">
						<thead>
							<tr>
								<th style="width: 20px;">N°</th>
								<th style="widthf: 100px;">Elève</th>
								@foreach($classe->mpFraisClasses as $f)
									<th>{{$f->mpFrais->frais}} / {{ chiffre($f->montant) }} </th>
									@php $totaux[$f->id] = ['y'=>0,'n'=>0]; @endphp
								@endforeach
						</thead>
						<tbody>
							@foreach($msEleves as $e)
							<tr>
								<th>{{$loop->index+1}}</th>
								<td>{{$e->enfant->nom.' '.$e->enfant->postnom.' '.$e->enfant->prenom.' '.$e->enfant->genre}}</td>
								@foreach($classe->mpFraisClasses as $f)
									@php 
										$m = $e->mpFraisPaiements->where('mp_frais_classe_id',$f->id)->sum('montant_payer');
										$totaux[$f->id][$m==$f->montant?'y':'n'] += 1; 
									@endphp
									<th style="background: {{$m==0?'#dc271e1f':''}};" >{{$m}}</th>
								@endforeach
							</tr>
							@endforeach	
							<tr>
								<th></th>
								<td>Statistiques</td>
								@foreach($classe->mpFraisClasses as $f)									
									<th>
									<div class="btn-group">
										<button type="button" class="btn btn-success btn-xs">{{$totaux[$f->id]['y']}} <i class="fa fa-check"></i></button>
										<button type="button" class="btn btn-danger btn-xs">{{$totaux[$f->id]['n']}} <i class="fa fa-close"></i></button>
										<!--button type="button" class="btn btn-default"><i class="fa fa-align-right"></i></button-->
									</div>
										
									</th>
								@endforeach
							</tr>					
						</tbody>
					</table>
				</div>
				<!-- /.box-body -->
			</div>
			<!-- /.box -->
		@else
			<div class="callout callout-danger">
				<h4><i class=" icon fa fa-ban"></i> Indiquez une classe SVP!</h4>

				<p>En indiquant une classe on vous affiche le registre de paie pour toute la classe</p>
			</div>
		@endif
					
    </div>
</div>
				
@endsection

@section('script')
	<!--script src="{{asset('js/select2.full.min.js')}}"></script-->
	<script src="{{asset('js/select2.full.js')}}"></script>
	$(function () {	
			// $('.select2').select2()
	});
@endsection