@extends('template')

@section('style')
	<link href="{{asset('css/select2.min.css')}}" rel="stylesheet">
	<style>
	table tbody tr.en-ordre td{
		
	}
	.box {
		break-after: always;
		break-inside: auto;
	}
	tr.bg-aqua{
		background-color: #00c0ef25 !important;
		color: #000 !important;
	}
	tr.bg-red{
		background-color: #dd4b3925 !important;
		color: #000 !important;
	}
	tr.bg-red td, tr.bg-aqua td,tr.bg-red th, tr.bg-aqua th{
		border: solid black 1px !important;
	}
	#content-list {
	padding: 0;
	}
	tbody tr td ,tfoot tr th {
	text-align: right;
	}
	</style>
@endsection
@section('content')

    @php
       setlocale(LC_MONETARY,"en_US.UTF-8");
    @endphp
	<div class="row">
		<div class="col-xs-12 col-xs-offset-0" style="padding-left: 0;">
		<div class="box">
			<div class="box-header no-print">			
				<form action="">
					<div class="col-md-10">
						<select name="mp_frais_id[]" id="input-ms_classe_id-id" multiple  class="select2">
							<option value="">Choisir</option>
							@if($mpFraiss)
							@foreach($mpFraiss as $e)
							<option value="{{$e->id}}">{{($e->frais??'')}}</option>
							@endforeach
							@endif
						</select>
					</div>
					
					<div class="col-md-2">
						<select name="monnaie" id="">
                          <option value="cdf">CDF</option>
                          <option value="usd">USD</option>
                          <option value="">-</option></select>
						<input type="submit" value="AFFICHER">
					</div>
				</form>
			</div>
			<div class="box-body table-responsive">
			    <style>
			    .table-bordered > thead > tr > th, .table-bordered > tbody > tr > th, .table-bordered > tfoot > tr > th, .table-bordered > thead > tr > td, .table-bordered > tbody > tr > td, .table-bordered > tfoot > tr > td {
                  border: 1px solid #f4f4f4;
                  vertical-align: middle;
                }
                .col-usd{
                    display:none !important;
                }
                </style>
			@if(count($tab))
			    <h2  style="text-align:center"><b>{{\App\Config::getEcole()}}  </b>
			        <br/>
			        RAPPORT MENSUEL DES ENTREES (Minerval)</h2>
			        <hr/>
			        <p style="font-size:18px;padding: 0 30px;font-style: italic;text-align: justify;margin-bottom: 25px;">
			        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Ce rapport vous présente sur chaque période d'un MOIS, les entrées en rapport avec les différents frais, effectuées du 
			        <u><b>début de l'année</b></u> jusqu'au moment de l'extraction de ce rapport du SYSTEME, soit le <u><b>{{date("d/m/Y, H:i:s")}}</b></u>.
			        <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Dans sa deuxième colonne vous avez la période (mois/année) et dans sa dernière colonne vous avez le total du MOIS
			        </p>
			    <table class="table table-hover table-bordered table-condensed" style="font-size: 17px;border: solid 2px;break-after: always;">
			        <thead>
			        <tr style="text-align:center"><th>N</th><th>MOIS</th><th>FRAIS</th><th class="col-usd">MONTANT USD</th><th>MONTANT CDF</th><th class="col-usd">TOT USD</th><th>TOT CDF</th></tr>
			        </thead>
			        <tbody>
			        @foreach($tab_entree_mensuelle as $ann_mois=>$tab_en_mois)
    			        <tr style="border-top: solid 2px;">
    			            <td rowspan="{{$tab_en_mois->count()}}">{{$loop->index+1}}</td>
        			        <td rowspan="{{$tab_en_mois->count()}}" style="border-right: solid;">{{strtoupper($tab_en_mois->first()->mois)}} / {{$tab_en_mois->first()->annee}}</td>
        			        <td style="border-bottom: dotted 2px;">{{$tab_en_mois->first()->frais}}</td>
        			        <td class="col-usd" style="border-bottom: dotted 2px;">{{$tab_en_mois->first()->usd}}</td>
        			        <td style="border-bottom: dotted 2px;">{{substr(money_format("%.0n",$tab_en_mois->first()->cdf),1)}}</td>
        			        <td class="col-usd" rowspan="{{$tab_en_mois->count()}}" style="border-left: solid;background: #dfdfdf;"><b>{{$tab_en_mois->sum('usd')}}</b></td>
        			        <td rowspan="{{$tab_en_mois->count()}}" style="background: #dfdfdf;"><b>{{substr(money_format("%.0n",$tab_en_mois->sum('cdf')),1)}}</b></td>
    			        </tr>
    			        @foreach($tab_en_mois as $lg)
    			        @if($loop->index!=0)
    			        <tr>
        			        <td style="border-bottom: dotted 2px;">{{$lg->frais}}</td>
        			        <td class="col-usd" style="border-bottom: dotted 2px;">{{$lg->usd}}</td>
        			        <td style="border-bottom: dotted 2px;">{{substr(money_format("%.0n",$lg->cdf),1)}}</td>
    			        </tr>
    			        @endif
    			        @endforeach
			        @endforeach
			        </tbody>
			    </table>
				@if($monnaie=='usd')
					@include("mes_vues.Payment._rapport_des_entree_usd")
				@elseif($monnaie=='cdf')
					@include("mes_vues.Payment._rapport_des_entree_cdf")
				@else
					@include("mes_vues.Payment._rapport_des_entree")
				@endif
			@endif
			</div>
		</div>
		</div>
	</div>

	<div class="modal-body" id="div-chart">
			</div>
		
	<div class="modal fade" id="modal-default">
		<div class="modal-dialog modal-lg">
		<div class="modal-content">
			<div class="modal-header">
			<button type="button" class="close" data-dismiss="modal" aria-label="Close">
				<span aria-hidden="true">&times;</span></button>
			<h4 class="modal-title">Default Modal</h4>
			</div>
			<div class="modal-body" id="div-chartt">
			<p>One fine body&hellip;</p>
			</div>
			<div class="modal-footer">
			<button type="button" class="btn btn-default pull-left" data-dismiss="modal">Close</button>
			<button type="button" class="btn btn-primary">Save changes</button>
			</div>
		</div>
		<!-- /.modal-content -->
		</div>
		<!-- /.modal-dialog -->
	</div>
	<!-- /.modal -->
@endsection

@section('script')
    <script src="{{asset('adminlte/js/chart.js')}}"></script>
	<script src="{{asset('js/select2.full.min.js')}}"></script>
	<!--script src="{{asset('js/select2.full.js')}}"></script-->
	<script>
	
		
	$(function () {
		$('.select2').select2();
		$('#input-ms_classe_id-id').val([{{$mp_frais_id}}]).change();

		@if(count($tab))
		var datas = $("input#datas").val();
		var labels = $("input#labels").val();
		var url = "{{route('payment.rapport.chart')}}?labels="+labels+"&datas="+datas;
		$(".chart-btn").click(function(){
			$.get(url,function(data){
				$("#div-chart").html(data);
				//$("#modal-default").modal("show");
			})
		})
		@endif
	});
	</script>

<!--script>
  $(function () {
    /* ChartJS
     * -------
     * Here we will create a few charts using ChartJS
     */

    //--------------
    //- AREA CHART -
    //--------------

    // Get context with jQuery - using jQuery's .get() method.
    var areaChartCanvas = $('#areaChart').get(0).getContext('2d')
    // This will get the first returned node in the jQuery collection.
    var areaChart       = new Chart(areaChartCanvas)

    var areaChartData = {
      labels  : ['January', 'February', 'March', 'April', 'May', 'June', 'July'],
      datasets: [
        {
          label               : 'Electronics',
          fillColor           : 'rgba(210, 214, 222, 1)',
          strokeColor         : 'rgba(210, 214, 222, 1)',
          pointColor          : 'rgba(210, 214, 222, 1)',
          pointStrokeColor    : '#c1c7d1',
          pointHighlightFill  : '#fff',
          pointHighlightStroke: 'rgba(220,220,220,1)',
          data                : [65, 59, 80, 81, 56, 55, 40]
        },
        {
          label               : 'Digital Goods',
          fillColor           : 'rgba(60,141,188,0.9)',
          strokeColor         : 'rgba(60,141,188,0.8)',
          pointColor          : '#3b8bba',
          pointStrokeColor    : 'rgba(60,141,188,1)',
          pointHighlightFill  : '#fff',
          pointHighlightStroke: 'rgba(60,141,188,1)',
          data                : [28, 48, 40, 19, 86, 27, 90]
        }
      ]
    }

    var areaChartOptions = {
      //Boolean - If we should show the scale at all
      showScale               : true,
      //Boolean - Whether grid lines are shown across the chart
      scaleShowGridLines      : false,
      //String - Colour of the grid lines
      scaleGridLineColor      : 'rgba(0,0,0,.05)',
      //Number - Width of the grid lines
      scaleGridLineWidth      : 1,
      //Boolean - Whether to show horizontal lines (except X axis)
      scaleShowHorizontalLines: true,
      //Boolean - Whether to show vertical lines (except Y axis)
      scaleShowVerticalLines  : true,
      //Boolean - Whether the line is curved between points
      bezierCurve             : true,
      //Number - Tension of the bezier curve between points
      bezierCurveTension      : 0.3,
      //Boolean - Whether to show a dot for each point
      pointDot                : false,
      //Number - Radius of each point dot in pixels
      pointDotRadius          : 4,
      //Number - Pixel width of point dot stroke
      pointDotStrokeWidth     : 1,
      //Number - amount extra to add to the radius to cater for hit detection outside the drawn point
      pointHitDetectionRadius : 20,
      //Boolean - Whether to show a stroke for datasets
      datasetStroke           : true,
      //Number - Pixel width of dataset stroke
      datasetStrokeWidth      : 2,
      //Boolean - Whether to fill the dataset with a color
      datasetFill             : true,
      //String - A legend template
      legendTemplate          : '<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<datasets.length; i++){%><li><span style="background-color:<%=datasets[i].lineColor%>"></span><%if(datasets[i].label){%><%=datasets[i].label%><%}%></li><%}%></ul>',
      //Boolean - whether to maintain the starting aspect ratio or not when responsive, if set to false, will take up entire container
      maintainAspectRatio     : true,
      //Boolean - whether to make the chart responsive to window resizing
      responsive              : true
    }

    //Create the line chart
    areaChart.Line(areaChartData, areaChartOptions)

    //-------------
    //- LINE CHART -
    //--------------
    var lineChartCanvas          = $('#lineChart').get(0).getContext('2d')
    var lineChart                = new Chart(lineChartCanvas)
    var lineChartOptions         = areaChartOptions
    lineChartOptions.datasetFill = false
    lineChart.Line(areaChartData, lineChartOptions)

    //-------------
    //- PIE CHART -
    //-------------
    // Get context with jQuery - using jQuery's .get() method.
    var pieChartCanvas = $('#pieChart').get(0).getContext('2d')
    var pieChart       = new Chart(pieChartCanvas)
    var PieData        = [
      {
        value    : 700,
        color    : '#f56954',
        highlight: '#f56954',
        label    : 'Chrome'
      },
      {
        value    : 500,
        color    : '#00a65a',
        highlight: '#00a65a',
        label    : 'IE'
      },
      {
        value    : 400,
        color    : '#f39c12',
        highlight: '#f39c12',
        label    : 'FireFox'
      },
      {
        value    : 600,
        color    : '#00c0ef',
        highlight: '#00c0ef',
        label    : 'Safari'
      },
      {
        value    : 300,
        color    : '#3c8dbc',
        highlight: '#3c8dbc',
        label    : 'Opera'
      },
      {
        value    : 100,
        color    : '#d2d6de',
        highlight: '#d2d6de',
        label    : 'Navigator'
      }
    ]
    var pieOptions     = {
      //Boolean - Whether we should show a stroke on each segment
      segmentShowStroke    : true,
      //String - The colour of each segment stroke
      segmentStrokeColor   : '#fff',
      //Number - The width of each segment stroke
      segmentStrokeWidth   : 2,
      //Number - The percentage of the chart that we cut out of the middle
      percentageInnerCutout: 50, // This is 0 for Pie charts
      //Number - Amount of animation steps
      animationSteps       : 100,
      //String - Animation easing effect
      animationEasing      : 'easeOutBounce',
      //Boolean - Whether we animate the rotation of the Doughnut
      animateRotate        : true,
      //Boolean - Whether we animate scaling the Doughnut from the centre
      animateScale         : false,
      //Boolean - whether to make the chart responsive to window resizing
      responsive           : true,
      // Boolean - whether to maintain the starting aspect ratio or not when responsive, if set to false, will take up entire container
      maintainAspectRatio  : true,
      //String - A legend template
      legendTemplate       : '<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<segments.length; i++){%><li><span style="background-color:<%=segments[i].fillColor%>"></span><%if(segments[i].label){%><%=segments[i].label%><%}%></li><%}%></ul>'
    }
    //Create pie or douhnut chart
    // You can switch between pie and douhnut using the method below.
    pieChart.Doughnut(PieData, pieOptions)

    //-------------
    //- BAR CHART -
    //-------------
    var barChartCanvas                   = $('#barChart').get(0).getContext('2d')
    var barChart                         = new Chart(barChartCanvas)
    var barChartData                     = areaChartData
    barChartData.datasets[1].fillColor   = '#00a65a'
    barChartData.datasets[1].strokeColor = '#00a65a'
    barChartData.datasets[1].pointColor  = '#00a65a'
    var barChartOptions                  = {
      //Boolean - Whether the scale should start at zero, or an order of magnitude down from the lowest value
      scaleBeginAtZero        : true,
      //Boolean - Whether grid lines are shown across the chart
      scaleShowGridLines      : true,
      //String - Colour of the grid lines
      scaleGridLineColor      : 'rgba(0,0,0,.05)',
      //Number - Width of the grid lines
      scaleGridLineWidth      : 1,
      //Boolean - Whether to show horizontal lines (except X axis)
      scaleShowHorizontalLines: true,
      //Boolean - Whether to show vertical lines (except Y axis)
      scaleShowVerticalLines  : true,
      //Boolean - If there is a stroke on each bar
      barShowStroke           : true,
      //Number - Pixel width of the bar stroke
      barStrokeWidth          : 2,
      //Number - Spacing between each of the X value sets
      barValueSpacing         : 5,
      //Number - Spacing between data sets within X values
      barDatasetSpacing       : 1,
      //String - A legend template
      legendTemplate          : '<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<datasets.length; i++){%><li><span style="background-color:<%=datasets[i].fillColor%>"></span><%if(datasets[i].label){%><%=datasets[i].label%><%}%></li><%}%></ul>',
      //Boolean - whether to make the chart responsive
      responsive              : true,
      maintainAspectRatio     : true
    }

    barChartOptions.datasetFill = false
    barChart.Bar(barChartData, barChartOptions)
  })
</script-->
@endsection