@extends("template")

@section('style')
<style>
	
.table-blue.table-striped > tbody > tr:nth-of-type(2n+2) {
  background-color: #0000FF5F;
}
.table-blue.table-striped > tbody > tr:nth-of-type(2n+1) {
  background-color: #0000FF2F;
}	
.table-red.table-striped > tbody > tr:nth-of-type(2n+2) {
  background-color: #FF00005F;
}
.table-red.table-striped > tbody > tr:nth-of-type(2n+1) {
  background-color: #FF00002F;
}
section.content:nth-child(2) , .col-md-12{
  padding: 0; 
}
</style>
@endsection

@section('content')
	
	@php
	
	@endphp
	
	<div class="col-md-12 col-md-offset-0">
          <div class="box box-primary">
            <div class="box-header with-border">
              <h3 class="box-title">
                    SELECTIONNEZ UN OU PLUSIEURS ELEVES ET </h3>
              
                <button type="button" class="btn btn-danger btn-lancer-ops btn-xs" style="position: relative;top: -3px;display:none" data-toggle="modal" data-target="#modal-danger">
                  FAITES UNE OPERATION
                </button>

            </div>
            <!-- /.box-header -->
            <div class="box-body">
                <div class="col-md-6" style="padding:0">
                <button type="button" class="btn btn-primary btn-xs" id="btn-tout-selectionner">
                  TOUT SELECTIONNER
                </button>
                    <table id="table_source" class="table table-blue table-condensed table-striped sortable-table"> 
                        <thead>
                            <tr> 
                                <th style="display:none"></th>
            			        <th>MATRICULE</th>
            			        <th>ELEVE</th>
            			        <th>GENRE</th>
            			        <th>CLASSE</th>
            			        <th style="display:none"></th>
            				</tr>
        			    </thead>
        			    <tbody>
                      @foreach($msEleves as $e)
        			    <tr class="move-row" id="tr-id-{{$e->id}}"> 
        				    @if($e->enfant)
        				        <td style="display:none" class="eleve-id">{{$e->id}}</td>
        				        <td>{{$e->enfant->matricule}}</td>
        				        <td> {{$e->enfant->nom.' '.$e->enfant->postnom.' '.$e->enfant->prenom}}</td>
        				        <td>{{$e->enfant->genre}}</td>
        				        <td>{{$e->msClasse->classe}}</td>
        				    @else
        				    <td colspan="3">ELEVE SANS NON</td><td> {{$e->msClasse->classe}}</td>
        				    @endif
        				    <td class="img" src="{{asset($e->img?('storage/mseleve/img/'.$e->img):'img/eleve/'.($loop->index%4).'.png')}}"></td>
        			    </tr>
        			@endforeach
        			</tbody>
                    </table>
                </div>
                <div class="col-md-6">
                <button type="button" class="btn btn-warning btn-xs" id="btn-tout-restituer">
                  TOUT RETIRIER
                </button>
                    <table id="table_dest" class="table table-red table-condensed table-striped sortable-table"> 
                        <thead>
                            <tr> 
                                <th style="display:none"></th>
            			        <th>MATRICULE</th>
            			        <th>ELEVE</th>
            			        <th>GENRE</th>
            			        <th>CLASSE</th>
            			    </tr>
        			    </thead>
        			    <tbody></tbody>
                    </table>
                    <button type="button"  style="display:none" class="btn btn-danger btn-lancer-ops" data-toggle="modal" data-target="#modal-danger">
                      MARQUER LA CONDUITE
                    </button>
                </div>
            </div>
            <!-- /.box-body -->
            <div class="box-footer">
              
            </div>
          </div>
          <!-- /. box -->
        </div>
	
	

      <div class="modal fade" id="modal-danger">
        <div class="modal-dialog modal-lg">
          <div class="modal-content">
            <div class="modal-header">
              <h4 class="modal-title" id="title-tabs">MARQUER LA CONDUITE</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
                    @include('mes_vues.Disciplinary._tabs_operations')
            </div>
            <div class="modal-footer justify-content-between">
              <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
          </div>
          <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
      </div>
	
      <div class="modal fade" id="modal-info">
        <div class="modal-dialog">
          <div class="modal-content">
            <div class="modal-header">
              <h4 class="modal-title">DETAIL SUR L'ELEVE SELECTIONNE</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-sm-6">
    				    <img style="width: 100%;" id="detail_enfant_img" src="" />
    				</div>
                    <div class="col-sm-6">
    				    <h1 id="detail_enfant_nom"></h1>
    				    <p style="font-size: 20px;font-style: italic;"><span id="detail_enfant_matr"></span><br/>
    				    <span id="detail_enfant_genr"></span><br/>
    				    <span id="detail_enfant_clas"></span></p>
    				</div>
				</div>
            </div>
            <div class="modal-footer justify-content-between">
              <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
          </div>
          <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
      </div>
	
@endsection

@section('script')
	
	
	<script>
	var barcode = '';
    var interval;
    
    
    $(document).ready(function() {
        function deplacer_toute_les_tr(table_id_src,table_id_dest){
            var trs = $("#"+table_id_src+" tbody tr").remove().clone();
            $("#"+table_id_dest+" tbody").prepend(trs);
        }
        
        
        $("#btn-tout-selectionner").click(function(){
            deplacer_toute_les_tr("table_source","table_dest");
            if($("#table_dest tbody tr").length)$(".btn-lancer-ops").slideDown(300);
            else $(".btn-lancer-ops").slideUp(300);
        });
        $("#btn-tout-restituer").click(function(){
            deplacer_toute_les_tr("table_dest","table_source");
            $(".btn-lancer-ops").slideUp(300);
        });
        
        $("#table_source").on("click", "tr.move-row",function() {
            // 
            var $target = $(this);
            $(this).hide(500, function(){ 
                var t = $target.remove().clone(); 
                $("#table_dest tbody").prepend(t);
                t.delay(1000).show(500);
            })
            $("#modal-info").modal("show");
            var img = $target.find(".img").attr("src");
            $("#detail_enfant_img").attr("src",img);
            $("#detail_enfant_nom").html($target.find("td:eq(2)").text());
            $("#detail_enfant_matr").html($target.find("td:eq(1)").text());
            $("#detail_enfant_genr").html($target.find("td:eq(3)").text());
            $("#detail_enfant_clas").html($target.find("td:eq(4)").text());
            
            if($("#table_dest tbody tr").length)$(".btn-lancer-ops").slideDown(300);
            else $(".btn-lancer-ops").slideUp(300);
        });
    
        $("#table_dest").on("click", "tr.move-row", function() {
            var $target = $(this);
            $(this).hide(500, function(){ 
                var t = $target.remove().clone(); 
                $("#table_source tbody").prepend(t);
                t.delay(1000).show(500);
            });
            if($("#table_dest tbody tr").length)$(".btn-lancer-ops").slideDown(300);
            else $(".btn-lancer-ops").slideUp(300);
        });
        
        document.addEventListener('keydown', function(evt) {
            if (interval)
                clearInterval(interval);
            if (evt.code == 'Enter') {
                if (barcode)
                    handleBarcode(barcode);
                barcode = '';
                return;
            }
            if (evt.key != 'Shift')
                barcode += evt.key;
            interval = setInterval(() => barcode = '', 20);
        });
    
        function handleBarcode(scanned_barcode) {
            // document.querySelector('#last-barcode').innerHTML = scanned_barcode;
            var id = scanned_barcode;
            if(!parseInt(id))return alert("ACTIVEZ LE MAJUSCULE");
            if($("#table_source #tr-id-"+id).is('tr')){
                var $target = $("#table_source #tr-id-"+id);
                $target.hide(500, function(){ 
                    var t = $target.remove().clone(); 
                    $("#table_dest tbody").prepend(t);
                    t.delay(1000).show(500);
                });
                
                if($("#table_dest tbody tr").length)$(".btn-lancer-ops").slideDown(300);
                else $(".btn-lancer-ops").slideUp(300);
            }
            else if($("#table_dest #tr-id-"+id).is('tr')){
                if(confirm("RETIRER DE LA SELECTION ?")){
                    var $target = $("#table_dest #tr-id-"+id);
                    $target.hide(500, function(){ 
                        var t = $target.remove().clone(); 
                        $("#table_source tbody").prepend(t);
                        t.delay(1000).show(500);
                    });
                    
                    if($("#table_dest tbody tr").length)$(".btn-lancer-ops").slideDown(300);
                    else $(".btn-lancer-ops").slideUp(300);
                }
            }
            else{
                console.log("erreur");alert("code inconnu");
            } 
            console.log("Code lu "+id);
            $(this).val("");
        }
        
        $(".btn-lancer-ops").click(function(){
            var tab = $("#table_dest .eleve-id").map(function(){
                return $(this).text();
            }).get();
            $("#title-tabs").text(tab.length+" Elèves sélectionnés");
            var str_id = tab.join(",");
            $(".ids_selected_eleves").val(str_id);
            $("input[name='id_eleves']").val(str_id)
            return true;
        });
        function OrderBy(a,b,n) {
            if (n) return a-b;
            if (a < b) return -1;
            if (a > b) return 1;
            return 0;
        }
        $('.sortable-table thead th').click(function() {
            var $th = $(this).closest('th');
            $th.toggleClass('selected');
            var isSelected = $th.hasClass('selected');
            var isInput= $th.hasClass('input');
            var column = $th.index();
            var $table = $th.closest('table');
            var isNum= $table.find('tbody > tr').children('td').eq(column).hasClass('num');
            var rows = $table.find('tbody > tr').get();
            rows.sort(function(rowA,rowB) {
                if (isInput) {
                    var keyA = $(rowA).children('td').eq(column).children('input').val().toUpperCase();
                    var keyB = $(rowB).children('td').eq(column).children('input').val().toUpperCase();
                } else {
                    var keyA = $(rowA).children('td').eq(column).text().toUpperCase();
                    var keyB = $(rowB).children('td').eq(column).text().toUpperCase();
                }
                if (isSelected) return OrderBy(keyA,keyB,isNum);
                return OrderBy(keyB,keyA,isNum);
            });
            $.each(rows, function(index,row) {
                $table.children('tbody').append(row);
            });
            return false;
        });
        
        function onClick(){
			//var ids = $('#liste-eleves-select').val();
			//$('.ids_selected_eleves').val(ids);
			//if(ids=='')alert('AUCUN ELEVE CHOISI');
			/* {
				if(!confirme("AUCUN ELEVE CHOISI\nVOUS ALLEZ VALIDER L'OPERATION"))
					return false;
				else {
					$('.ids_selected_eleves').val(ids);
					return true;
				}
			} */
		}
		function onSuccess(data){
			// $('.select2').val('');
			// $('#liste-eleves-ul').html('');
			// $('.select2').select2();
			// annuler_toutes_les_selections();
			alert(data[0]);
		}
		ajax_fomr_submit('form', onSuccess, onClick);
    });
	</script>
	
	
	
@endsection