		
@extends('template')
@section('style')
	
	<link href="{{asset('css/select2.min.css')}}" rel="stylesheet">
	<style>
		.select2-container--default .select2-selection--single{
			height:34px;
		}
		
		.nav.nav-stacked li.active {
		  background: #add9ff;
		}
		
		.editable-table td.editable-td {
			background: azure;
			border-left: solid 1px #54f8f8;
		}
		button.btn.btn-box-tool {
			color: white;
		}
	</style>
@endsection
@section('content')


<div class="col-sm-12 no-padding no-print">
	<div class="box box-info collapsed-boxx">
		<div class="box-header bg-aqua">
		  <h3 class="box-title">ENREGISTREMENTS DE CONDUITE DU JOUR</h3>
		  <div class="box-tools pull-right">
			<button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
			</button>
		  </div>
		</div>
		<div class="box-body" style="display:nonee">
		  @if(isset($mdcommentaires))
			Il y a ({{$mdcommentaires->count()}}) Commentaire(s) dans la liste
			
			<p class="champ-visible" style="display:nonee"></p>
			<table id="datatable-mdcommentaires" class="table table-striped table-bordered">
				<thead>
						<tr>
							
							<th>Elève</th>
							<th>Période</th>
							<th>Date</th>
							<th>Importance</th>
							<th>Motif</th>
							<th>Détail</th>
						</tr>
				</thead>
				<tbody>
				@foreach($mdcommentaires as $key => $mdcommentaire)
					  @php $link = route('disciplinary.dossier',['ms_eleve_id'=>$mdcommentaire->ms_eleve_id]); @endphp
					<tr>
							
							<td onclick="window.open('{{$link}}')" style="cursor:pointer;color:#3c8dbc">{{ ($mdcommentaire->msEleve->enfant->matricule??'').' '.($mdcommentaire->msEleve->enfant->nom??'').' '.($mdcommentaire->msEleve->enfant->postnom??'').' '.($mdcommentaire->msEleve->enfant->prenom??'').' '.($mdcommentaire->msEleve->enfant->genre??'').' '.($mdcommentaire->msEleve->msClasse->classe??'').' '.($mdcommentaire->msEleve->msClasse->msPromotion->promotion??'').' '.($mdcommentaire->msEleve->msClasse->msPromotion->section_id??'') }}</td>
							<td>{{ ($mdcommentaire->periode->periode??'') }}</td>
							<td class='editable-td' k='{{$mdcommentaire->id}}' f='coment_date' c='MdCommentaire'>{{ $mdcommentaire->coment_date }}</td>
							<td class='editable-td' k='{{$mdcommentaire->id}}' f='importance' c='MdCommentaire'>{{ $mdcommentaire->importance }}</td>
							<td>{{ ($mdcommentaire->motifCommentaire->motif??'') }}</td>
							<td class='editable-td' k='{{$mdcommentaire->id}}' f='detail' c='MdCommentaire'>{{ $mdcommentaire->detail }}</td>

					</tr>
				@endforeach
				</tbody>
			</table>
		  @endif
		</div>
		<!-- /.box-body -->
	</div>
</div>
	

<div class="col-sm-12 col-sm-offset-0">		
	@php display_flash(); @endphp
	<div class="row no-print">
	<div class="col-md-6" style="padding-left: 0;">
		<div class="box collapsed-box">
			<div class="box-header with-border bg-aqua">
              <h3 class="box-title">Parametrage du rapport des abesens</h3>

              <div class="box-tools pull-right">
                <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-plus"></i>
                </button>
              </div>
            </div>
            <div class="box-body" style="display:none">
			<form class="form-horizontal" method="GET" action="{{route('disciplinary.rapport.absence')}}">
						
				<div class="form-group">
					<label for="" class="col-sm-3 control-label">Classes</label>
					
					<div class="col-sm-9 " style="padding-left: 0px;">
						<select required name="ms_classe_id[]" multiple id="input-ms_classe_id-id" class="form-control select2" style="width: 100%">
							<option value="all">Choisir une classe</option>
							@foreach($msClasses as $e)
								<option value="{{$e->id}}">{{$e->classe.' '.$e->msPromotion->promotion.' '.$e->msPromotion->section->nom_sec}}</option>
							@endforeach
						</select>
					</div>
				</div>
				<div class="form-group">
					<label for="" class="col-sm-3 control-label">Periode</label>
					
					<div class="col-sm-4 " style="padding-left: 0px;">
						<input value="{{$date1}}" name="date1" class="form-control" placeholder="Date debut" type="date" style="padding: 0px;" />
					</div>
					<div class="col-sm-5 " style="padding-left: 0px;">
						<input value="{{$date2}}" name="date2" class="form-control" placeholder="Date fin" type="date" style="padding: 0px;" />
					</div>
				</div>	
				<!--div class="form-group">
					<label for="" class="col-sm-3 control-label">Grouper par</label>
					
					<div class="col-sm-9 " style="padding-left: 0px;">
						<select name="grouper" class="form-control">
							<option value="jour">Jour</option>
							<option value="semaine">Semaine</option>
							<option value="mois">Mois</option>
						</select>
					</div>
				</div-->	
				<button type="submit" class="btn btn-info pull-right">Charger Rapport</button>
				
			</form>
			</div>
		</div>
	</div>
	
	<div class="col-md-6" style="padding-right: 0;">
		<div class="box collapsed-box">
			<div class="box-header with-border bg-red">
              <h3 class="box-title">Marquer les abesens automatiquement</h3>

              <div class="box-tools pull-right">
                <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-plus"></i>
                </button>
              </div>
            </div>
            <div class="box-body" style="display:none">
			<form class="form-horizontal" method="POST" action="{{route('disciplinary.marquer.absences')}}">
					@csrf
				<div class="form-group">
					<label for="" class="col-sm-3 control-label">Classes</label>
					
					<div class="col-sm-9 " style="padding-left: 0px;">
						<select required name="ms_classe_id[]" multiple id="input-ms_classe_ids-id" class="form-control select2" style="width: 100%">
							<option value="all">Choisir une classe</option>
							@foreach($msClasses as $e)
								<option value="{{$e->id}}">{{$e->classe.' '.$e->msPromotion->promotion.' '.$e->msPromotion->section->nom_sec}}</option>
							@endforeach
						</select>
					</div>
				</div>		
				<div class="form-group">
					<label for="" class="col-sm-3 control-label">Periode</label>
					
					<div class="col-sm-4 " style="padding-left: 0px;">
						<input value="{{date('Y-m-d')}}" name="date" class="form-control" placeholder="Date debut" type="date" style="padding: 0px;" />
					</div>
					<div class="col-sm-5 " style="padding-left: 0px;">
						<div style="border: solid 1px;padding: 5px 0 0 10px;">
							<input name="send_sms" id="activer-send_sms" type="checkbox">
							<label for="activer-send_sms">Envoyer SMS</label>
						</div>
					</div>
				</div>
				<button type="submit" class="btn btn-danger pull-right">Marquer le retard dans les classe indiquees</button>
				
			</form>
			</div>
		</div>
	</div>
	</div>
</div>


<div class="col-sm-12 col-sm-offset-0">

	@if(count($tentativeAbandon))
	<div class=row>
	  <div class="alert alert-danger alert-dismissible">
		<button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
		<h4><i class="icon fa fa-ban"></i>{{count($tentativeAbandon)}} eleve(s) risqu(ent) d'abandonner les cours !</h4>
		car voila plus de {{$nbrJrAbs}} jours qu'il(s) ne se presente(nt) plus en classe !!!
	  </div>
	</div>
	 @endif
	<div class="row">
		
		<div class="col-md-4" style='padding-left:0px'>
          <!-- Widget: user widget style 1 -->
          <div class="box box-widget widget-user-2">
            <!-- Add the bg color to the header using any of the bg-* classes -->
            <div class="widget-user-header bg-yellow">
			  <h3 class="widget-user-username" style="margin-left: 0px;">Stat. des Absences</h3>
              <h5 class="widget-user-desc" style="margin-left: 0px;">
			  periode: du {{ $date1 }} {{ $date2 == date('Y-m-d')?"a Aujourd'hui":" AU $date2" }} 
			  </h5>
            </div>
            <div class="box-footer no-padding">
              <ul class="nav nav-stacked">			  
				@foreach($tabJoursAbs as $d)
					<li class="{{$d->date_jour==$periode?'active':''}}" ><a href="?&jr={{$d->date_jour}}&date1={{$date1}}&date2={{$date2}}{{$ms_classe_id?('&ms_classe_id[]='.implode('&ms_classe_id[]=',$ms_classe_id)):''}}">
					{{$d->date_jour==$aujourd?"Aujourd'hui":
					($d->date_jour==$hier?"Hier":($d->date_jour==$avanthier?"Avant Hier":$d->date_jour))}} <span class="pull-right badge bg-blue">{{$d->nbr}}</span></a></li>
				@endforeach				  
			  </ul>
              <ul class="nav nav-stacked">			  
				@foreach($tabSemaineAbs as $d)
					<li class="{{$d->semaine==$periode?'active':''}}" ><a href="?&se={{$d->semaine}}&date1={{$date1}}&date2={{$date2}}{{$ms_classe_id?('&ms_classe_id[]='.implode('&ms_classe_id[]=',$ms_classe_id)):''}}">
					{{$d->semaine==date('W')-1?"Semaine en cours":
					($d->semaine==(date('W')-2)?"Semaine passee":($d->semaine==(date('W')-3)?"Semaine anterieure":$d->semaine))}} <span class="pull-right badge bg-blue">{{$d->nbr}}</span></a></li>
				@endforeach				  
			  </ul>
              <ul class="nav nav-stacked">			  
				@foreach($tabMoisAbs as $d)
					<li class="{{$d->mois==$periode?'active':''}}" ><a href="?&mois={{$d->mois}}&date1={{$date1}}&date2={{$date2}}{{$ms_classe_id?('&ms_classe_id[]='.implode('&ms_classe_id[]=',$ms_classe_id)):''}}">
					{{$d->mois==date('m')?"Mois en cours":
					($d->mois==(date('m')-1)?"Mois passe":($d->mois==(date('m')-3)?"Mois anterieur":$d->mois))}} <span class="pull-right badge bg-blue">{{$d->nbr}}</span></a></li>
				@endforeach				
              </ul>
            </div>
          </div>
          <!-- /.widget-user -->
        </div>
		
		<div class="col-md-8" style='padding-right:0px'>
            @if($titre)
				@if(count($grapData))
			<div class="box box-primary">
				<div class="box-header with-border" style="background: #3c8dbc;color: white;text-align:center">
				  <i class="fa fa-bar-chart-o"></i>

				  <h3 class="box-title">{{$titre}}</h3>

				  <div class="box-tools pull-right">
					<button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
					</button>
				  </div>
				</div>
				<div class="box-body">
				  <div id="bar-chart" style="height: 300px;"></div>
				</div>
				<!-- /.box-body-->
			</div>
				@endif
			<div class="box box-info">
				<div class="box-header with-border" style="background: #3c8dbc;color: white;text-align:center">
				  <h3 class="box-title">{{$titre}}</h3>

				  <div class="box-tools pull-right">
					<button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
					</button>
				  </div>
				</div>
				<!-- /.box-header -->
				<div class="box-body">
				  <div class="table-responsive">
					<table class="table table-hover no-margin editable-table">
					  <thead>
					  <tr>
						<th>#</th>
						<th>Date</th>
						<th>Eleves</th>
						<th>Classes</th>
						<th colspan=2>Date & Justificatioin </th>
					  </tr>
					  </thead>
					  <tbody>
					  @foreach($tabEleveAbs as $el)
					  @php $link = route('disciplinary.dossier',['ms_eleve_id'=>$el->ms_eleve_id]); @endphp
					  <tr>
						<td>{{$loop->index+1}}</td>
						<td>{{$el->date_jour}}</td>
						<td onclick="window.open('{{$link}}')" style="cursor:pointer;color:#3c8dbc">
						{{$el->matricule}} {{$el->nom.' '.$el->postnom.' '.$el->prenom}} {{$el->genre}}
						</td>
						<td>{{$el->classe}}</td>
						<td class='editable-td' k='{{$el->md_absence_id}}' f='justif_date' i='MdAbsence' t='date'>{{ $el->justif_date }}</td>
						<td class='editable-td' k='{{$el->md_absence_id}}' f='justif_detail' i='MdAbsence'>{{ $el->motif_absence }}</td>
					  </tr>
					  @endforeach
					  
					 </tbody>
					</table>
				  </div>
				  <!-- /.table-responsive -->
				</div>
				<!-- /.box-body -->
				<div class="box-footer clearfix">
				  <i>Merci M-Disciplinary</i>
				</div>
				<!-- /.box-footer -->
			  </div>
		  @endif
		</div>
	</div>
	
	
</div>
	
@endsection

@section('script')
	<script src="{{asset('js/Flot_jquery.flot.js')}}"></script>
	<script src="{{asset('js/jquery.flot.categories.js')}}"></script>
	<script src="{{asset('js/select2.full.min.js')}}"></script>
	
	<script>
	$(function () {
		$('.select2').select2()	

		/*
		 * BAR CHART
		 * ---------ms_eleve_id
		 */
		Jours = {
			'Aujourd\'hui':'Aujourd\'hui','Hier':'Hier','Avant Hier':'Avant Hier',
			'Saturday':'Samedi', 'Friday':'Vendredi', 'Thursday':'Jeudi', 'Wednesday':'Mercredi', 'Tuesday':'Mardi', 'Monday':'Lundi'};
			
		@if(count($grapData))
			@php $tab = [] ; @endphp
			@foreach($grapData as $d)
				@php $tab[] = "[Jours[\"".$d->jour."\"], $d->nbr]"; @endphp
			@endforeach
			tab_data = [{!! implode(",", $tab) !!}];
			var bar_data = {
			  data : tab_data,
			  color: '#3c8dbc'
			}
			$.plot('#bar-chart', [bar_data], {
			  grid  : {
				borderWidth: 1,
				borderColor: '#f3f3f3',
				tickColor  : '#f3f3f3'
			  },
			  series: {
				bars: {
				  show    : true,
				  barWidth: 0.5,
				  align   : 'center'
				}
			  },
			  xaxis : {
				mode      : 'categories',
				tickLength: 0
			  }
			})		
		@endif
	});
	</script>
@endsection		