@extends('template')

@section('content')

		@php 
			$tabPeriode = ['1ère','2ème','3ème','4ème','5ème','6ème'];
			$tabColor = ['Haute'=>'bg-red', 'Moyenne'=>'bg-green', 'Basse'=>'bg-yellow'];
			$route = route('disciplinary.dossier');
			$idCl = $classe->id??0;
		@endphp
	
		<style>
			.progress{background-color: #d5d5d5;}
		</style>
		
	
		<div class="box editable-table">
            <div class="box-header with-border no-print">
			<form action="" method="get">
			<h3 class="box-title">Selectionnez une classe
					<select required name="ms_classe_id" id="">
					<option value="">Choisir une classe</option>
					@foreach($msClasses as $e)
					<option value="{{$e->id}}" {{$e->id==$idCl?'selected=selected':''}} >{{$e->classe}}</option>
					@endforeach
					</select>
					<input type="submit" value="Afficher la conduite">
				</h3>
				</form>	
							<div class="pull-right box-tools">
                <!-- button with a dropdown -->
                
                <button type="button" class="btn btn-success btn-sm" data-widget="collapse"><i class="fa fa-minus"></i>
                </button>
              </div>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              
			<div class="col-md-12" >
			<h3>CONDUITE DES ELEVES DE LA CLASSE DE {{$classe->classe??''}}</h3>
              <table class="table table-bordered table-striped table-condensed table-hover">
				  <thead>
					<tr style="text-align: center;" class="bg-light-blue">
					  <th style="width: 10px">#</th>
					  <th>MATRICULE</th>
					  <th>ELEVES</th>
					  <th>GENRE</th>
					  <th>1ère P</th>
					  <th>2ème P</th>
					  <th>3ème P</th>
					  <th>4ème P</th>
					  <th>5ème P</th>
					  <th>6ème P</th>
					</tr>
				</thead>
                <tbody>
				@if($msEleves->count())
				@foreach($msEleves as $msEleve)
					@php 
						$genre = $msEleve->enfant->genre; 
						$enfant = $msEleve->enfant->nom.' '.$msEleve->enfant->postnom.' '.$msEleve->enfant->prenom;
						$mdCommentaires = $msEleve->mdCommentaires->groupBy('periode_id');
						$mdAbsences = $msEleve->mdAbsences->groupBy('periode_id');
						$mdRetards = $msEleve->mdRetards->groupBy('periode_id');
						
					@endphp
					<tr>
						<td>{{$loop->index+1}}</td>
						<td> {{$msEleve->enfant->matricule}}</td>
						<td> <a onclick="window.open('{{$route}}/{{$msEleve->id}}');" >{{$enfant}}</a></td>
						<td> {{$genre}}</td>
						@foreach($tabPeriode as $id=>$re)
							@php 
								$id1 = $id+1;
								$points = '';$PC = $PA = $PR = 0;
								if($mdCommentaires->has($id1)){
									$PC = $mdCommentaires[$id1]->sum(function($v){ return $v->motifCommentaire->point; });
								}
								if($mdAbsences->has($id1)){
									$PA = $mdAbsences[$id1]->sum(function($v) use($point_absence){ return $v->justif_date?0:$point_absence; });
								}
								if($mdRetards->has($id1)){
									$PR = $mdRetards[$id1]->sum(function($v) use($point_retard){ return $v->justif_date?0:$point_retard; });
								}
								$cote = $mention = 100-($PC+$PR+$PA);
								
								$mentions = $mdMentions->filter(function ($v, $key) use($mention){
									return $v->borne_inf <= $mention and $v->borne_sup >= $mention;
								});
								if($ment = $mentions->first())
									$mention = $ment->mention;
								else $mention = "$mention/100";
							@endphp
						<td style="text-align:center;color:{{$cote<50?'red':'blue'}}" > {{$mention}}</td>
						@endforeach
					</tr>
				@endforeach
				@endif
					 {{-- <!--td rowspan=2>{{$id1}}.</td>
					  <td>{{$re}} Période</td>
					  <td periode="periode-{{$id1}}"> <a href="#{{$id1.'com'}}" class="a-sous-table">{{$mdCommentaires->has($id1)?$mdCommentaires[$id1]->count().' fois interpellé(e)':'-'}}</a></td>
					  <td periode="periode-{{$id1}}"> <a href="#{{$id1.'ret'}}" class="a-sous-table">{{$mdRetards->has($id1)?$mdRetards[$id1]->count().' fois en retard':'-'}}</a></td>
					  <td periode="periode-{{$id1}}"> <a href="#{{$id1.'abs'}}" class="a-sous-table">{{$mdAbsences->has($id1)?$mdAbsences[$id1]->count().' fois absent(e)':'-'}}</a></td>
					  <td style="text-align:center" > {{$cote}}/100</td -->--}}
				</tbody>
			  </table>
            </div>
			
            </div>
            <!-- /.box-body -->
          </div>
		
		
            <script>
			$(function () {
				var ex_href = "";
				$(".a-sous-table").click(function(){
					var href = $(this).attr("href");
					var periode = $(".a-sous-table").parent(".active").attr("periode");
					// alert(periode)
					$("#"+periode).hide();
					$(".sous-table").hide();					
					$(".a-sous-table").parent(".active").removeClass("active");
					
					if(ex_href == href){
						ex_href='';
						return false;
					}
					$(this).parent().addClass("active");					
					$(href).parent().show(400);
					$(href).show(500);
					ex_href = href;
				})
			})
			self.moveTo(300,300);
            </script>
		
@endsection	

