
@extends('template')
@section('style')
	<link href="{{asset('css/select2.min.css')}}" rel="stylesheet">
	<style>
		.select2-selection.select2-selection--single {
		height: 32px;
		margin-right: 3px;
		}
		.select2-selection__arrow {
		margin-right: 10px;
		}
		.form-group label.valeur {
		text-align: left;
		color: #3d6c63;
		font-weight: normal;
		}
		.form-group label.valeur::before {
		content: ": ";
		font-weight: bolder;
		}
		.gallery img {
			width: 150px;
			margin: 10px;
		}
		#result-mouve, .overlay{display:none}
	</style>
	
@endsection
@section('content')
<div class="box box-default">
            <div class="box-header with-border">
              <h3 class="box-title">TRANSFERER LES FOND D'UN COMPTE VERS UN AUTRE</h3>
            </div>
            <div class="box-body">
        
            <div class="col-sm-10 col-sm-offset-1">
                @if(isset($compteAsuivre))
                @foreach($compteAsuivre as  $k => $grpcpt)
                <table class="table table-bordered table-striped table-hover">                
                    <thead>
                        <tr>
                            <th colspan="2">SECTEUR: {{$grpcpt->first()->cptSecteur->nom}} </th>
                            
                            <th colspan="2">SOLDE</th>
                        </tr>
                        <tr>
                            <th>N</th>
                            <th>COMPTES</th>
                            <th>USD</th><th>CDF</th>
                        </tr>
                    </thead>
                    <tbody id="report"  style="border: solid 3px #0a0a0a !important;">
                            
                            @foreach($grpcpt as $cpt)
                            <tr>
                                <td>{{$loop->index+1}}</td>
                                <td> {{$cpt->compte->libelle}}</td>
                                <td  class="mnt-repport" id="compe-a-suivre-{{$cpt->compte_id}}-{{$k}}-usd"><i class="fa fa-refresh fa-spin"></i></td>
                                <td  class="mnt-repport" id="compe-a-suivre-{{$cpt->compte_id}}-{{$k}}-cdf"><i class="fa fa-refresh fa-spin"></i></td>
                            </tr>
                            @endforeach
                    </tbody>
                </table>
                @endforeach
                @endif
            </div>     
            <div class="row">                
            @php display_flash(0); @endphp
            </div>
            <div class="col-sm-6 col-sm-offset-3">		
                <form enctype="multipart/form-data" class="form-horizontal" action="" method="POST">
                    <!-- /.box-header -->
                    <!-- form start -->
                    {{csrf_field()}}			
                    <div class="form-group" style="display:{{$user->cptComptables->count()==1?'none':'block'}}">
                        <div class="col-sm-12">
                            <label  class="control-label">Indiquer le secteur dans lequel est fait ce mouvement</label>
                            <select name="cpt_secteur_id"  class="form-control select2">
                                <!--option value="">Ce mouvement est fait dans quel secteur ?</option-->
                                @foreach($user->cptComptables as $e)
                                <option value="{{$e->cpt_secteur_id}}"> {{$e->cptSecteur->nom}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>				
                    <div class="form-group">
                        <div class="col-sm-12">
                            <label for="input-compte_id-id" class="control-label">Compte Initial</label>
                            <select name="compte_initial" id="input-compte_id-id" class="form-control select2">
                                <option value="">Choisir</option>
                                @foreach($comptes as $e)
                                @if(($e->categorieCompte?$e->categorieCompte->categorie:'')!='A. RECETTES')
                                <option value="{{$e->id}}"> {{$e->categorieCompte->entree?"ENTREE":"SORTIE"}} {{($e->code??'')}} {{($e->libelle??'')}}</option>
                                @endif
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="col-sm-12">
                            <label for="input-compte_id-id" class="control-label">Compte Final</label>
                            <select name="compte_final" id="input-compte_id-id"  class="form-control select2">
                                <option value="">Choisir</option>
                                @foreach($comptes as $e)
                                @if(($e->categorieCompte?$e->categorieCompte->categorie:'')!='A. RECETTES')
                                <option value="{{$e->id}}"> {{$e->categorieCompte->entree?"ENTREE":"SORTIE"}} {{($e->code??'')}} {{($e->libelle??'')}}</option>
                                @endif
                                @endforeach
                            </select>
                        </div>
                    </div>
						<div class="form-group">
							<div class="col-sm-6">
								<label for="input-montant_usd-id" class="control-label">Montant USD</label>
								<input  name="montant_usd" class="form-control" value="" id="input-montant_usd-id" type="text" placeholder=" Montant USD "> 						
							</div>
							<div class="col-sm-6">
								<label for="input-montant_cdf-id" class="control-label">Montant CDF</label>
								<input  name="montant_cdf" class="form-control" value="" id="input-montant_cdf-id" type="text" placeholder=" Montant CDF "> 						
							</div>
						</div>
						<div class="form-group">
							<div class="col-sm-12">
								<label for="input-libelle-id" class="control-label">Libelle</label>
								<input  name="motif" class="form-control" value="" id="input-libelle-id" type="text" placeholder=" Libelle du transfert">
							</div>
						</div>
                    <input type="submit" value="TRANSFERER" name="btn_transfere">
                </form>
            </div>
     

              
            </div>
          </div>
@endsection

@section('script')
	<script src="{{asset('js/select2.full.min.js')}}"></script>
	
<script> 
	
	function voir_etat_du_compte(date1,date2,id,sec){
		var url = "{{route('cash.afficher.etat.compte')}}";
		$.get(url+"/"+id+"/"+sec+"?date1="+date1+"&date2="+date2,function(data){
			var usd = (data.usd).toLocaleString('en-US',{style:'currency',currency:'USD','maximumFractionDigits':1});
			var cdf = (data.cdf).toLocaleString('en-US',{'maximumFractionDigits':1});
			$("#compe-a-suivre-"+id+"-"+sec+'-usd').html(usd);
			$("#compe-a-suivre-"+id+"-"+sec+'-cdf').html(cdf);
		})
	}

	// style:'currency',currency:'USD',
	$(function(){
        $('.select2').select2()	
		$(".mnt").each(function(){
			var t = parseInt($(this).text()).toLocaleString('en-US',{'maximumFractionDigits':1});
			$(this).text(t);console.log(t)
		})
		
		@if(isset($compteAsuivre))
			@foreach($compteAsuivre as $k=> $grpcpt)
				@foreach($grpcpt as $cpt)
				voir_etat_du_compte('',"{{date('Y-m-d')}}",{{$cpt->compte_id}},{{$k}});
				@endforeach
			@endforeach
		@endif
	})
</script>

@endsection	
