
@extends('template')
@section('style')
	<link href="{{asset('css/select2.min.css')}}" rel="stylesheet">
	<style>
		.select2-selection.select2-selection--single {
		height: 32px;
		margin-right: 3px;
		}
		.select2-selection__arrow {
		margin-right: 10px;
		}
		.form-group label.valeur {
		text-align: left;
		color: #3d6c63;
		font-weight: normal;
		}
		.form-group label.valeur::before {
		content: ": ";
		font-weight: bolder;
		}
		.gallery img {
			width: 150px;
			margin: 10px;
		}
		#result-mouve, .overlay{display:none}
	</style>
	
@endsection
@section('content')
<script>

	function img(src,name){
		return '<li>'+
			'<span class="mailbox-attachment-icon has-img"><img src="'+src+'" alt="Attachment"></span>'+

			'<div class="mailbox-attachment-info">'+
			' <input style="width: 100%;" name="'+name+'" type="text" placeholder="nom du document" > <a href="#" class="mailbox-attachment-name hide"> photo2.png</a>'+
			'</div>'+
		'</li>';
	}
	function loadImgs(imgs){
		var ul='', n= '';
		for(i=0; i< imgs.length;i++){
			n = "piece_"+i
			ul += img(window.URL.createObjectURL(imgs[i]),n)	
		}
		document.getElementById('pieces-div').innerHTML = ul
	}

</script>

	<div class="col-sm-12 ">
	<h3>
		SECTEURS:
		@if($user)  
			@foreach($user->cptComptables as $e)
			&nbsp;&nbsp;&nbsp;<u>{{$e->cptSecteur->nom??''}}</u> 
			@endforeach
		@endif
		&nbsp;&nbsp;&nbsp;&nbsp;
			
		<!--a href="{{route('cash.transfert.fond')}}">TRANSFERER LES FONDS</a-->
	</h3>

	<ul>
	@foreach($errors->all() as $e)
		<li>{{ $e }}</li>
	@endforeach
	</ul>
	@php 
	$page = isset($_GET['page']) ? $_GET['page']:'tab_1';
	//dd($page);
	@endphp


	<div class="nav-tabs-custom">
		<ul class="nav nav-tabs">
			<li class="{{($page=='tab_1')?'active':''}}"><a href="#tab_1" data-toggle="tab">Etablir une Fiche de Sortie</a></li>
			<li class="{{($page=='tab_3')?'active':''}}" ><a href="#tab_3" data-toggle="tab">Liste des Mouvements du jour</a></li>
			<li class="{{($page=='tab_2')?'active':''}}" ><a href="#tab_2" data-toggle="tab">Comptes</a></li>
		</ul>
		<div class="tab-content">
			<div class="tab-pane {{($page=='tab_1')?'active':''}}" id="tab_1">
			
			@include("mes_vues.Cash._form_sortie")  
            
			
			<div class="row">
				<br>
				<br>
				<div class="col-sm-12">
				<div class="box box-solid box-primary">
					<div class="box-header with-border">
						<h3 class="box-title">TABLEAU DES OPERATIONS <i>retrouvez ici n'importe quel mouvement enregistre</i> </h3>
					</div>
					<div class="body-box" style="overflow: auto;padding: 10px;">		
						<table style="width:100%" class="table table-striped table-hover table-bordered table-condensed editable-table" id="mouvement-datatable" >
							<thead>
								<tr>
									<th>N</th>
									<th style="width: 70px;">Date</th>
									<th>Libelle</th>
									<th>Compte Sortie</th>
									<th> CDF</th>
									<th> USD</th>
									<th>Compte Entree</th>
								<th>Secteur</th>
									<th style="width:15px">Actions</th>
									<th style="width:15px">Actions</th>
								</tr>
							</thead>
							<tbody>	
							</tbody>
						</table>
					</div>
				</div>

				</div>

			</div>

			</div>
		@php 
		// dd($_GET,$user->cptComptables );
		@endphp
			<!-- /.tab-pane -->
			<div class="tab-pane {{($page=='tab_2')?'active':''}}" id="tab_2">
			
			
			<div class="">
				<div class="box box-solid box-success collapsed-box">
					<div class="box-header with-border text-center">
						<h2 style="" class="box-title"> CREER UN NOUVEAU COMPTE</h2>
						<div class="box-tools pull-right">
							<button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-plus"></i></button>
						</div>
					</div>
					<div class="box-body" style="display:none">
					
						<br>
							@include('mes_vues.Cash._form_creer_compte')
						<br>
						<p style="text-align:center;"><b>N.B.</b> Le <b>code</b> permet de réunir les comptes des entrées à celles des sorties lors de l'etablissement des grands livres.</p>
					</div>
				</div>
				
				<div class="box box-solid box-success">
					<div class="box-header with-border text-center">
						<h2 style="" class="box-title"> LISTE DES COMPTE</h2>
						<div class="box-tools pull-right">
							<button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
						</div>
					</div>
					<div class="box-body">
						
						@include('mes_vues.Cash._liste_comptes')
					</div>
				</div>
				
			</div>
			</div>
			<!-- /.tab-pane -->
			<div class="tab-pane {{($page=='tab_3')?'active':''}}" id="tab_3" >
			<form action="" method="get">
				Mouvement du: <input type="date" name="date_mouv" value="{{$date}}" id="">
				AU <input type="date" name="date_mouv1" value="{{$date1}}" id="">
				<input type="submit" name="btn_liste_mouv" value="Afiicher la liste">
			</form>
			<hr style="border: solid 1px #000001;margin: 10px 0 20px 0;">
			
				<table id="datatable-mouvementcomptes" class="table table-striped table-bordered editable-table">
					<thead>
							<tr>
								
								<th>Date</th>
								<th>Libelle</th>
								<th>Compte Init</th>
								<th style='width:100px'> CDF</th>
								<th> USD</th>
								<th>Compte Final</th>
								<th style="width:15px">Actions</th>
								<th style="width:15px">Actions</th>
							</tr>
					</thead>
					<tbody>
						@php 
							$entree = '<span class="text-green fa fa-arrow-right"></span> ';
							$sortie = '<span class="text-red fa fa-arrow-left"></span> ';
							$tot_s = 0;
							$tot_e_cdf = $tot_e_usd = $tot_s_cdf = $tot_s_usd = 0;
						@endphp
					@foreach($mouvementcomptes as $key => $mouvementcompte)
					@foreach($mouvementcompte->mouvementCpteUtilises as $key => $cu)
						<tr>
								
							<td class='editable-td' k='{{$mouvementcompte->id}}' f='date_mouv' i='68' t='date' >{{ $mouvementcompte->date_mouv }}</td>
							<td class='editable-td' k='{{$mouvementcompte->id}}' f='libelle' i='68' t='checkbox' >{{ $mouvementcompte->libelle }}</td>
							<td class='editable-td'  k='{{$mouvementcompte->id}}' f='compte_id' i='68' t='select' s='Compte' > 
								[{{ ($cu->compteInitial->code??'') }}] 
								[{{ ($cu->compteInitial->libelle??'') }}] 
							</td>
							<td class='editable-td' k='{{$mouvementcompte->id}}' f='montant_cdf' i='68' t='text' >{{ chiffre($cu->montant_cdf) }}</td>
							<td class='editable-td' k='{{$mouvementcompte->id}}' f='montant_usd' i='68' t='text' >{{ chiffre($cu->montant_usd) }}</td>
							<td class='editable-td'  k='{{$mouvementcompte->id}}' f='compte_id' i='68' t='select' s='Compte' > 
								[{{ ($cu->compteFinal->code??'') }}] 
								[{{ ($cu->compteFinal->libelle??'') }}] 
							</td>
							{{--<td class='editable-td' k='{{$mouvementcompte->id}}' f='demander_par' i='68' t='' >{{ $mouvementcompte->demander_par }}</td>--}}

									<!-- delete the nerd (uses the destroy method DESTROY /mouvementcomptes/{id} -->
									<!-- we will add this later since its a little more complicated than the other two buttons -->

							<!-- we will also add show, edit, and delete buttons CrÃ©er -->
							<td>
								<a class="btn btn-small btn-success btn-xs" href="{{ route('cash.fiche.detail',['id'=>$mouvementcompte->id]) }}">Details</a>
							</td>
							<td>								
								<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('mouvementcomptes.destroy',$mouvementcompte)}}" method="POST">
									{{csrf_field()}}
									{{method_field('DELETE')}}
									<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
									
								</form>
							</td>
						</tr>
						@php 
						if(false and $mouvementcompte->compte->categorieCompte->entree){
							$tot_e_usd += $cu->montant_usd;
							$tot_e_cdf += $cu->montant_cdf;
						}
						else {
							$tot_s_usd += $cu->montant_usd;
							$tot_s_cdf += $cu->montant_cdf;
						}
							
						@endphp
					@endforeach
					@endforeach
					</tbody>
				</table>
				
				<table  class="table table-striped table-bordered editable-table">
					<tr> 
						<th>TOT ENTREE USD</th> <th>TOT ENTREE CDF</th> 
						<th>TOT SORTIE USD</th> <th>TOT SORTIE CDF</th> 
						<th>SOLD USD</th> <th>SOLD CDF</th> 
					</tr>
					<tr> 
						<td>{{ chiffre($tot_e_usd) }}</td> <td>{{ chiffre($tot_e_cdf) }}</td> 
						<td>{{ chiffre($tot_s_usd) }}</td> <td>{{ chiffre($tot_s_cdf) }}</td> 
						<td>{{ chiffre($tot_e_usd-$tot_s_usd) }}</td> <td>{{ chiffre($tot_e_cdf-$tot_s_cdf) }}</td> 
					</tr>
				</table>
			</div>
			
			<!-- /.tab-pane -->
		</div>
		<!-- /.tab-content -->
		</div>

		@php display_flash(0); @endphp

	</div>
	<div class="col-sm-12 col-sm-offset-0">
		
			
	</div>

	
	<form enctype="multipart/form-data" id="form-ajouter-compte" class="form-horizontal" action="{{route('cash.fiche.compte.init.final.save')}}" method="POST">
		<div class="modal fade" id="modal-ajout-compte">
          	<div class="modal-dialog">
				<div class="modal-content box">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span></button>
						<h4 class="modal-title">JOINDRE UN AUTRE COMPTE AU MOUVEMENT: <b id="titre-mouve"></b></h4>
					</div>
					<div class="modal-body">	<!-- /.box-header -->
						<!-- form start -->
						{{csrf_field()}}			
						<input type="hidden" name="mouvement_compte_id" id="input-mouvement_compte_id-id">				
						<div class="form-group">
							<div class="col-sm-12">
								<label for="input-compte_id-id" class="control-label">Compte Initial</label>
								<select name="compte_initial" id="input-compte_id-id"  class="form-control select2">
									<option value="">Choisir</option>
									@foreach($comptes as $e)
									@if(($e->categorieCompte?$e->categorieCompte->categorie:'')!='A. RECETTES')
									@if($e->categorieCompte)
									<option value="{{$e->id}}"> {{$e->categorieCompte->entree?"ENTREE":"SORTIE"}} {{($e->code??'')}} {{($e->libelle??'')}}</option>
									@endif 
									@endif
									@endforeach
								</select>
							</div>
						</div>

						<div class="form-group">
							<div class="col-sm-12">
								<label for="input-compte_id-id" class="control-label">Compte Final</label>
								<select name="compte_final" id="input-compte_id-id"  class="form-control select2">
									<option value="">Choisir</option>
									@foreach($comptes as $e)
									@if(($e->categorieCompte?$e->categorieCompte->categorie:'')!='A. RECETTES')
									@if($e->categorieCompte)
									<option value="{{$e->id}}"> {{$e->categorieCompte->entree?"ENTREE":"SORTIE"}} {{($e->code??'')}} {{($e->libelle??'')}}</option>
									@endif
									@endif
									@endforeach
								</select>
							</div>
						</div>
						<div class="form-group">
							<div class="col-sm-6">
								<label for="input-montant_cdf-id" class="control-label">Montant CDF</label>
								<input  name="montant_cdf" class="form-control" value="{{ old('montant_cdf')??$mouvementcompte->montant_cdf }}" id="input-montant_cdf-id" type="text" placeholder=" Montant CDF "> 						
							</div>
							<div class="col-sm-6">
								<label for="input-montant_usd-id" class="control-label">Montant USD</label>
								<input  name="montant_usd" class="form-control" value="{{ old('montant_usd')??$mouvementcompte->montant_usd }}" id="input-montant_usd-id" type="text" placeholder=" Montant USD "> 						
							</div>
						</div>
						<div class="callout callout-danger" id='result-mouve'>
							<h4><i class="icon fa fa-ban"></i> ERREUR A L'ENREGISTREMENT!</h4>

							<p></p>
						</div>
					</div>
					<div class="overlay">
						<i class="fa fa-refresh fa-spin"></i>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-default pull-left" data-dismiss="modal">Close</button>
						<button type="submit" class="btn btn-success pull-right">AJOUTER</button>
					</div>
				</div>
            <!-- /.modal-content -->
          	</div>
          <!-- /.modal-dialog -->
    	</div>
    </form>
        <!-- /.modal -->

@endsection

@section('script')
	<script src="{{asset('js/select2.full.min.js')}}"></script>
	
	<script> 
	var dataTable ;
	$(function () {	
		$('.select2').select2()	
		$('.voir-form-sortie').click(function(){
			$("#titre-form-sortie").text($(this).attr("titre"));
			var cls = $(this).attr("clas");
			$("#modal-form-sortie").parent().attr('action',$(this).attr("action"));
			$("#modal-form-sortie .modal-header").attr('class',"modal-header bg-"+cls);
			$("#btn-submit-form-sortie").attr('class',"pull-right btn btn-"+cls);
			if(cls=='danger'){
				$("#input-compte_final-id").val('');
				$("#input-compte_final-id").change();
				$("#input-compte_final-id").removeAttr('required');
				$("#input-compte_final-id").parent().parent().hide();
				$("#input-compte_initial-id").parent().parent().show();
				$("#input-compte_initial-id").attr('required','required');
			}
			else if(cls=='success'){
				$("#input-compte_initial-id").val('');
				$("#input-compte_initial-id").change();
				$("#input-compte_initial-id").removeAttr('required');
				$("#input-compte_initial-id").parent().parent().hide();
				$("#input-compte_final-id").parent().parent().show();
				$("#input-compte_final-id").attr('required','required');
			}
			else{
				$("#input-compte_initial-id").attr('required','required');
				$("#input-compte_final-id").attr('required','required');
				$("#input-compte_final-id").parent().parent().show();
				$("#input-compte_initial-id").parent().parent().show();
			}
			
		})

			dataTable = $('#mouvement-datatable').DataTable({
				"ordering": false,
				"processing":true,
				"serverSide":true,
				"order":[],
				"ajax":{
					url:"{{route('cash.datatable')}}",
					type:"GET"
				}
				,
				"createdRow": function( row, data, dataIndex ) {
					$entree = '<span class="text-green fa fa-arrow-right"></span> ';
					$sortie = '<span class="text-red fa fa-arrow-left"></span> ';
					var lbl = "<label style='' class='editable-td' k='"+data[10]+"' f='libelle' i='68' t='text'>"+data[2]+"</label>";
					$('td:eq(1)', row).html("<label class='editable-td' k='"+data[10]+"' f='date_mouv' i='68' t='date'>"+data[1]+"</label>" );
					$('td:eq(2)', row).html((data[3]==' '?$entree:$sortie)+lbl +'<span class="text-blue fa fa-plus ajout-compte" mouve="'+data[10]+'" title="Ajouter un autre compte au mouvement" lib="'+data[2]+' DU '+data[1]+'"></span>');
					$('td:eq(3)', row).html("<label style='width: 100%;min-height: 15px;' class='editable-td' k='"+data[11]+"' f='compte_initial' i='79' t='select' s='Compte'>"+data[3]+"</label>" );
					$('td:eq(6)', row).html("<label style='width: 100%;min-height: 15px;' class='editable-td' k='"+data[11]+"' f='compte_final' i='79' t='select' s='Compte'>"+data[6]+"</label>" );
					var th1 = '<a class="btn btn-small btn-success btn-xs" href="'+data[8]+'">Details</a>';
					var th2 = '<form style="margin: 0;" onsubmit="return confirm(\' LE MOUVEMENT ET TOUS LES COMPTES ASSOCIES VONT ETRE PERDUS Voulez-vous supprimer ?\')" action="'+data[9]+'" method="POST">'+
									'{{csrf_field()}}'+
									'{{method_field('DELETE')}}<input type="hidden" na="redirectTo" value="{{url()->current()}}">'+
									'<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>'+
								'</form>';
					$('td:eq(8)', row).html(th1);
					$('td:eq(9)', row).html(th2);
				}

			});
			// dataTable.DataTable().column(11).visible(false); 
			// dataTable.DataTable().column(12).visible(false); 
			$('#liste-eleve-paiement').on('click','.sup-paiement',function(){
			//$('.sup-paiement').click(function(){
				$('.overlay').hide();
				$('#mp_frais_paiement_id').val($(this).attr('idp'));
				$('#mp_recu_id').val($(this).attr('idr'));
				var titre = "Suppression Frais: <u> "+$(this).attr('frais')+'</u>  <br> <b> Eleve : '+$(this).attr('enfant')+'</b> ' ;
				$('.modal-title').html(titre);
				console.log("Okay")
			})
			
			// ajout d'un compte au mouvement
			$('#mouvement-datatable').on('click','.ajout-compte',function(){
				$('#input-mouvement_compte_id-id').val($(this).attr('mouve'));
				$("#modal-ajout-compte").modal('show');
				$("#modal-ajout-compte #titre-mouve").html($(this).attr('lib'));
				$("#modal-ajout-compte #result-mouve p").html('');
				$("#modal-ajout-compte #result-mouve").hide();
				console.log("chad")
			})
			ajax_fomr_submit("#form-ajouter-compte",success_callback=function(data){
				console.log(data);
				$('.overlay').hide();
				if(data.result=='fail'){					
					$("#modal-ajout-compte #result-mouve p").html(data.message);
					$("#modal-ajout-compte #result-mouve").show();
					//alert('QTTENTION');					
					return;
				}
				dataTable.ajax.reload();
				$("#modal-ajout-compte").modal('hide');
			},click_callback=function(){
				$('.overlay').show();
			});
			
			ajax_fomr_submit(".form-sup-paiement",success_callback=function(data){
				console.log(data);
				$('.overlay').hide();
				if(data.result!='success'){
					
					//alert(data.message);
					
					return;
				}
				$("#modal-sup-paiement").modal('hide'); 
				dataTable.ajax.reload();
				// alert("Modification faite");
				/* var id_prof = data.ms_prof_id;
				identification_attributions_profs(id_prof);
				$("#modal-composition").modal('hide');
				$("#modal-contenu").modal('hide'); */
				// $("#modal-exceptionnel").modal('hide');
			},click_callback=function(){
				$('.overlay').show();
			});

		$('.select2.select2-container.select2-container--default').css({'width':'100%'});
		if ($("#faire_suivi").is(':checked')){
			$("#form-suivi").show(500)
			$("#input-tache-id").val($("#input-libelle-id").val());
		}			
		else $("#form-suivi").hide(500)

		$("#faire_suivi").change(function(){
			if ($(this).is(':checked')){
				$("#form-suivi").show(500)
				$("#input-tache-id").val($("#input-libelle-id").val());
			}
			else $("#form-suivi").hide(500)
		})
		
	
	
		// Multiple images preview in browser
		var imagesPreview = function(input, placeToInsertImagePreview) {

			if (input.files) {
				var filesAmount = input.files.length;

				for (i = 0; i < filesAmount; i++) {
					var reader = new FileReader();

					reader.onload = function(event) {
						$($.parseHTML('<img>')).attr('src', event.target.result).appendTo(placeToInsertImagePreview);
					}

					reader.readAsDataURL(input.files[i]);
				}
			}

		};

		$('#gallery-photo-add').on('change', function() {
			imagesPreview(this, 'div.gallery');
		});
	});
	</script> 
@endsection		