		
@extends('template')
@section('style')


@endsection
@section('content')
    <?php
        $type = isset($_GET["type"])?$_GET["type"]:"JOURNALIER";
        if($type=="JOURNALIER"){
            $day = date('w');
            $default_debut = date('Y-m-d', strtotime('-'.$day.' days'));
            // var_dump($default_debut,$day);
        }
        else $default_debut=date("Y-m-01");
        $debut = isset($_GET["debut"])?$_GET["debut"]:$default_debut;
        $fin = isset($_GET["fin"])?$_GET["fin"]:date("Y-m-d");
        $ecole_id =  \App\Config::getEcoleId();
    ?>
    <form action="" style="text-align: center;font-size: 16px;">	
        <select name="type">
            <?php
            $_types = ['JOURNALIER','HEBDOMADAIRE','MENSUEL'];
            foreach($_types as $m){ ?>
            <option value="<?=$m?>"  <?=$m==$type?"selected":"" ?>>INDICATEUR <?=$m?></option>
            <?php } ?>
        </select>
        DATE RECENTE
        <input type="date" name="fin" value="<?=$fin?>" required/> DATE FINALE
        <input type="date" name="debut" value="<?=$debut?>" required/>
        <input type="submit" value="VISUALISER L'INDICATEUR" style="height: 25px;position: relative;top: 2px;" />
    </form>	
<?php 
        $xdata_sorties_encours = $xdata_entrees_encours = $labels = [];
        if($type=="JOURNALIER")$suite="jours";
        elseif($type=="HEBDOMADAIRE")$suite="hebdos";
        else  $suite="jours";
        
        $req = "SELECT * FROM `v_les_entrees_$suite` WHERE fait_le BETWEEN '$debut' and '$fin' and ecole_id='$ecole_id' order by fait_le desc;";
        $result  = \DB::select($req); 
        $som_entree = $som_sortie=0;
        foreach($result as $r){
            $som_entree += $r->cdf;
            $xdata_entrees_encours[$r->fait_le]=$r->cdf;
            $labels[$r->fait_le]=$r->fait_le;
        }
        
        $req = "SELECT * FROM `v_les_sorties_$suite` WHERE fait_le BETWEEN '$debut' and '$fin' and ecole_id='$ecole_id' order by fait_le desc;";
        $result  = \DB::select($req); 
        foreach($result as $r){
            $som_sortie += $r->cdf;
            $xdata_sorties_encours[$r->fait_le]=$r->cdf;
            if(!isset($labels[$r->fait_le])){
                $labels[$r->fait_le]=$r->fait_le;
                $xdata_entrees_encours[$r->fait_le]=0;
            }
        }
        
        if(count($xdata_entrees_encours)!=count($xdata_sorties_encours)){
            foreach($xdata_entrees_encours as $k=>$r){
                if(!isset($xdata_sorties_encours[$k])){
                    $xdata_sorties_encours[$k]=0;
                }
            }
        }
        
        $data_bar = $data_line = $yValues = "";
        foreach($labels as $k=>$r){
            $yValues .= "'$r',";
            $data_line .= "$xdata_sorties_encours[$k],";
            $data_bar .= "$xdata_entrees_encours[$k],";
        }
        $legende_line = "LES SORTIES ".number_format($som_sortie,0);
        $legende_bar = "LES ENTREES ".number_format($som_entree,0);
        $grand_titre = "ANALYSE DES SORTIES SUR LES ENTREES";
        $grand_titre_2=" du ".date("d/M",strtotime($debut))." au ".date("d/M, y",strtotime($fin))." ";
    ?>

    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<div style="background: white;">    
    <canvas id="myChart" stylee="width:100%;max-width:600px"></canvas>
</div>    
    <script>
    const xValues = [<?=$yValues?>];
    const data_bar = [<?=$data_bar?>];
    const data_line = [<?=$data_line?>];
    
    new Chart("myChart", {
      type: "line",
      data: {
        labels: xValues,
        datasets: [
        {type: 'line',
        label: "<?=$legende_line?>",
          fill: false,
          lineTension: 0,
          backgroundColor: "rgba(255,0,0,1.0)",
          borderColor: "rgba(255,0,0,0.8)",
          data: data_line
        },
        {type: 'bar',
        label: "<?=$legende_bar?>",
          fill: false,
          lineTension: 0,
          backgroundColor: "rgba(0,0,255,0.5)",
          borderColor: "rgba(0,0,255,0.1)",
          data: data_bar
        }]
      },
      options: {
        legend: {display: false},
        scales: {
          yAxes: [{ticks: {min: 6, max:16}}],
        },
        plugins: {
          title: {
            display: true,
            text: "<?=$grand_titre?>",
          },
          subtitle: {
            display: true,
            text: "<?=$grand_titre_2?>",
            color: 'blue',
            font: {
              size: 14,
              family: 'tahoma',
              weight: 'normal',
              style: 'italic'
            },
            padding: {
              bottom: 10
            }
          }
        }
      }
    });
    </script>

	
	
@endsection

@section('script')
	
	<script> 
	$(function(){
		
		
	})
	</script> 
@endsection		