﻿@extends('Masomwetu.Sys.sysaccesslevels.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('sysaccesslevels.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$sysaccesslevels->count()}}) Niveau d'accès(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-sysaccesslevels" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Zone</th>
					<th>Rôle</th>
					<th>Lire</th>
					<th>Ecrire</th>
					<th>Créer</th>
					<th>Modifier</th>
					<th>Lister</th>
					<th>Supprimer</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($sysaccesslevels as $key => $sysaccesslevel)
			<tr>
					
					<td class='editable-td'  k='{{$sysaccesslevel->id}}' f='sys_zone_id' i='16' t='select' s='SysZone' >{{ ($sysaccesslevel->sysZone->zone??'') }}</td>
					<td class='editable-td'  k='{{$sysaccesslevel->id}}' f='sys_role_id' i='16' t='select' s='SysRole' >{{ ($sysaccesslevel->sysRole->role??'') }}</td>
					<td class='editable-td' k='{{$sysaccesslevel->id}}' f='read' i='16' t='checkbox' >{{ $sysaccesslevel->read }}</td>
					<td class='editable-td' k='{{$sysaccesslevel->id}}' f='write' i='16' t='checkbox' >{{ $sysaccesslevel->write }}</td>
					<td class='editable-td' k='{{$sysaccesslevel->id}}' f='create' i='16' t='checkbox' >{{ $sysaccesslevel->create }}</td>
					<td class='editable-td' k='{{$sysaccesslevel->id}}' f='update' i='16' t='checkbox' >{{ $sysaccesslevel->update }}</td>
					<td class='editable-td' k='{{$sysaccesslevel->id}}' f='liste' i='16' t='checkbox' >{{ $sysaccesslevel->liste }}</td>
					<td class='editable-td' k='{{$sysaccesslevel->id}}' f='delete' i='16' t='checkbox' >{{ $sysaccesslevel->delete }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /sysaccesslevels/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('sysaccesslevels/' . $sysaccesslevel->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('sysaccesslevels/' . $sysaccesslevel->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('sysaccesslevels.destroy',$sysaccesslevel)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-sysaccesslevels").DataTable();
			creer_champ_visible_lable('sysaccesslevels');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
