﻿@extends('Masomwetu.Sys.smsconfigs.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('smsconfigs.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$smsconfigs->count()}}) Configuration Sms(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-smsconfigs" class="table table-striped table-bordered editable-table">
		<thead>
				<tr>
					
					<th>Active</th>
					<th>IP Serveur (telephone)</th>
					<th>Port Serveur</th>
					<th>Sim</th>
					<th>Reseau</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($smsconfigs as $key => $smsconfig)
			<tr>
					
					<td class='editable-td' k='{{$smsconfig->id}}' f='active' i='0' t='checkbox' >{{ $smsconfig->active }}</td>
					<td class='editable-td' k='{{$smsconfig->id}}' f='ip' i='0' t='text' >{{ $smsconfig->ip }}</td>
					<td class='editable-td' k='{{$smsconfig->id}}' f='port' i='0' t='text' >{{ $smsconfig->port }}</td>
					<td class='editable-td' k='{{$smsconfig->id}}' f='sim' i='0' t='number' >{{ $smsconfig->sim }}</td>
					<td class='editable-td' k='{{$smsconfig->id}}' f='reseau' i='0' t='text' >{{ $smsconfig->reseau }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /smsconfigs/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('smsconfigs/' . $smsconfig->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('smsconfigs/' . $smsconfig->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('smsconfigs.destroy',$smsconfig)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-smsconfigs").DataTable();
			creer_champ_visible_lable('smsconfigs');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
