﻿@extends('Masomwetu.School.ecoles.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('ecoles.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$ecoles->count()}}) Ecole(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-ecoles" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Nom de l'école</th>
					<th>Logo</th>
					<th>Code de l'école</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($ecoles as $key => $ecole)
			<tr>
					
					<td class='editable-td' k='{{$ecole->id}}' f='nom_ecole' i='6' t='text' >{{ $ecole->nom_ecole }}</td>
					<td class='editable-td' k='{{$ecole->id}}' f='logo_ecole' i='6' t='file' ><img class='crud_img' src="{{ asset('storage/ecole/logo_ecole/'.$ecole->logo_ecole) }}" /></td>
					<td class='editable-td' k='{{$ecole->id}}' f='code_ecole' i='6' t='text' >{{ $ecole->code_ecole }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /ecoles/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('ecoles/' . $ecole->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('ecoles/' . $ecole->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('ecoles.destroy',$ecole)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-ecoles").DataTable();
			creer_champ_visible_lable('ecoles');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
