﻿@extends('Masomwetu.School.dossierenfants.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('dossierenfants.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$dossierenfants->count()}}) Dossier des enfants(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-dossierenfants" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Enfant</th>
					<th>Titre du document</th>
					<th>Description</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($dossierenfants as $key => $dossierenfant)
			<tr>
					
					<td class='editable-td'  k='{{$dossierenfant->id}}' f='enfant_id' i='64' t='select' s='Enfant' >{{ ($dossierenfant->enfant->matricule??'').' '.($dossierenfant->enfant->nom??'').' '.($dossierenfant->enfant->postnom??'').' '.($dossierenfant->enfant->prenom??'').' '.($dossierenfant->enfant->genre??'') }}</td>
					<td class='editable-td' k='{{$dossierenfant->id}}' f='titre_document' i='64' t='text' >{{ $dossierenfant->titre_document }}</td>
					<td class='editable-td' k='{{$dossierenfant->id}}' f='description' i='64' t='text' >{{ $dossierenfant->description }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /dossierenfants/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('dossierenfants/' . $dossierenfant->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('dossierenfants/' . $dossierenfant->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('dossierenfants.destroy',$dossierenfant)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-dossierenfants").DataTable();
			creer_champ_visible_lable('dossierenfants');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
