﻿@extends('Masomwetu.Scholar.mseleves.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('mseleves.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$mseleves->count()}}) Elève(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-mseleves" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Noms</th>
					<th>Classe</th>
					<th>Date Inscription</th>
					<th>Photo</th>
					<th>Inscription</th>
					<th>Etat</th>
					<th>Status</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($mseleves as $key => $mseleve)
			<tr>
					
					<td class='editable-td'  k='{{$mseleve->id}}' f='enfant_id' i='8' t='select' s='Enfant' >{{ ($mseleve->enfant->matricule??'').' '.($mseleve->enfant->nom??'').' '.($mseleve->enfant->postnom??'').' '.($mseleve->enfant->prenom??'').' '.($mseleve->enfant->genre??'') }}</td>
					<td class='editable-td'  k='{{$mseleve->id}}' f='ms_classe_id' i='8' t='select' s='MsClasse' >{{ ($mseleve->msClasse->classe??'').' '.($mseleve->msClasse->msPromotion->promotion??'').' '.($mseleve->msClasse->msPromotion->section->nom_sec??'') }}</td>
					<td class='editable-td' k='{{$mseleve->id}}' f='inscrit_le' i='8' t='date' >{{ $mseleve->inscrit_le }}</td>
					<td class='editable-td' k='{{$mseleve->id}}' f='img' i='8' t='file' ><img class='crud_img' src="{{ asset('storage/mseleve/img/'.$mseleve->img) }}" /></td>
					<td class='editable-td'  k='{{$mseleve->id}}' f='ms_inscription_id' i='8' t='select' s='MsInscription' >{{ ($mseleve->msInscription->enfant->matricule??'').' '.($mseleve->msInscription->enfant->nom??'').' '.($mseleve->msInscription->enfant->postnom??'').' '.($mseleve->msInscription->enfant->prenom??'').' '.($mseleve->msInscription->enfant->genre??'').' '.($mseleve->msInscription->msPromotion->promotion??'').' '.($mseleve->msInscription->msPromotion->section->nom_sec??'') }}</td>
					<td class='editable-td' k='{{$mseleve->id}}' f='etat' i='8' t='text' >{{ $mseleve->etat }}</td>
					<td class='editable-td'  k='{{$mseleve->id}}' f='status_enfant_id' i='8' t='select' s='StatusEnfant' >{{ ($mseleve->statusEnfant->status??'') }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /mseleves/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('mseleves/' . $mseleve->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('mseleves/' . $mseleve->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('mseleves.destroy',$mseleve)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-mseleves").DataTable();
			creer_champ_visible_lable('mseleves');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
