﻿@extends('Masomwetu.Schedule.schoraires.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('schoraires.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$schoraires->count()}}) Horaires(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-schoraires" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Heure</th>
					<th>Cours</th>
					<th>Période Horaire</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($schoraires as $key => $schoraire)
			<tr>
					
					<td class='editable-td'  k='{{$schoraire->id}}' f='sc_heure_id' i='44' t='select' s='ScHeure' >{{ ($schoraire->scHeure->jour??'').' '.($schoraire->scHeure->num??'').' '.($schoraire->scHeure->num_jr??'') }}</td>
					<td class='editable-td'  k='{{$schoraire->id}}' f='mr_cours_id' i='44' t='select' s='MrCours' >{{ ($schoraire->mrCours->mrCoursPromotion->intitule_cours??'').' '.($schoraire->mrCours->mrCoursPromotion->msPromotion->promotion??'').' '.($schoraire->mrCours->mrCoursPromotion->msPromotion->section->nom_sec??'').' '.($schoraire->mrCours->msClasse->classe??'').' '.($schoraire->mrCours->msClasse->msPromotion->promotion??'').' '.($schoraire->mrCours->msClasse->msPromotion->section->nom_sec??'').' '.($schoraire->mrCours->enseignant->agent->personnel->noms??'').' '.($schoraire->mrCours->enseignant->agent->mcFonction->fonction??'') }}</td>
					<td class='editable-td'  k='{{$schoraire->id}}' f='sc_periode_horaire_id' i='44' t='select' s='ScPeriodeHoraire' >{{ ($schoraire->scPeriodeHoraire->date1??'').' '.($schoraire->scPeriodeHoraire->date2??'') }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /schoraires/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('schoraires/' . $schoraire->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('schoraires/' . $schoraire->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('schoraires.destroy',$schoraire)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-schoraires").DataTable();
			creer_champ_visible_lable('schoraires');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
