﻿@extends('Masomwetu.Salary.saoperationsalaires.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('saoperationsalaires.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$saoperationsalaires->count()}}) Opération sur Salaire(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-saoperationsalaires" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Agent-Salarié</th>
					<th>Mois</th>
					<th>Rubrique de catégorie de bulletin</th>
					<th>Montant</th>
					<th>Date</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($saoperationsalaires as $key => $saoperationsalaire)
			<tr>
					
					<td class='editable-td'  k='{{$saoperationsalaire->id}}' f='sa_salarie_id' i='53' t='select' s='SaSalarie' >{{ ($saoperationsalaire->saSalarie->personnel->noms??'').' '.($saoperationsalaire->saSalarie->saCategorieBulletin->libelle??'').' '.($saoperationsalaire->saSalarie->saCategorieBulletin->montant_sal_brute??'') }}</td>
					<td class='editable-td' k='{{$saoperationsalaire->id}}' f='mois' i='53' t='text' >{{ $saoperationsalaire->mois }}</td>
					<td class='editable-td'  k='{{$saoperationsalaire->id}}' f='sa_rubrique_categorie_bulletin_id' i='53' t='select' s='SaRubriqueCategorieBulletin' >{{ ($saoperationsalaire->saRubriqueCategorieBulletin->saCategorieBulletin->libelle??'').' '.($saoperationsalaire->saRubriqueCategorieBulletin->saCategorieBulletin->montant_sal_brute??'').' '.($saoperationsalaire->saRubriqueCategorieBulletin->saRubriquePaie->libelle??'') }}</td>
					<td class='editable-td' k='{{$saoperationsalaire->id}}' f='montant' i='53' t='number' >{{ $saoperationsalaire->montant }}</td>
					<td class='editable-td' k='{{$saoperationsalaire->id}}' f='jour' i='53' t='date' >{{ $saoperationsalaire->jour }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /saoperationsalaires/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('saoperationsalaires/' . $saoperationsalaire->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('saoperationsalaires/' . $saoperationsalaire->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('saoperationsalaires.destroy',$saoperationsalaire)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-saoperationsalaires").DataTable();
			creer_champ_visible_lable('saoperationsalaires');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
