﻿@extends('Masomwetu.Report.mrcourss.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('mrcourss.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$mrcourss->count()}}) Cours(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-mrcourss" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Cours</th>
					<th>Classe</th>
					<th>Enseignant</th>
					<th>Charge Horaire</th>
					<th>Nbre Hr/Jr</th>
					<th>Nbre Hr. Aff. /Jr</th>
					<th>Aligner?</th>
					<th>Actif</th>
					<th>Est-ce titulaire?</th>
					<th>Alias</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($mrcourss as $key => $mrcours)
			<tr>
					
					<td class='editable-td'  k='{{$mrcours->id}}' f='mr_cours_promotion_id' i='39' t='select' s='MrCoursPromotion' >{{ ($mrcours->mrCoursPromotion->intitule_cours??'').' '.($mrcours->mrCoursPromotion->msPromotion->promotion??'').' '.($mrcours->mrCoursPromotion->msPromotion->section->nom_sec??'') }}</td>
					<td class='editable-td'  k='{{$mrcours->id}}' f='ms_classe_id' i='39' t='select' s='MsClasse' >{{ ($mrcours->msClasse->classe??'').' '.($mrcours->msClasse->msPromotion->promotion??'').' '.($mrcours->msClasse->msPromotion->section->nom_sec??'') }}</td>
					<td class='editable-td'  k='{{$mrcours->id}}' f='enseignant_id' i='39' t='select' s='Enseignant' >{{ ($mrcours->enseignant->agent->personnel->noms??'').' '.($mrcours->enseignant->agent->mcFonction->fonction??'') }}</td>
					<td class='editable-td' k='{{$mrcours->id}}' f='charge_hr' i='39' t='number' >{{ $mrcours->charge_hr }}</td>
					<td class='editable-td' k='{{$mrcours->id}}' f='nbr_hr_par_jr' i='39' t='number' >{{ $mrcours->nbr_hr_par_jr }}</td>
					<td class='editable-td' k='{{$mrcours->id}}' f='nbr_hr_daffilee_par_jr' i='39' t='number' >{{ $mrcours->nbr_hr_daffilee_par_jr }}</td>
					<td class='editable-td' k='{{$mrcours->id}}' f='aligne_cette_annee' i='39' t='checkbox' >{{ $mrcours->aligne_cette_annee }}</td>
					<td class='editable-td' k='{{$mrcours->id}}' f='actif' i='39' t='checkbox' >{{ $mrcours->actif }}</td>
					<td class='editable-td' k='{{$mrcours->id}}' f='est_titulaire' i='39' t='checkbox' >{{ $mrcours->est_titulaire }}</td>
					<td class='editable-td' k='{{$mrcours->id}}' f='aliase_cours' i='39' t='text' >{{ $mrcours->aliase_cours }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /mrcourss/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('mrcourss/' . $mrcours->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('mrcourss/' . $mrcours->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('mrcourss.destroy',$mrcours)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-mrcourss").DataTable();
			creer_champ_visible_lable('mrcourss');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
