﻿@extends('Masomwetu.Report.mrcourspromotions.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('mrcourspromotions.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$mrcourspromotions->count()}}) Cours Promotion(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-mrcourspromotions" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Cours</th>
					<th>Max Période</th>
					<th>Coter l'examen?</th>
					<th>Num Sur Bulletin</th>
					<th>Groupe Cours</th>
					<th>Promotion</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($mrcourspromotions as $key => $mrcourspromotion)
			<tr>
					
					<td class='editable-td' k='{{$mrcourspromotion->id}}' f='intitule_cours' i='37' t='text' >{{ $mrcourspromotion->intitule_cours }}</td>
					<td class='editable-td' k='{{$mrcourspromotion->id}}' f='max_periode' i='37' t='number' >{{ $mrcourspromotion->max_periode }}</td>
					<td class='editable-td' k='{{$mrcourspromotion->id}}' f='coter_examen' i='37' t='checkbox' >{{ $mrcourspromotion->coter_examen }}</td>
					<td class='editable-td' k='{{$mrcourspromotion->id}}' f='num_bulletin' i='37' t='number' >{{ $mrcourspromotion->num_bulletin }}</td>
					<td class='editable-td'  k='{{$mrcourspromotion->id}}' f='mr_groupe_cours_id' i='37' t='select' s='MrGroupeCours' >{{ ($mrcourspromotion->mrGroupeCours->groupe??'') }}</td>
					<td class='editable-td'  k='{{$mrcourspromotion->id}}' f='ms_promotion_id' i='37' t='select' s='MsPromotion' >{{ ($mrcourspromotion->msPromotion->promotion??'').' '.($mrcourspromotion->msPromotion->section->nom_sec??'') }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /mrcourspromotions/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('mrcourspromotions/' . $mrcourspromotion->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('mrcourspromotions/' . $mrcourspromotion->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('mrcourspromotions.destroy',$mrcourspromotion)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-mrcourspromotions").DataTable();
			creer_champ_visible_lable('mrcourspromotions');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
