﻿@extends('Masomwetu.Report.mrcotes.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('mrcotes.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$mrcotes->count()}}) Cote(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-mrcotes" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Elève</th>
					<th>Cours</th>
					<th>Cote-1P</th>
					<th>Cote-2P</th>
					<th>Cote-1E</th>
					<th>Cote-3P</th>
					<th>Cote-4P</th>
					<th>Cote-2E</th>
					<th>Cote-5P</th>
					<th>Cote-6P</th>
					<th>Cote-3E</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($mrcotes as $key => $mrcote)
			<tr>
					
					<td class='editable-td'  k='{{$mrcote->id}}' f='ms_eleve_id' i='40' t='select' s='MsEleve' >{{ ($mrcote->msEleve->enfant->matricule??'').' '.($mrcote->msEleve->enfant->nom??'').' '.($mrcote->msEleve->enfant->postnom??'').' '.($mrcote->msEleve->enfant->prenom??'').' '.($mrcote->msEleve->enfant->genre??'').' '.($mrcote->msEleve->msClasse->classe??'').' '.($mrcote->msEleve->msClasse->msPromotion->promotion??'').' '.($mrcote->msEleve->msClasse->msPromotion->section->nom_sec??'') }}</td>
					<td class='editable-td'  k='{{$mrcote->id}}' f='mr_cours_id' i='40' t='select' s='MrCours' >{{ ($mrcote->mrCours->mrCoursPromotion->intitule_cours??'').' '.($mrcote->mrCours->mrCoursPromotion->msPromotion->promotion??'').' '.($mrcote->mrCours->mrCoursPromotion->msPromotion->section->nom_sec??'').' '.($mrcote->mrCours->msClasse->classe??'').' '.($mrcote->mrCours->msClasse->msPromotion->promotion??'').' '.($mrcote->mrCours->msClasse->msPromotion->section->nom_sec??'').' '.($mrcote->mrCours->enseignant->agent->personnel->noms??'').' '.($mrcote->mrCours->enseignant->agent->mcFonction->fonction??'') }}</td>
					<td class='editable-td' k='{{$mrcote->id}}' f='cote_1' i='40' t='number' >{{ $mrcote->cote_1 }}</td>
					<td class='editable-td' k='{{$mrcote->id}}' f='cote_2' i='40' t='number' >{{ $mrcote->cote_2 }}</td>
					<td class='editable-td' k='{{$mrcote->id}}' f='cote_3' i='40' t='number' >{{ $mrcote->cote_3 }}</td>
					<td class='editable-td' k='{{$mrcote->id}}' f='cote_4' i='40' t='number' >{{ $mrcote->cote_4 }}</td>
					<td class='editable-td' k='{{$mrcote->id}}' f='cote_5' i='40' t='number' >{{ $mrcote->cote_5 }}</td>
					<td class='editable-td' k='{{$mrcote->id}}' f='cote_6' i='40' t='number' >{{ $mrcote->cote_6 }}</td>
					<td class='editable-td' k='{{$mrcote->id}}' f='cote_7' i='40' t='number' >{{ $mrcote->cote_7 }}</td>
					<td class='editable-td' k='{{$mrcote->id}}' f='cote_8' i='40' t='number' >{{ $mrcote->cote_8 }}</td>
					<td class='editable-td' k='{{$mrcote->id}}' f='cote_9' i='40' t='number' >{{ $mrcote->cote_9 }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /mrcotes/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('mrcotes/' . $mrcote->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('mrcotes/' . $mrcote->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('mrcotes.destroy',$mrcote)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-mrcotes").DataTable();
			creer_champ_visible_lable('mrcotes');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
