﻿@extends('Masomwetu.Presence.previsionarriveesorties.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('previsionarriveesorties.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$previsionarriveesorties->count()}}) Prévision des arrivées et sortie(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-previsionarriveesorties" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Agent</th>
					<th>Jour de la semaine</th>
					<th>Heure arrivée</th>
					<th>Heure sortie</th>
					<th>Observation</th>
					<th>Justification</th>
					<th>Date début validité</th>
					<th>Date fin validité</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($previsionarriveesorties as $key => $previsionarriveesortie)
			<tr>
					
					<td class='editable-td'  k='{{$previsionarriveesortie->id}}' f='personnel_id' i='62' t='select' s='Personnel' >{{ ($previsionarriveesortie->personnel->noms??'') }}</td>
					<td class='editable-td' k='{{$previsionarriveesortie->id}}' f='jour_semaine' i='62' t='text' >{{ $previsionarriveesortie->jour_semaine }}</td>
					<td class='editable-td' k='{{$previsionarriveesortie->id}}' f='heure_arrivee' i='62' t='text' >{{ $previsionarriveesortie->heure_arrivee }}</td>
					<td class='editable-td' k='{{$previsionarriveesortie->id}}' f='heure_sortie' i='62' t='text' >{{ $previsionarriveesortie->heure_sortie }}</td>
					<td class='editable-td' k='{{$previsionarriveesortie->id}}' f='observation' i='62' t='text' >{{ $previsionarriveesortie->observation }}</td>
					<td class='editable-td'  k='{{$previsionarriveesortie->id}}' f='justif_absence_id' i='62' t='select' s='JustifAbsence' >{{ ($previsionarriveesortie->justifAbsence->justification??'') }}</td>
					<td class='editable-td' k='{{$previsionarriveesortie->id}}' f='date_debut_validite' i='62' t='date' >{{ $previsionarriveesortie->date_debut_validite }}</td>
					<td class='editable-td' k='{{$previsionarriveesortie->id}}' f='date_fin_validite' i='62' t='date' >{{ $previsionarriveesortie->date_fin_validite }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /previsionarriveesorties/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('previsionarriveesorties/' . $previsionarriveesortie->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('previsionarriveesorties/' . $previsionarriveesortie->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('previsionarriveesorties.destroy',$previsionarriveesortie)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-previsionarriveesorties").DataTable();
			creer_champ_visible_lable('previsionarriveesorties');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
