﻿@extends('Masomwetu.Presence.pointages.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('pointages.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$pointages->count()}}) Pointage(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-pointages" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Date</th>
					<th>Arrivée</th>
					<th>Sortie</th>
					<th>Agent</th>
					<th>Justification</th>
					<th>Arrivée prévue</th>
					<th>Sortie prévue</th>
					<th>Observation</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($pointages as $key => $pointage)
			<tr>
					
					<td class='editable-td' k='{{$pointage->id}}' f='jour' i='59' t='date' >{{ $pointage->jour }}</td>
					<td class='editable-td' k='{{$pointage->id}}' f='arrivee' i='59' t='text' >{{ $pointage->arrivee }}</td>
					<td class='editable-td' k='{{$pointage->id}}' f='sortie' i='59' t='text' >{{ $pointage->sortie }}</td>
					<td class='editable-td'  k='{{$pointage->id}}' f='personnel_id' i='59' t='select' s='Personnel' >{{ ($pointage->personnel->noms??'') }}</td>
					<td class='editable-td'  k='{{$pointage->id}}' f='justif_absence_id' i='59' t='select' s='JustifAbsence' >{{ ($pointage->justifAbsence->justification??'') }}</td>
					<td class='editable-td' k='{{$pointage->id}}' f='arrivee_prevue' i='59' t='text' >{{ $pointage->arrivee_prevue }}</td>
					<td class='editable-td' k='{{$pointage->id}}' f='sortie_prevue' i='59' t='text' >{{ $pointage->sortie_prevue }}</td>
					<td class='editable-td' k='{{$pointage->id}}' f='observation' i='59' t='text' >{{ $pointage->observation }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /pointages/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('pointages/' . $pointage->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('pointages/' . $pointage->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('pointages.destroy',$pointage)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-pointages").DataTable();
			creer_champ_visible_lable('pointages');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
