﻿@extends('Masomwetu.Payment.mptypefraiss.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('mptypefraiss.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$mptypefraiss->count()}}) MpTypeFrais(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-mptypefraiss" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Type de frais</th>
					<th>Description</th>
					<th>Est-ce Argent?</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($mptypefraiss as $key => $mptypefrais)
			<tr>
					
					<td class='editable-td' k='{{$mptypefrais->id}}' f='type' i='11' t='text' >{{ $mptypefrais->type }}</td>
					<td class='editable-td' k='{{$mptypefrais->id}}' f='description' i='11' t='text' >{{ $mptypefrais->description }}</td>
					<td class='editable-td' k='{{$mptypefrais->id}}' f='argent' i='11' t='checkbox' >{{ $mptypefrais->argent }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /mptypefraiss/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('mptypefraiss/' . $mptypefrais->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('mptypefraiss/' . $mptypefrais->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('mptypefraiss.destroy',$mptypefrais)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-mptypefraiss").DataTable();
			creer_champ_visible_lable('mptypefraiss');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
