﻿@extends('Masomwetu.Payment.mpfraiss.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('mpfraiss.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$mpfraiss->count()}}) Frais(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-mpfraiss" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Libelle</th>
					<th>Montant Par défaut</th>
					<th>Type Frais</th>
					<th>Devise</th>
					<th>Année Scolaire</th>
					<th>Ordre de priorité</th>
					<th>Date début</th>
					<th>Date fin</th>
					<th>Date butoire</th>
					<th>Mois</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($mpfraiss as $key => $mpfrais)
			<tr>
					
					<td class='editable-td' k='{{$mpfrais->id}}' f='frais' i='12' t='text' >{{ $mpfrais->frais }}</td>
					<td class='editable-td' k='{{$mpfrais->id}}' f='default_montant' i='12' t='number' >{{ $mpfrais->default_montant }}</td>
					<td class='editable-td'  k='{{$mpfrais->id}}' f='mp_type_frais_id' i='12' t='select' s='MpTypeFrais' >{{ ($mpfrais->mpTypeFrais->type??'') }}</td>
					<td class='editable-td' k='{{$mpfrais->id}}' f='devise' i='12' t='text' >{{ $mpfrais->devise }}</td>
					<td class='editable-td'  k='{{$mpfrais->id}}' f='ms_annee_scolaire_id' i='12' t='select' s='MsAnneeScolaire' >{{ ($mpfrais->msAnneeScolaire->annee??'').' '.($mpfrais->msAnneeScolaire->ecole->nom_ecole??'') }}</td>
					<td class='editable-td' k='{{$mpfrais->id}}' f='priorite' i='12' t='number' >{{ $mpfrais->priorite }}</td>
					<td class='editable-td'  k='{{$mpfrais->id}}' f='date_debut_paiement' i='12' t='date' >{{ ($mpfrais->date_debut_paiement) }}</td>
					<td class='editable-td'  k='{{$mpfrais->id}}' f='fin_date_paiement' i='12' t='date'>{{ ($mpfrais->fin_date_paiement) }}</td>
					<td class='editable-td'  k='{{$mpfrais->id}}' f='date_butoire' i='12' t='date' s='' >{{ ($mpfrais->date_butoire) }}</td>
					<td class='editable-td'  k='{{$mpfrais->id}}' f='mc_mois_id' i='12' t='select' s='s' >{{ ($mpfrais->mcMois->mois??'') }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /mpfraiss/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('mpfraiss/' . $mpfrais->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('mpfraiss/' . $mpfrais->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('mpfraiss.destroy',$mpfrais)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-mpfraiss").DataTable();
			creer_champ_visible_lable('mpfraiss');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
