﻿@extends('Masomwetu.Disciplinary.mdpresences.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('mdpresences.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$mdpresences->count()}}) Presence(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-mdpresences" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Elève</th>
					<th>Période</th>
					<th>Date</th>
					<th>Minute de retard</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($mdpresences as $key => $mdpresence)
			<tr>
					
					<td class='editable-td'  k='{{$mdpresence->id}}' f='ms_eleve_id' i='26' t='select' s='MsEleve' >{{ ($mdpresence->msEleve->enfant->matricule??'').' '.($mdpresence->msEleve->enfant->nom??'').' '.($mdpresence->msEleve->enfant->postnom??'').' '.($mdpresence->msEleve->enfant->prenom??'').' '.($mdpresence->msEleve->enfant->genre??'').' '.($mdpresence->msEleve->msClasse->classe??'').' '.($mdpresence->msEleve->msClasse->msPromotion->promotion??'').' '.($mdpresence->msEleve->msClasse->msPromotion->section->nom_sec??'') }}</td>
					<td class='editable-td'  k='{{$mdpresence->id}}' f='periode_id' i='26' t='select' s='Periode' >{{ ($mdpresence->periode->periode??'').' '.($mdpresence->periode->etat??'') }}</td>
					<td class='editable-td' k='{{$mdpresence->id}}' f='presence_date' i='26' t='date' >{{ $mdpresence->presence_date }}</td>
					<td class='editable-td' k='{{$mdpresence->id}}' f='nbre_min_retard' i='26' t='text' >{{ $mdpresence->nbre_min_retard }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /mdpresences/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('mdpresences/' . $mdpresence->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('mdpresences/' . $mdpresence->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('mdpresences.destroy',$mdpresence)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-mdpresences").DataTable();
			creer_champ_visible_lable('mdpresences');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
