﻿@extends('Masomwetu.Disciplinary.mdmentions.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('mdmentions.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$mdmentions->count()}}) Mentions Conduite(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-mdmentions" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Borne supérieure</th>
					<th>Borne Inférieure</th>
					<th>Mention</th>
					<th>Description</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($mdmentions as $key => $mdmention)
			<tr>
					
					<td class='editable-td' k='{{$mdmention->id}}' f='borne_sup' i='28' t='number' >{{ $mdmention->borne_sup }}</td>
					<td class='editable-td' k='{{$mdmention->id}}' f='borne_inf' i='28' t='number' >{{ $mdmention->borne_inf }}</td>
					<td class='editable-td' k='{{$mdmention->id}}' f='mention' i='28' t='text' >{{ $mdmention->mention }}</td>
					<td class='editable-td' k='{{$mdmention->id}}' f='description' i='28' t='text' >{{ $mdmention->description }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /mdmentions/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('mdmentions/' . $mdmention->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('mdmentions/' . $mdmention->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('mdmentions.destroy',$mdmention)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-mdmentions").DataTable();
			creer_champ_visible_lable('mdmentions');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
