﻿@extends('Masomwetu.Disciplinary.mdeleverenvoyers.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('mdeleverenvoyers.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$mdeleverenvoyers->count()}}) Elève Renvoyé(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-mdeleverenvoyers" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Elève</th>
					<th>Motif</th>
					<th>Détail</th>
					<th>Date renvoi</th>
					<th>Date retour</th>
					<th>Condition retour</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($mdeleverenvoyers as $key => $mdeleverenvoyer)
			<tr>
					
					<td class='editable-td'  k='{{$mdeleverenvoyer->id}}' f='ms_eleve_id' i='27' t='select' s='MsEleve' >{{ ($mdeleverenvoyer->msEleve->enfant->matricule??'').' '.($mdeleverenvoyer->msEleve->enfant->nom??'').' '.($mdeleverenvoyer->msEleve->enfant->postnom??'').' '.($mdeleverenvoyer->msEleve->enfant->prenom??'').' '.($mdeleverenvoyer->msEleve->enfant->genre??'').' '.($mdeleverenvoyer->msEleve->msClasse->classe??'').' '.($mdeleverenvoyer->msEleve->msClasse->msPromotion->promotion??'').' '.($mdeleverenvoyer->msEleve->msClasse->msPromotion->section->nom_sec??'') }}</td>
					<td class='editable-td' k='{{$mdeleverenvoyer->id}}' f='motif' i='27' t='text' >{{ $mdeleverenvoyer->motif }}</td>
					<td class='editable-td' k='{{$mdeleverenvoyer->id}}' f='detail' i='27' t='text' >{{ $mdeleverenvoyer->detail }}</td>
					<td class='editable-td' k='{{$mdeleverenvoyer->id}}' f='date_renvoi' i='27' t='date' >{{ $mdeleverenvoyer->date_renvoi }}</td>
					<td class='editable-td' k='{{$mdeleverenvoyer->id}}' f='date_retour' i='27' t='date' >{{ $mdeleverenvoyer->date_retour }}</td>
					<td class='editable-td' k='{{$mdeleverenvoyer->id}}' f='condition' i='27' t='text' >{{ $mdeleverenvoyer->condition }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /mdeleverenvoyers/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('mdeleverenvoyers/' . $mdeleverenvoyer->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('mdeleverenvoyers/' . $mdeleverenvoyer->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('mdeleverenvoyers.destroy',$mdeleverenvoyer)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-mdeleverenvoyers").DataTable();
			creer_champ_visible_lable('mdeleverenvoyers');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
