﻿@extends('Masomwetu.Disciplinary.mdcommentaires.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('mdcommentaires.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$mdcommentaires->count()}}) Commentaire(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-mdcommentaires" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Elève</th>
					<th>Période</th>
					<th>Date</th>
					<th>Importance</th>
					<th>Motif</th>
					<th>Détail</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($mdcommentaires as $key => $mdcommentaire)
			<tr>
					
					<td class='editable-td'  k='{{$mdcommentaire->id}}' f='ms_eleve_id' i='20' t='select' s='MsEleve' >{{ ($mdcommentaire->msEleve->enfant->matricule??'').' '.($mdcommentaire->msEleve->enfant->nom??'').' '.($mdcommentaire->msEleve->enfant->postnom??'').' '.($mdcommentaire->msEleve->enfant->prenom??'').' '.($mdcommentaire->msEleve->enfant->genre??'').' '.($mdcommentaire->msEleve->msClasse->classe??'').' '.($mdcommentaire->msEleve->msClasse->msPromotion->promotion??'').' '.($mdcommentaire->msEleve->msClasse->msPromotion->section->nom_sec??'') }}</td>
					<td class='editable-td'  k='{{$mdcommentaire->id}}' f='periode_id' i='20' t='select' s='Periode' >{{ ($mdcommentaire->periode->periode??'').' '.($mdcommentaire->periode->etat??'') }}</td>
					<td class='editable-td' k='{{$mdcommentaire->id}}' f='coment_date' i='20' t='date' >{{ $mdcommentaire->coment_date }}</td>
					<td class='editable-td' k='{{$mdcommentaire->id}}' f='importance' i='20' t='text' >{{ $mdcommentaire->importance }}</td>
					<td class='editable-td'  k='{{$mdcommentaire->id}}' f='motif_commentaire_id' i='20' t='select' s='MotifCommentaire' >{{ ($mdcommentaire->motifCommentaire->motif??'') }}</td>
					<td class='editable-td' k='{{$mdcommentaire->id}}' f='detail' i='20' t='text' >{{ $mdcommentaire->detail }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /mdcommentaires/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('mdcommentaires/' . $mdcommentaire->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('mdcommentaires/' . $mdcommentaire->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('mdcommentaires.destroy',$mdcommentaire)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-mdcommentaires").DataTable();
			creer_champ_visible_lable('mdcommentaires');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
