﻿@extends('Masomwetu.Disciplinary.mdabsences.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('mdabsences.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$mdabsences->count()}}) Absence(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-mdabsences" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Elève</th>
					<th>Période</th>
					<th>Date</th>
					<th>Date Justification</th>
					<th>Détail Justification</th>
					<th>Jour de cours</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($mdabsences as $key => $mdabsence)
			<tr>
					
					<td class='editable-td'  k='{{$mdabsence->id}}' f='ms_eleve_id' i='25' t='select' s='MsEleve' >{{ ($mdabsence->msEleve->enfant->matricule??'').' '.($mdabsence->msEleve->enfant->nom??'').' '.($mdabsence->msEleve->enfant->postnom??'').' '.($mdabsence->msEleve->enfant->prenom??'').' '.($mdabsence->msEleve->enfant->genre??'').' '.($mdabsence->msEleve->msClasse->classe??'').' '.($mdabsence->msEleve->msClasse->msPromotion->promotion??'').' '.($mdabsence->msEleve->msClasse->msPromotion->section->nom_sec??'') }}</td>
					<td class='editable-td'  k='{{$mdabsence->id}}' f='periode_id' i='25' t='select' s='Periode' >{{ ($mdabsence->periode->periode??'').' '.($mdabsence->periode->etat??'') }}</td>
					<td class='editable-td' k='{{$mdabsence->id}}' f='absence_date' i='25' t='date' >{{ $mdabsence->absence_date }}</td>
					<td class='editable-td' k='{{$mdabsence->id}}' f='justif_date' i='25' t='date' >{{ $mdabsence->justif_date }}</td>
					<td class='editable-td' k='{{$mdabsence->id}}' f='justif_detail' i='25' t='text' >{{ $mdabsence->justif_detail }}</td>
					<td class='editable-td'  k='{{$mdabsence->id}}' f='md_abs_jour_id' i='25' t='select' s='MdAbsJour' >{{ ($mdabsence->mdAbsJour->date_jour??'').' '.($mdabsence->mdAbsJour->msClasse->classe??'').' '.($mdabsence->mdAbsJour->msClasse->msPromotion->promotion??'').' '.($mdabsence->mdAbsJour->msClasse->msPromotion->section->nom_sec??'') }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /mdabsences/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('mdabsences/' . $mdabsence->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('mdabsences/' . $mdabsence->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('mdabsences.destroy',$mdabsence)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-mdabsences").DataTable();
			creer_champ_visible_lable('mdabsences');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
