﻿@extends('Masomwetu.Disciplinary.absjustifabsences.main')

@section('content')


@section('liste-title')
	Il y a ({{$absjustifabsences->count()}}) (s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-absjustifabsences" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Absence de</th>
					<th>Motif</th>
					<th>Observation</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($absjustifabsences as $key => $absjustifabsence)
			<tr>
					
					<td>{{ ($absjustifabsence->absEleveAbsent->msEleve->enfant->matricule??'').' '.($absjustifabsence->absEleveAbsent->msEleve->enfant->nom??'').' '.($absjustifabsence->absEleveAbsent->msEleve->enfant->postnom??'').' '.($absjustifabsence->absEleveAbsent->msEleve->enfant->prenom??'').' '.($absjustifabsence->absEleveAbsent->msEleve->enfant->genre??'').' '.($absjustifabsence->absEleveAbsent->msEleve->msClasse->classe??'').' '.($absjustifabsence->absEleveAbsent->msEleve->msClasse->ms_promotion_id??'').' '.($absjustifabsence->absEleveAbsent->absJour->date_jour??'') }}</td>
					<td>{{ ($absjustifabsence->absMotifAbsence->motif_absence??'') }}</td>
					<td>{{ $absjustifabsence->observation }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /absjustifabsences/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('absjustifabsences/' . $absjustifabsence->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('absjustifabsences/' . $absjustifabsence->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('absjustifabsences.destroy',$absjustifabsence)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-absjustifabsences").DataTable();
			creer_champ_visible_lable('absjustifabsences');
			
	});
	</script>
@endsection
