﻿@extends('Masomwetu.Comptabilite.rapportjournaliers.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('rapportjournaliers.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$rapportjournaliers->count()}}) Rapport Journalier(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-rapportjournaliers" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Repport CDF</th>
					<th>Repport USD</th>
					<th>Encaissement CDF</th>
					<th>Encaissement USD</th>
					<th>Décaissement CDF</th>
					<th>Décaissement USD</th>
					<th>Date</th>
					<th>Déjà comptabilisé</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($rapportjournaliers as $key => $rapportjournalier)
			<tr>
					
					<td class='editable-td' k='{{$rapportjournalier->id}}' f='report_cdf' i='70' t='text' >{{ $rapportjournalier->report_cdf }}</td>
					<td class='editable-td' k='{{$rapportjournalier->id}}' f='report_usd' i='70' t='text' >{{ $rapportjournalier->report_usd }}</td>
					<td class='editable-td' k='{{$rapportjournalier->id}}' f='encaissement_cdf' i='70' t='text' >{{ $rapportjournalier->encaissement_cdf }}</td>
					<td class='editable-td' k='{{$rapportjournalier->id}}' f='encaissement_usd' i='70' t='text' >{{ $rapportjournalier->encaissement_usd }}</td>
					<td class='editable-td' k='{{$rapportjournalier->id}}' f='decaissement_cdf' i='70' t='text' >{{ $rapportjournalier->decaissement_cdf }}</td>
					<td class='editable-td' k='{{$rapportjournalier->id}}' f='decaissement_usd' i='70' t='text' >{{ $rapportjournalier->decaissement_usd }}</td>
					<td class='editable-td' k='{{$rapportjournalier->id}}' f='date_rapport' i='70' t='date' >{{ $rapportjournalier->date_rapport }}</td>
					<td class='editable-td' k='{{$rapportjournalier->id}}' f='deja_comptabiliser' i='70' t='checkbox' >{{ $rapportjournalier->deja_comptabiliser }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /rapportjournaliers/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('rapportjournaliers/' . $rapportjournalier->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('rapportjournaliers/' . $rapportjournalier->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('rapportjournaliers.destroy',$rapportjournalier)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-rapportjournaliers").DataTable();
			creer_champ_visible_lable('rapportjournaliers');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
