﻿@extends('Masomwetu.Comptabilite.rapportannuels.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('rapportannuels.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$rapportannuels->count()}}) Rapport Annuel(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-rapportannuels" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Repport CDF</th>
					<th>Repport USD</th>
					<th>Encaissement CDF</th>
					<th>Encaissement USD</th>
					<th>Décaissement CDF</th>
					<th>Décaissement USD</th>
					<th>Année</th>
					<th>Déjà comptabilisé</th>
					<th>Etabli le</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($rapportannuels as $key => $rapportannuel)
			<tr>
					
					<td class='editable-td' k='{{$rapportannuel->id}}' f='report_cdf' i='72' t='text' >{{ $rapportannuel->report_cdf }}</td>
					<td class='editable-td' k='{{$rapportannuel->id}}' f='report_usd' i='72' t='text' >{{ $rapportannuel->report_usd }}</td>
					<td class='editable-td' k='{{$rapportannuel->id}}' f='encaissement_cdf' i='72' t='text' >{{ $rapportannuel->encaissement_cdf }}</td>
					<td class='editable-td' k='{{$rapportannuel->id}}' f='encaissement_usd' i='72' t='text' >{{ $rapportannuel->encaissement_usd }}</td>
					<td class='editable-td' k='{{$rapportannuel->id}}' f='decaissement_cdf' i='72' t='text' >{{ $rapportannuel->decaissement_cdf }}</td>
					<td class='editable-td' k='{{$rapportannuel->id}}' f='decaissement_usd' i='72' t='text' >{{ $rapportannuel->decaissement_usd }}</td>
					<td class='editable-td' k='{{$rapportannuel->id}}' f='annee_rapport' i='72' t='text' >{{ $rapportannuel->annee_rapport }}</td>
					<td class='editable-td' k='{{$rapportannuel->id}}' f='deja_comptabiliser' i='72' t='checkbox' >{{ $rapportannuel->deja_comptabiliser }}</td>
					<td class='editable-td' k='{{$rapportannuel->id}}' f='date_rapport' i='72' t='date' >{{ $rapportannuel->date_rapport }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /rapportannuels/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('rapportannuels/' . $rapportannuel->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('rapportannuels/' . $rapportannuel->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('rapportannuels.destroy',$rapportannuel)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-rapportannuels").DataTable();
			creer_champ_visible_lable('rapportannuels');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
