﻿@extends('Masomwetu.Comptabilite.comptes.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('comptes.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$comptes->count()}}) Compte(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-comptes" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Imputation</th>
					<th>Code</th>
					<th>Libellé</th>
					<th>Catégorie</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($comptes as $key => $compte)
			<tr>
					
					<td class='editable-td' k='{{$compte->id}}' f='imputation' i='66' t='text' >{{ $compte->imputation }}</td>
					<td class='editable-td' k='{{$compte->id}}' f='code' i='66' t='text' >{{ $compte->code }}</td>
					<td class='editable-td' k='{{$compte->id}}' f='libelle' i='66' t='text' >{{ $compte->libelle }}</td>
					<td class='editable-td'  k='{{$compte->id}}' f='categorie_compte_id' i='66' t='select' s='CategorieCompte' >{{ ($compte->categorieCompte->categorie??'') }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /comptes/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('comptes/' . $compte->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('comptes/' . $compte->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('comptes.destroy',$compte)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-comptes").DataTable();
			creer_champ_visible_lable('comptes');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
