﻿@extends('Masomwetu.Communication.mcsmstypes.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('mcsmstypes.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$mcsmstypes->count()}}) Type SMS(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-mcsmstypes" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Type</th>
					<th>Description</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($mcsmstypes as $key => $mcsmstype)
			<tr>
					
					<td class='editable-td' k='{{$mcsmstype->id}}' f='type' i='36' t='text' >{{ $mcsmstype->type }}</td>
					<td class='editable-td' k='{{$mcsmstype->id}}' f='description' i='36' t='text' >{{ $mcsmstype->description }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /mcsmstypes/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('mcsmstypes/' . $mcsmstype->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('mcsmstypes/' . $mcsmstype->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('mcsmstypes.destroy',$mcsmstype)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-mcsmstypes").DataTable();
			creer_champ_visible_lable('mcsmstypes');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
