﻿@extends('Masomwetu.Communication.mcsmss.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('mcsmss.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$mcsmss->count()}}) Sms(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-mcsmss" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Téléphone</th>
					<th>Message</th>
					<th>Propriétaire</th>
					<th>Status</th>
					<th>Date</th>
					<th>Type</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($mcsmss as $key => $mcsms)
			<tr>
					
					<td class='editable-td' k='{{$mcsms->id}}' f='telephone' i='35' t='text' >{{ $mcsms->telephone }}</td>
					<td class='editable-td' k='{{$mcsms->id}}' f='message' i='35' t='text' >{{ $mcsms->message }}</td>
					<td class='editable-td' k='{{$mcsms->id}}' f='proprietaire' i='35' t='text' >{{ $mcsms->proprietaire }}</td>
					<td class='editable-td' k='{{$mcsms->id}}' f='status' i='35' t='text' >{{ $mcsms->status }}</td>
					<td class='editable-td' k='{{$mcsms->id}}' f='date_send' i='35' t='date' >{{ $mcsms->date_send }}</td>
					<td class='editable-td'  k='{{$mcsms->id}}' f='mc_sms_type_id' i='35' t='select' s='McSmsType' >{{ ($mcsms->mcSmsType->type??'') }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /mcsmss/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('mcsmss/' . $mcsms->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('mcsmss/' . $mcsms->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('mcsmss.destroy',$mcsms)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-mcsmss").DataTable();
			creer_champ_visible_lable('mcsmss');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
