﻿@extends('Masomwetu.Cash.cashfichesorties.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('cashfichesorties.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$cashfichesorties->count()}}) Fiche Sortie(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-cashfichesorties" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Catégorie</th>
					<th>Motif</th>
					<th>Montant</th>
					<th>Dévise</th>
					<th>Demandée par</th>
					<th>Autorisée par</th>
					<th>Date</th>
					<th>Année Scolaire</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($cashfichesorties as $key => $cashfichesortie)
			<tr>
					
					<td class='editable-td'  k='{{$cashfichesortie->id}}' f='cash_categorie_id' i='31' t='select' s='CashCategorie' >{{ ($cashfichesortie->cashCategorie->categorie??'') }}</td>
					<td class='editable-td' k='{{$cashfichesortie->id}}' f='motif' i='31' t='text' >{{ $cashfichesortie->motif }}</td>
					<td class='editable-td' k='{{$cashfichesortie->id}}' f='montant' i='31' t='text' >{{ $cashfichesortie->montant }}</td>
					<td class='editable-td' k='{{$cashfichesortie->id}}' f='devise' i='31' t='text' >{{ $cashfichesortie->devise }}</td>
					<td class='editable-td' k='{{$cashfichesortie->id}}' f='demandee_par' i='31' t='text' >{{ $cashfichesortie->demandee_par }}</td>
					<td class='editable-td' k='{{$cashfichesortie->id}}' f='autorisee_per' i='31' t='text' >{{ $cashfichesortie->autorisee_per }}</td>
					<td class='editable-td' k='{{$cashfichesortie->id}}' f='date_fiche' i='31' t='date' >{{ $cashfichesortie->date_fiche }}</td>
					<td class='editable-td'  k='{{$cashfichesortie->id}}' f='ms_annee_scolaire_id' i='31' t='select' s='MsAnneeScolaire' >{{ ($cashfichesortie->msAnneeScolaire->annee??'').' '.($cashfichesortie->msAnneeScolaire->ecole->nom_ecole??'') }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /cashfichesorties/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('cashfichesorties/' . $cashfichesortie->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('cashfichesorties/' . $cashfichesortie->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('cashfichesorties.destroy',$cashfichesortie)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-cashfichesorties").DataTable();
			creer_champ_visible_lable('cashfichesorties');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
