﻿@extends('Masomwetu.Allocation.emprunts.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('emprunts.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$emprunts->count()}}) Emprunt(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-emprunts" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Eleve</th>
					<th>Materiel</th>
					<th>Quantite</th>
					<th>Date Emprunt</th>
					<th>Date retour</th>
					<th>Qte Retour</th>
					<th>Image Aller</th>
					<th>Aller Retour</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($emprunts as $key => $emprunt)
			<tr>
					
					<td class='editable-td'  k='{{$emprunt->id}}' f='ms_eleve_id' i='74' t='select' s='MsEleve' >{{ ($emprunt->msEleve->enfant->matricule??'').' '.($emprunt->msEleve->enfant->nom??'').' '.($emprunt->msEleve->enfant->postnom??'').' '.($emprunt->msEleve->enfant->prenom??'').' '.($emprunt->msEleve->enfant->genre??'').' '.($emprunt->msEleve->msClasse->classe??'').' '.($emprunt->msEleve->msClasse->msPromotion->promotion??'').' '.($emprunt->msEleve->msClasse->msPromotion->section->nom_sec??'') }}</td>
					<td class='editable-td'  k='{{$emprunt->id}}' f='materiel_id' i='74' t='select' s='Materiel' >{{ ($emprunt->materiel->materiel??'').' '.($emprunt->materiel->quantite??'') }}</td>
					<td class='editable-td' k='{{$emprunt->id}}' f='quantite' i='74' t='number' >{{ $emprunt->quantite }}</td>
					<td class='editable-td' k='{{$emprunt->id}}' f='date_emprunt' i='74' t='date' >{{ $emprunt->date_emprunt }}</td>
					<td class='editable-td' k='{{$emprunt->id}}' f='date_retour' i='74' t='date' >{{ $emprunt->date_retour }}</td>
					<td class='editable-td' k='{{$emprunt->id}}' f='qte_retour' i='74' t='number' >{{ $emprunt->qte_retour }}</td>
					<td class='editable-td' k='{{$emprunt->id}}' f='img_aller' i='74' t='file' ><img class='crud_img' src="{{ asset('storage/emprunt/img_aller/'.$emprunt->img_aller) }}" /></td>
					<td class='editable-td' k='{{$emprunt->id}}' f='img_retour' i='74' t='file' ><img class='crud_img' src="{{ asset('storage/emprunt/img_retour/'.$emprunt->img_retour) }}" /></td>

						<!-- delete the nerd (uses the destroy method DESTROY /emprunts/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('emprunts/' . $emprunt->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('emprunts/' . $emprunt->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('emprunts.destroy',$emprunt)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-emprunts").DataTable();
			creer_champ_visible_lable('emprunts');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
