﻿@extends('Masomwetu.Allocation.empruntmateriels.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('empruntmateriels.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$empruntmateriels->count()}}) EmpruntMateriel(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-empruntmateriels" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Eleve</th>
					<th>Materiel</th>
					<th>Quantite</th>
					<th>Date Emprunt</th>
					<th>Date retour</th>
					<th>Qte Retour</th>
					<th>Image Aller</th>
					<th>Aller Retour</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($empruntmateriels as $key => $empruntmateriel)
			<tr>
					
					<td class='editable-td'  k='{{$empruntmateriel->id}}' f='ms_eleve_id' i='74' t='select' s='MsEleve' >{{ ($empruntmateriel->msEleve->enfant->matricule??'').' '.($empruntmateriel->msEleve->enfant->nom??'').' '.($empruntmateriel->msEleve->enfant->postnom??'').' '.($empruntmateriel->msEleve->enfant->prenom??'').' '.($empruntmateriel->msEleve->enfant->genre??'').' '.($empruntmateriel->msEleve->msClasse->classe??'').' '.($empruntmateriel->msEleve->msClasse->msPromotion->promotion??'').' '.($empruntmateriel->msEleve->msClasse->msPromotion->section->nom_sec??'') }}</td>
					<td class='editable-td'  k='{{$empruntmateriel->id}}' f='materiel_id' i='74' t='select' s='Materiel' >{{ ($empruntmateriel->materiel->materiel??'').' '.($empruntmateriel->materiel->quantite??'') }}</td>
					<td class='editable-td' k='{{$empruntmateriel->id}}' f='quantite' i='74' t='number' >{{ $empruntmateriel->quantite }}</td>
					<td class='editable-td' k='{{$empruntmateriel->id}}' f='date_emprunt' i='74' t='date' >{{ $empruntmateriel->date_emprunt }}</td>
					<td class='editable-td' k='{{$empruntmateriel->id}}' f='date_retour' i='74' t='date' >{{ $empruntmateriel->date_retour }}</td>
					<td class='editable-td' k='{{$empruntmateriel->id}}' f='qte_retour' i='74' t='number' >{{ $empruntmateriel->qte_retour }}</td>
					<td class='editable-td' k='{{$empruntmateriel->id}}' f='img_aller' i='74' t='file' ><img class='crud_img' src="{{ asset('storage/empruntmateriel/img_aller/'.$empruntmateriel->img_aller) }}" /></td>
					<td class='editable-td' k='{{$empruntmateriel->id}}' f='img_retour' i='74' t='file' ><img class='crud_img' src="{{ asset('storage/empruntmateriel/img_retour/'.$empruntmateriel->img_retour) }}" /></td>

						<!-- delete the nerd (uses the destroy method DESTROY /empruntmateriels/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('empruntmateriels/' . $empruntmateriel->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('empruntmateriels/' . $empruntmateriel->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('empruntmateriels.destroy',$empruntmateriel)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-empruntmateriels").DataTable();
			creer_champ_visible_lable('empruntmateriels');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
