<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateRapportAnnuelsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('rapport_annuels', function (Blueprint $table) {
            $table->bigIncrements('id');

						$table->double('report_cdf')->nullable();
						$table->double('report_usd')->nullable();
						$table->double('encaissement_cdf')->nullable();
						$table->double('encaissement_usd')->nullable();
						$table->double('decaissement_cdf')->nullable();
						$table->double('decaissement_usd')->nullable();
						$table->double('annee_rapport');
						$table->boolean('deja_comptabiliser');
						$table->date('date_rapport');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('rapport_annuels');
    }
}
