<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMouvementComptesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('mouvement_comptes', function (Blueprint $table) {
            $table->bigIncrements('id');

						$table->unsignedInteger('compte_id');
						$table->foreign('compte_id')->references('id')->on('comptes')->onDelete('cascade');
						$table->double('montant_cdf')->nullable();
						$table->double('montant_usd')->nullable();
						$table->date('date_mouv');
						$table->unsignedInteger('user_id');
						$table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
						$table->boolean('deja_comptabiliser');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mouvement_comptes');
    }
}
