<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Masomwetu\Sys\SysUserRole; 
use App\Masomwetu\Sys\SysZone; 

use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
class User  extends Authenticatable
{ 
    use Notifiable;
    protected $table = "bulletin_users";

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password', 'sys_user_role_id', 'ms_annee_scolaire_id',
    ];
    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
	protected $guarded = [];
	// public $timestamps = false;

	public function sysUserRoles(){
		return $this->hasMany(SysUserRole::class);
	}
	
	public function user_acces_to_zone($zone){
		$useroles = $this->sysUserRoles;
		$tab = [];
		foreach($useroles as $ur){
			$zones = $ur->sysRole->sysAccessLevels;
			// $tab[] = $zones;
			foreach($zones as $z){
				$tab[] = $z->sysZone;
				if($z->sysZone->zone == $zone)return true;
			}
		}
		// dd($tab);
        $zone = SysZone::firstOrCreate(['zone'=>$zone],['zone_desc'=>'automaticly added'])->get();
        
		return false;
	}

}
