<?php

namespace App\Masomwetu\School;

use Illuminate\Database\Eloquent\Model;
use App\Masomwetu\Report\MrCoteModifiee;
use App\Masomwetu\Salary\SaSalarie;
use App\Masomwetu\School\Agent;
use App\Masomwetu\School\DossierPersonnel;
use App\Masomwetu\School\NiveauEtudePersonnel;
use App\Masomwetu\Presence\Pointage;
use App\Masomwetu\Presence\PrevisionArriveeSortie; 

class Personnel extends Model
{
    //
		protected $guarded = [];
		public $timestamps = true;

		public function mrCoteModifiees(){
			return $this->hasMany(MrCoteModifiee::class);
		}

		public function saSalaries(){
			return $this->hasMany(SaSalarie::class);
		}

		public function agents(){
			return $this->hasMany(Agent::class);
		}

		public function dossierPersonnels(){
			return $this->hasMany(DossierPersonnel::class);
		}

		public function niveauEtudePersonnels(){
			return $this->hasMany(NiveauEtudePersonnel::class);
		}

		public function pointages(){
			return $this->hasMany(Pointage::class);
		}

		public function previsionArriveeSorties(){
			return $this->hasMany(PrevisionArriveeSortie::class);
		}
}
